/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorage
extends BlockEnderUtilitiesInventory {
    protected static final AxisAlignedBB SINGLE_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final PropertyEnum<EnumStorageType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStorageType.class);

    public BlockStorage(String name, float hardness, int harvestLevel, Material material) {
        super(name, hardness, harvestLevel, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.MEMORY_CHEST_0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FACING});
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public String[] getUnlocalizedNames() {
        return new String[]{"memorychest.0", "memorychest.1", "memorychest.2", "handychest.0", "handychest.1", "handychest.2"};
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        EnumStorageType type = (EnumStorageType)((Object)state.func_177229_b(TYPE));
        switch (type) {
            case MEMORY_CHEST_0: {
                return new TileEntityMemoryChest();
            }
            case MEMORY_CHEST_1: {
                return new TileEntityMemoryChest();
            }
            case MEMORY_CHEST_2: {
                return new TileEntityMemoryChest();
            }
            case HANDY_CHEST_0: {
                return new TileEntityHandyChest();
            }
            case HANDY_CHEST_1: {
                return new TileEntityHandyChest();
            }
            case HANDY_CHEST_2: {
                return new TileEntityHandyChest();
            }
        }
        return new TileEntityMemoryChest();
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ITieredStorage) {
            int meta = state.func_177230_c().func_176201_c(state);
            ((ITieredStorage)te).setStorageTier(meta % 3);
        }
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityHandyChest) {
            ((TileEntityHandyChest)te).onLeftClickBlock(playerIn);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityEnderUtilities && (facing = EnumFacing.func_82600_a((int)((TileEntityEnderUtilities)te).getRotation())).func_176740_k().func_176722_c()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return state;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 6; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public static enum EnumStorageType implements IStringSerializable
    {
        MEMORY_CHEST_0("memorychest.0"),
        MEMORY_CHEST_1("memorychest.1"),
        MEMORY_CHEST_2("memorychest.2"),
        HANDY_CHEST_0("handychest.0"),
        HANDY_CHEST_1("handychest.1"),
        HANDY_CHEST_2("handychest.2");

        private final String name;

        private EnumStorageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static EnumStorageType fromMeta(int meta) {
            return meta < EnumStorageType.values().length ? EnumStorageType.values()[meta] : MEMORY_CHEST_0;
        }
    }
}

