/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BuildersWandRenderer {
    public Minecraft mc = Minecraft.func_71410_x();
    public float partialTicksLast;
    List<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ItemStack stack = this.mc.field_71439_g.func_71045_bC();
        if (stack == null || stack.func_77973_b() != EnderUtilitiesItems.buildersWand) {
            return;
        }
        this.renderSelectedArea((World)this.mc.field_71441_e, (EntityPlayer)this.mc.field_71439_g, stack, event.partialTicks);
    }

    public static AxisAlignedBB makeBlockBoundingBox(int x, int y, int z, double partialTicks, EntityPlayer player) {
        double offset1 = 0.0;
        double offset2 = 1.0;
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return AxisAlignedBB.func_178781_a((double)((double)x - offset1 - dx), (double)((double)y - offset1 - dy), (double)((double)z - offset1 - dz), (double)((double)x + offset2 - dx), (double)((double)y + offset2 - dy), (double)((double)z + offset2 - dz));
    }

    public void renderSelectedArea(World world, EntityPlayer player, ItemStack stack, float partialTicks) {
        ItemBuildersWand item = (ItemBuildersWand)stack.func_77973_b();
        BlockPosEU posTargeted = item.getPosition(stack, true);
        MovingObjectPosition mop = this.mc.field_71476_x;
        if (posTargeted == null && mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (player.func_70093_af() && mop.field_178784_b == EnumFacing.UP) {
                return;
            }
            posTargeted = new BlockPosEU(mop.func_178782_a(), player.field_71093_bK, mop.field_178784_b);
        }
        if (posTargeted == null || player.field_71093_bK != posTargeted.dimension) {
            return;
        }
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        BlockPosEU posStart = posTargeted.offset(posTargeted.side, 1);
        BlockPosEU posEnd = item.getPosition(stack, false);
        BlockPosEU blockPosEU = posEnd = posEnd != null && (mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE) ? posEnd.offset(posEnd.side, 1) : null;
        if (partialTicks < this.partialTicksLast) {
            this.positions.clear();
            if (mode == ItemBuildersWand.Mode.CUBE || mode == ItemBuildersWand.Mode.WALLS) {
                item.getBlockPositionsWalls(stack, posTargeted, world, this.positions, posStart, posEnd);
            } else {
                item.getBlockPositions(stack, posTargeted.toBlockPos(), posTargeted.side, world, this.positions);
            }
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        boolean renderGhostBlocks = NBTUtils.getBoolean(stack, "BuildersWand", "Ghost");
        if (renderGhostBlocks) {
            this.renderGhostBlocks(player, partialTicks);
        }
        GlStateManager.func_179090_x();
        if (!renderGhostBlocks) {
            this.renderBlockOutlines(player, posStart, posEnd, partialTicks);
        }
        this.renderStartAndEndPositions(mode, player, posStart, posEnd, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    public void renderBlockOutlines(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        GL11.glLineWidth((float)2.0f);
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPosEU pos = this.positions.get(i);
            if (pos.equals(posStart) || posEnd != null && posEnd.equals(pos)) continue;
            AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(pos.posX, pos.posY, pos.posZ, partialTicks, player);
            RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)255, (int)255, (int)255, (int)255);
        }
    }

    public void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        AxisAlignedBB aabb;
        if (posStart != null) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posStart.posX, posStart.posY, posStart.posZ, partialTicks, player);
            RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)255, (int)17, (int)17, (int)255);
        }
        if (posEnd != null && (mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE)) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posEnd.posX, posEnd.posY, posEnd.posZ, partialTicks, player);
            RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)17, (int)17, (int)255, (int)255);
        }
    }

    public void renderGhostBlocks(EntityPlayer player, float partialTicks) {
        BlockPosStateDist pos;
        int i;
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (partialTicks < this.partialTicksLast) {
            for (i = 0; i < this.positions.size(); ++i) {
                pos = this.positions.get(i);
                pos.setSquaredDistance(pos.getSquaredDistanceFrom(dx, dy, dz));
            }
            Collections.sort(this.positions);
            Collections.reverse(this.positions);
        }
        for (i = 0; i < this.positions.size(); ++i) {
            pos = this.positions.get(i);
            BlockInfo blockInfo = pos.blockInfo;
            if (blockInfo == null || blockInfo.block == null) continue;
            IBlockState state = blockInfo.block.func_176203_a(blockInfo.blockMeta);
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
            GlStateManager.func_179137_b((double)((double)pos.posX - dx + 0.0), (double)((double)pos.posY - dy + 0.0), (double)((double)pos.posZ - dz + 1.0));
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(state, 1.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

