/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.client.renderer.item.BuildersWandRenderer;
import fi.dy.masa.enderutilities.item.ItemRuler;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RulerRenderer {
    public Minecraft mc = Minecraft.func_71410_x();
    public float partialTicks;
    public float partialTicksLast;
    Map<Integer, List<BlockPosEU>> positions = new HashMap<Integer, List<BlockPosEU>>();
    public String modeStrDim = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.dimensions");
    public String modeStrDiff = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.difference");
    public static int[] colors = new int[]{0x70FFFF, 0xFF70FF, 0xFFFF70, 10748365, 0x1C1CC3, 14255372, 1287228, 15540789};

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.partialTicks = event.partialTicks;
        this.renderAllPositionPairs();
        this.partialTicksLast = this.partialTicks;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.renderHud();
    }

    public void renderHud() {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (!(stack != null && stack.func_77973_b() == EnderUtilitiesItems.ruler || (stack = InventoryUtils.getFirstMatchingItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.ruler)) != null && ((ItemRuler)stack.func_77973_b()).getRenderWhenUnselected(stack))) {
            return;
        }
        ItemRuler item = (ItemRuler)stack.func_77973_b();
        int selected = item.getLocationSelection(stack);
        BlockPosEU posStart = item.getPosition(stack, selected, true);
        BlockPosEU posEnd = item.getPosition(stack, selected, false);
        if (posStart == null && posEnd == null) {
            return;
        }
        if (posStart == null) {
            posStart = posEnd;
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)(player.field_70163_u - 1.6), (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP.func_176745_a());
        } else if (posEnd == null) {
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)(player.field_70163_u - 1.6), (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP.func_176745_a());
        }
        if (posStart != null && posStart.dimension != player.field_71093_bK || posEnd != null && posEnd.dimension != player.field_71093_bK) {
            return;
        }
        int lenX = Math.abs(posStart.posX - posEnd.posX);
        int lenY = Math.abs(posStart.posY - posEnd.posY);
        int lenZ = Math.abs(posStart.posZ - posEnd.posZ);
        String modeStr = this.modeStrDiff;
        if (!item.getDistanceMode(stack)) {
            ++lenX;
            ++lenY;
            ++lenZ;
            modeStr = this.modeStrDim;
        }
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        int scaledY = scaledResolution.func_78328_b();
        int x = 0;
        int y = scaledY - 16;
        this.mc.field_71466_p.func_175065_a(modeStr + " X: " + lenX + ", Y: " + lenY + ", Z: " + lenZ, (float)(x + 10), (float)y, -9371649, true);
    }

    public void renderAllPositionPairs() {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (!(stack != null && stack.func_77973_b() == EnderUtilitiesItems.ruler || (stack = InventoryUtils.getFirstMatchingItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.ruler)) != null && ((ItemRuler)stack.func_77973_b()).getRenderWhenUnselected(stack))) {
            return;
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        ItemRuler item = (ItemRuler)stack.func_77973_b();
        int selected = item.getLocationSelection(stack);
        if (item.getRenderAllLocations(stack)) {
            int count = item.getLocationCount(stack);
            for (int i = 0; i < count; ++i) {
                int color;
                int n = color = i < colors.length ? colors[i] : 0x70FFFF;
                if (i == selected || !item.getAlwaysRenderLocation(stack, i)) continue;
                BlockPosEU posStart = item.getPosition(stack, i, true);
                BlockPosEU posEnd = item.getPosition(stack, i, false);
                this.renderPointPair((EntityPlayer)player, posStart, posEnd, color, this.partialTicks);
            }
        }
        BlockPosEU posStart = item.getPosition(stack, selected, true);
        BlockPosEU posEnd = item.getPosition(stack, selected, false);
        this.renderPointPair((EntityPlayer)player, posStart, posEnd, 0xFFFFFF, this.partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
    }

    public void renderPointPair(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, int color, float partialTicks) {
        if (posStart != null && posStart.dimension != player.field_71093_bK || posEnd != null && posEnd.dimension != player.field_71093_bK) {
            return;
        }
        this.updatePositions(player, posStart, posEnd);
        this.renderPositions(player, posStart, posEnd, color, partialTicks);
        this.renderStartAndEndPositions(player, posStart, posEnd, partialTicks);
    }

    public void renderPositions(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, int color, float partialTicks) {
        GL11.glLineWidth((float)2.0f);
        for (int a = 0; a < 3; ++a) {
            List<BlockPosEU> column = this.positions.get(a);
            if (column == null) continue;
            for (int i = 0; i < column.size(); ++i) {
                BlockPosEU pos = column.get(i);
                AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(pos.posX, pos.posY, pos.posZ, partialTicks, player);
                RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)(color >>> 16 & 0xFF), (int)(color >>> 8 & 0xFF), (int)(color & 0xFF), (int)255);
            }
        }
    }

    public void renderStartAndEndPositions(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        AxisAlignedBB aabb;
        if (posStart != null) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posStart.posX, posStart.posY, posStart.posZ, partialTicks, player);
            RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)255, (int)17, (int)17, (int)255);
        }
        if (posEnd != null) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posEnd.posX, posEnd.posY, posEnd.posZ, partialTicks, player);
            RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)17, (int)17, (int)255, (int)255);
        }
    }

    public void updatePositions(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd) {
        int i;
        if (posStart == null && posEnd == null) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.positions.remove(i2);
            }
            return;
        }
        if (posStart == null) {
            posStart = posEnd;
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)(player.field_70163_u - 1.6), (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP.func_176745_a());
        } else if (posEnd == null) {
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)(player.field_70163_u - 1.6), (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP.func_176745_a());
        }
        BlockPosEU[] pos = new BlockPosEU[]{posStart, posEnd};
        int[] done = new int[]{0, 0, 0};
        for (i = 0; i < 3; ++i) {
            BlockPosAligner aligner = new BlockPosAligner(pos[0], pos[1], player);
            BlockPosEU aligned = aligner.getAlignedPointAlongLongestAxis();
            int furthest = aligner.furthestPoint;
            if (aligner.axisLength > 0) {
                boolean includeStart = !aligned.equals(pos[0]) && !aligned.equals(pos[1]);
                this.positions.put(aligner.longestAxis, this.getColumn(aligned, pos[furthest], aligner.longestAxis, includeStart, false));
                done[aligner.longestAxis] = 1;
            }
            pos[furthest] = aligned;
        }
        for (i = 0; i < 3; ++i) {
            if (done[i] != 0) continue;
            this.positions.remove(i);
        }
    }

    public List<BlockPosEU> getColumn(BlockPosEU posNear, BlockPosEU posFar, int axis, boolean includeStart, boolean includeEnd) {
        ArrayList<BlockPosEU> list;
        block5: {
            int maxLength;
            int[] p2;
            int[] p1;
            block4: {
                int inc;
                list = new ArrayList<BlockPosEU>();
                p1 = new int[]{posNear.posX, posNear.posY, posNear.posZ};
                p2 = new int[]{posFar.posX, posFar.posY, posFar.posZ};
                int n = inc = p1[axis] < p2[axis] ? 1 : -1;
                if (!includeStart) {
                    int n2 = axis;
                    p1[n2] = p1[n2] + inc;
                }
                if (!includeEnd) {
                    int n3 = axis;
                    p2[n3] = p2[n3] - inc;
                }
                maxLength = 160;
                if (p1[axis] > p2[axis]) break block4;
                for (int i = 0; i < maxLength && p1[axis] <= p2[axis]; ++i) {
                    list.add(new BlockPosEU(p1[0], p1[1], p1[2], posNear.dimension, posNear.face));
                    int n4 = axis;
                    p1[n4] = p1[n4] + 1;
                }
                break block5;
            }
            if (p1[axis] <= p2[axis]) break block5;
            for (int i = 0; i < maxLength && p1[axis] >= p2[axis]; ++i) {
                list.add(new BlockPosEU(p1[0], p1[1], p1[2], posNear.dimension, posNear.face));
                int n = axis;
                p1[n] = p1[n] - 1;
            }
        }
        return list;
    }

    public class BlockPosAligner {
        public final double[] playerPos;
        public int longestAxis;
        public int axisLength;
        public int furthestPoint;
        public int[][] points;

        public BlockPosAligner(BlockPosEU p1, BlockPosEU p2, EntityPlayer player) {
            this.playerPos = new double[]{player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v};
            this.points = new int[][]{{p1.posX, p1.posY, p1.posZ}, {p2.posX, p2.posY, p2.posZ}};
        }

        public int getLongestAxisLength() {
            this.getLongestAxis();
            return this.axisLength;
        }

        public int getLongestAxis() {
            int longest = 0;
            int length = Math.abs(this.points[0][0] - this.points[1][0]);
            for (int i = 1; i < 3; ++i) {
                int tmp = Math.abs(this.points[0][i] - this.points[1][i]);
                if (tmp <= length) continue;
                longest = i;
                length = tmp;
            }
            this.longestAxis = longest;
            this.axisLength = length;
            return longest;
        }

        public int getFurthestPointIndexOnLongestAxis() {
            double len1;
            int axisId = this.getLongestAxis();
            double len0 = Math.abs(this.playerPos[axisId] - ((double)this.points[0][axisId] + 0.5));
            this.furthestPoint = len0 > (len1 = Math.abs(this.playerPos[axisId] - ((double)this.points[1][axisId] + 0.5))) ? 0 : 1;
            return this.furthestPoint;
        }

        public BlockPosEU getAlignedPointAlongLongestAxis() {
            int far = this.getFurthestPointIndexOnLongestAxis();
            int near = far ^ 1;
            int[] p = new int[]{this.points[far][0], this.points[far][1], this.points[far][2]};
            p[this.longestAxis] = this.points[near][this.longestAxis];
            return new BlockPosEU(p[0], p[1], p[2]);
        }
    }
}

