/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TaskBuildersWand
implements IPlayerTask {
    protected int dimension;
    protected UUID playerUUID;
    protected List<BlockPosStateDist> positions;
    protected int blocksPerTick;
    protected int listIndex;
    protected int placedCount;
    protected int failCount;

    public TaskBuildersWand(World world, UUID playerUUID, List<BlockPosStateDist> positions, int blocksPerTick) {
        this.dimension = world.field_73011_w.func_177502_q();
        this.playerUUID = playerUUID;
        this.positions = positions;
        this.blocksPerTick = blocksPerTick;
        this.listIndex = 0;
        this.placedCount = 0;
        this.failCount = 0;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.func_177502_q() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.buildersWand) {
            int i = 0;
            while (i < this.blocksPerTick && this.listIndex < this.positions.size()) {
                if (ItemBuildersWand.placeBlockToPosition(stack, world, player, this.positions.get(this.listIndex))) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++i;
                }
                ++this.listIndex;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            return true;
        }
        if (this.listIndex >= this.positions.size()) {
            if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.buildersWand) {
                ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
                BlockPosEU pos = ((ItemBuildersWand)stack.func_77973_b()).getPosition(stack, true);
                if (pos != null && mode != ItemBuildersWand.Mode.WALLS && mode != ItemBuildersWand.Mode.CUBE) {
                    ((ItemBuildersWand)stack.func_77973_b()).setPosition(stack, pos.offset(pos.side, 1), true);
                }
                world.func_72956_a((Entity)player, "note.pling", 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        EnderUtilities.logger.info("TaskBuildersWand exiting, placed " + this.placedCount + " blocks in total.");
        this.positions.clear();
    }
}

