/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventoryItem
extends ItemStackHandlerBasic {
    protected ItemStack containerStack;
    protected final EntityPlayer player;
    protected boolean isRemote;
    protected UUID containerUUID;
    protected IItemHandler hostInventory;

    public InventoryItem(ItemStack containerStack, int invSize, boolean isRemote, EntityPlayer player) {
        this(containerStack, invSize, 64, false, isRemote, player, "Items");
    }

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, player, "Items");
    }

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player, String tagName) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, player, tagName, null, null);
    }

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player, String tagName, UUID containerUUID, IItemHandler hostInv) {
        super(invSize, stackLimit, allowCustomStackSizes, tagName);
        this.containerStack = containerStack;
        this.player = player;
        this.isRemote = isRemote;
        this.containerUUID = containerUUID;
        this.hostInventory = hostInv;
    }

    public void setIsRemote(boolean isRemote) {
        this.isRemote = isRemote;
    }

    protected void clearInventory() {
        for (int i = 0; i < this.invSize; ++i) {
            this.items[i] = null;
        }
    }

    public void setItemStorageTagName(String tagName) {
        if (tagName != null) {
            this.tagName = tagName;
        }
    }

    public UUID getContainerUUID() {
        return this.containerUUID;
    }

    public void setHostInventory(IItemHandler inv) {
        this.hostInventory = inv;
    }

    public void setHostInventory(IItemHandler inv, UUID uuid) {
        this.hostInventory = inv;
        this.containerUUID = uuid;
    }

    public ItemStack getContainerItemStack() {
        if (this.containerUUID != null && this.hostInventory != null) {
            return InventoryUtils.getItemStackByUUID(this.hostInventory, this.containerUUID, "UUID");
        }
        return this.containerStack;
    }

    public void setContainerItemStack(ItemStack stack) {
        this.containerStack = stack;
        this.readFromContainerItemStack();
    }

    public void readFromContainerItemStack() {
        if (!this.isRemote) {
            this.clearInventory();
            ItemStack stack = this.getContainerItemStack();
            if (stack != null && stack.func_77942_o() && this.isUseableByPlayer(this.player)) {
                this.deserializeNBT(stack.func_77978_p());
            }
        }
    }

    protected void writeToContainerItemStack() {
        ItemStack stack;
        if (!this.isRemote && (stack = this.getContainerItemStack()) != null && this.isUseableByPlayer(this.player)) {
            NBTUtils.writeItemsToContainerItem(stack, this.items, this.tagName, true);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        ItemStack stack = this.getContainerItemStack();
        if (stack == null) {
            return false;
        }
        NBTHelperPlayer ownerData = NBTHelperPlayer.getPlayerDataFromItem(stack);
        return ownerData == null || ownerData.canAccess(player);
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimitFromContainerStack(this.getContainerItemStack());
    }

    public int getInventoryStackLimitFromContainerStack(ItemStack stack) {
        int tier;
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.enderPart && (tier = ((IModule)stack.func_77973_b()).getModuleTier(stack)) >= 6 && tier <= 12) {
            return (int)Math.pow(2.0, tier);
        }
        return super.getInventoryStackLimit();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.getContainerItemStack() != null;
    }

    @Override
    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (!this.isRemote) {
            this.writeToContainerItemStack();
        }
    }
}

