/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class InventoryItemCrafting
extends InventoryCrafting {
    protected final EntityPlayer player;
    protected final ItemStack[] items;
    protected final int invSize;
    protected final int stackLimit;
    protected final boolean isRemote;
    protected String itemsTagName;
    protected ItemStack containerStack;
    protected Container container;
    protected IModularInventoryHolder callback;

    public InventoryItemCrafting(Container container, int width, int height, ItemStack containerStack, boolean isRemote, EntityPlayer player, IModularInventoryHolder callback, String tagName) {
        super(container, width, height);
        this.container = container;
        this.containerStack = containerStack;
        this.invSize = width * height;
        this.player = player;
        this.isRemote = isRemote;
        this.stackLimit = 64;
        this.callback = callback;
        this.itemsTagName = tagName;
        this.items = new ItemStack[this.invSize];
    }

    public void setCallback(IModularInventoryHolder callback) {
        this.callback = callback;
    }

    public ItemStack getContainerItemStack() {
        if (this.callback != null) {
            return this.callback.getContainerStack();
        }
        return this.containerStack;
    }

    protected void clearInventory() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public void setItemStorageTagName(String tagName) {
        if (tagName != null) {
            this.itemsTagName = tagName;
        }
    }

    public void setContainerItemStack(ItemStack stack) {
        this.containerStack = stack;
        this.readFromContainerItemStack();
    }

    public void readFromContainerItemStack() {
        if (!this.isRemote) {
            this.clearInventory();
            ItemStack stack = this.getContainerItemStack();
            if (stack != null && this.func_70300_a(this.player)) {
                NBTUtils.readStoredItemsFromTag(stack.func_77978_p(), this.items, this.itemsTagName);
            }
        }
    }

    protected void writeToContainerItemStack() {
        ItemStack stack;
        if (!this.isRemote && (stack = this.getContainerItemStack()) != null && this.func_70300_a(this.player)) {
            NBTUtils.writeItemsToContainerItem(stack, this.items, this.itemsTagName, true);
        }
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public ItemStack func_70301_a(int slotNum) {
        if (slotNum < this.items.length) {
            return this.items[slotNum];
        }
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack newStack) {
        if (slotNum < this.items.length) {
            this.items[slotNum] = newStack;
            this.func_70296_d();
        } else {
            EnderUtilities.logger.warn("InventoryItemCrafting.setInventorySlotContents(): Invalid slot number: " + slotNum);
        }
    }

    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        ItemStack stack = null;
        if (slotNum < this.items.length) {
            if (this.items[slotNum] != null) {
                if (this.items[slotNum].field_77994_a >= maxAmount) {
                    stack = this.items[slotNum].func_77979_a(maxAmount);
                    if (this.items[slotNum].field_77994_a <= 0) {
                        this.items[slotNum] = null;
                    }
                } else {
                    stack = this.items[slotNum];
                    this.items[slotNum] = null;
                }
            }
        } else {
            EnderUtilities.logger.warn("InventoryItemCrafting.decrStackSize(): Invalid slot number: " + slotNum);
            return null;
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slotNum) {
        ItemStack stack = null;
        if (slotNum < this.items.length) {
            stack = this.items[slotNum];
            this.items[slotNum] = null;
            this.func_70296_d();
        }
        return stack;
    }

    public int func_70297_j_() {
        int tier;
        ItemStack stack = this.getContainerItemStack();
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.enderPart && (tier = ((IModule)stack.func_77973_b()).getModuleTier(stack)) >= 6 && tier <= 12) {
            return (int)Math.pow(2.0, tier);
        }
        return this.stackLimit;
    }

    public boolean func_94041_b(int slotNum, ItemStack stack) {
        return this.getContainerItemStack() != null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        ItemStack stack = this.getContainerItemStack();
        if (stack == null) {
            return false;
        }
        NBTHelperPlayer ownerData = NBTHelperPlayer.getPlayerDataFromItem(stack);
        return ownerData == null || ownerData.canAccess(player);
    }

    public void func_70296_d() {
        if (!this.isRemote) {
            this.writeToContainerItemStack();
        }
        this.container.func_75130_a((IInventory)this);
    }
}

