/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerInventorySwapper;
import fi.dy.masa.enderutilities.inventory.InventoryItemModular;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemInventorySwapper
extends ItemInventoryModular
implements IKeyBound,
IKeyBoundUnselected {
    public static final String TAG_NAME_CONTAINER = "InventorySwpapper";
    public static final String TAG_NAME_PRESET_SELECTION = "SelectedPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_CHANGE_PRESET = 1;
    public static final int GUI_ACTION_TOGGLE_ROWS = 2;
    public static final int GUI_ACTION_TOGGLE_COLUMNS = 3;

    public ItemInventorySwapper() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("inventoryswapper");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.openGui((Object)EnderUtilities.instance, 1003, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (player.func_70093_af() && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (!world.field_72995_K && inv != null) {
                this.swapInventory(stack, inv, player);
            }
            return true;
        }
        return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = super.func_77653_i(stack);
        String preGreenIta = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
        String preGreen = EnumChatFormatting.GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
        int slotNum = UtilItemModular.getStoredModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(stack, slotNum, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (moduleStack != null && moduleStack.func_77978_p() != null && moduleStack.func_82837_s()) {
            itemName = itemName.length() >= 14 ? EUStringUtils.getInitialsWithDots(itemName) + " " + preGreenIta + moduleStack.func_82833_r() + rst : itemName + " " + preGreenIta + moduleStack.func_82833_r() + rst;
        }
        itemName = itemName + " MC: " + preGreen + (slotNum + 1) + rst;
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        itemName = itemName + " P: " + preGreen + (selected + 1) + rst;
        return itemName;
    }

    @Override
    public void addInformationSelective(ItemStack containerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String preWhite = EnumChatFormatting.WHITE.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String str = ItemInventorySwapper.isEnabled(containerStack) ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no");
        list.add(str);
        byte selected = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.preset") + ": " + preBlue + (selected + 1) + rst);
        int installed = this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (installed > 0) {
            int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            String preWhiteIta = preWhite + EnumChatFormatting.ITALIC.toString();
            String strShort = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.short");
            ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(containerStack, slotNum, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            int max = this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (moduleStack != null && moduleStack.func_77973_b() == EnderUtilitiesItems.enderPart) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
                ((ItemEnderPart)moduleStack.func_77973_b()).addInformationSelective(moduleStack, player, list, advancedTooltips, false);
                return;
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nomemorycards"));
        }
    }

    @Override
    public int getSizeInventory(ItemStack containerStack) {
        return 40;
    }

    public static boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    public static int getSlotContainingEnabledItem(EntityPlayer player) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.inventorySwapper);
        for (int slot : slots) {
            if (!ItemInventorySwapper.isEnabled(player.field_71071_by.func_70301_a(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getEnabledItem(EntityPlayer player) {
        int slotNum = ItemInventorySwapper.getSlotContainingEnabledItem(player);
        return slotNum != -1 ? player.field_71071_by.func_70301_a(slotNum) : null;
    }

    public static long getEnabledSlotsMask(ItemStack stack) {
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        return NBTUtils.getLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + selected);
    }

    public void swapInventory(long slotMask, InventoryItemModular swapperInv, IItemHandler externalInv) {
        int invSize = Math.min(36, externalInv.getSlots());
        long bit = 1L;
        for (int i = 0; i < invSize; ++i) {
            if ((slotMask & bit) != 0L) {
                ItemStack stackSwapper = swapperInv.extractItem(i, 64, false);
                ItemStack stackExternal = externalInv.extractItem(i, 64, false);
                if (swapperInv.insertItem(i, stackExternal, true) == null && externalInv.insertItem(i, stackSwapper, true) == null) {
                    swapperInv.insertItem(i, stackExternal, false);
                    externalInv.insertItem(i, stackSwapper, false);
                } else {
                    swapperInv.insertItem(i, stackSwapper, false);
                    externalInv.insertItem(i, stackExternal, false);
                }
            }
            bit <<= 1;
        }
    }

    public void swapInventory(ItemStack swapperStack, IItemHandler inv, EntityPlayer player) {
        InventoryItemModular swapperInv = new InventoryItemModular(swapperStack, player, false, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!swapperInv.isUseableByPlayer(player)) {
            return;
        }
        this.swapInventory(ItemInventorySwapper.getEnabledSlotsMask(swapperStack), swapperInv, inv);
        player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
    }

    public static void swapPlayerInventory(int swapperSlot, EntityPlayer player) {
        ItemStack swapperStack = player.field_71071_by.func_70301_a(swapperSlot);
        if (swapperStack == null) {
            return;
        }
        InventoryItemModular inv = new InventoryItemModular(swapperStack, player, false, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!inv.isUseableByPlayer(player)) {
            return;
        }
        long mask = ItemInventorySwapper.getEnabledSlotsMask(swapperStack);
        int invMax = player.field_71071_by.func_70297_j_();
        int invSize = player.field_71071_by.func_70302_i_();
        int mainInvSize = player.field_71071_by.field_70462_a.length;
        long bit = 1L;
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack tmpStack;
            if (slot != swapperSlot && (mask & bit) != 0L && ((tmpStack = inv.getStackInSlot(slot)) == null || tmpStack.field_77994_a <= Math.min(tmpStack.func_77976_d(), invMax) && player.field_71071_by.func_94041_b(slot, tmpStack))) {
                if (slot >= mainInvSize) {
                    int pos;
                    int n = pos = tmpStack != null ? EntityLiving.func_82159_b((ItemStack)tmpStack) : slot - mainInvSize + 1;
                    if (pos > 0 && pos == slot - mainInvSize + 1) {
                        inv.setStackInSlot(slot, player.field_71071_by.func_70301_a(slot));
                        player.field_71071_by.func_70299_a(slot, tmpStack);
                    }
                } else {
                    inv.setStackInSlot(slot, player.field_71071_by.func_70301_a(slot));
                    player.field_71071_by.func_70299_a(slot, tmpStack);
                }
            }
            bit <<= 1;
        }
        player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
    }

    public static void swapPlayerInventory(EntityPlayer player) {
        int slot = ItemInventorySwapper.getSlotContainingEnabledItem(player);
        if (slot != -1) {
            ItemInventorySwapper.swapPlayerInventory(slot, player);
        }
    }

    @Override
    public void doUnselectedKeyAction(EntityPlayer player, ItemStack stack, int key) {
        stack = ItemInventorySwapper.getEnabledItem(player);
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.inventorySwapper) {
            ((ItemInventorySwapper)stack.func_77973_b()).doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            ItemInventorySwapper.swapPlayerInventory(player);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        }
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        ItemStack stack;
        if (player.field_71070_bA instanceof ContainerInventorySwapper && (stack = ((ContainerInventorySwapper)player.field_71070_bA).getModularItem()) != null && stack.func_77973_b() == EnderUtilitiesItems.inventorySwapper) {
            int max = ((ItemInventorySwapper)stack.func_77973_b()).getMaxModules(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (action == 0 && element >= 0 && element < max) {
                UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, element);
                ((ContainerInventorySwapper)player.field_71070_bA).inventoryItemModular.readFromContainerItemStack();
            } else if (action == 1 && element >= 0 && element < 4) {
                NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            } else if (action == 2 && element >= 0 && element < 4) {
                long mask = ItemInventorySwapper.getEnabledSlotsMask(stack);
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask ^= 511L << element * 9);
            } else if (action == 3) {
                long mask = ItemInventorySwapper.getEnabledSlotsMask(stack);
                if (element >= 0 && element < 9) {
                    mask ^= 134480385L << element;
                } else if (element == 9) {
                    mask ^= 0xF000000000L;
                }
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask);
            }
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) ? this.getMaxModules(containerStack) : 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        IModule imodule;
        if (moduleStack.func_77973_b() instanceof IModule && (imodule = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && imodule.getModuleTier(moduleStack) == 6) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "locked=false"), new ModelResourceLocation(rl, "locked=true")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "locked=" + NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED));
    }
}

