/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBound;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemLocationBoundModular
extends ItemLocationBound
implements IModular,
IKeyBound {
    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            if (!world.field_72995_K) {
                boolean adjustPosHit = UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0;
                this.setTarget(stack, player, pos, side, hitX, hitY, hitZ, adjustPosHit, false);
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, entity, slot, isCurrent);
        if (!(world.field_72995_K || !EnergyBridgeTracker.dimensionHasEnergyBridge(world.field_73011_w.func_177502_q()) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_71039_bw() && ((EntityPlayer)entity).func_71045_bC() == stack || world.field_73011_w.func_177502_q() != 1 && !EnergyBridgeTracker.dimensionHasEnergyBridge(1))) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public String getTargetDisplayName(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ILocationBound) {
            if (moduleStack.func_82837_s()) {
                NBTTagCompound tag = moduleStack.func_77978_p().func_74775_l("display");
                return EnumChatFormatting.ITALIC.toString() + tag.func_74779_i("Name") + EnumChatFormatting.RESET.toString();
            }
            return ((ILocationBound)moduleStack.func_77973_b()).getTargetDisplayName(moduleStack);
        }
        return super.getTargetDisplayName(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String targetName = this.getTargetDisplayName(stack);
        if (targetName != null && targetName.length() > 0) {
            String preGreen = EnumChatFormatting.GREEN.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
            if (itemName.length() >= 14) {
                itemName = EUStringUtils.getInitialsWithDots(itemName);
            }
            return itemName + " " + preGreen + targetName + rst;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (stack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        if (linkCrystalStack != null) {
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                super.addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
                String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (verbose) {
            ItemStack capacitorStack;
            if (this.getMaxModules(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                String s = this.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.jailer") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.jailer") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
                list.add(s);
            }
            if ((capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
                ((ItemEnderCapacitor)capacitorStack.func_77973_b()).func_77624_a(capacitorStack, player, list, advancedTooltips);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        super.addTooltips(stack, list, verbose);
        ItemLocationBoundModular.addTooltips("enderutilities.tooltips.itemlocationboundmodular", list, verbose);
    }

    @Override
    public void setTarget(ItemStack stack, EntityPlayer player, boolean storeRotation) {
        UtilItemModular.setTarget(stack, player, storeRotation);
    }

    @Override
    public void setTarget(ItemStack toolStack, EntityPlayer player, BlockPos pos, EnumFacing side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        UtilItemModular.setTarget(toolStack, player, pos, side, hitX, hitY, hitZ, doHitOffset, storeRotation);
    }

    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return false;
    }

    @Override
    public void changePrivacyMode(ItemStack containerStack, EntityPlayer player) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(containerStack, player, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        } else {
            UtilItemModular.changePrivacyModeOnSelectedModule(containerStack, player, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public int getInstalledModuleCount(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getInstalledModuleCount(containerStack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(containerStack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.getSelectedModuleTierAbs(containerStack, moduleType);
        }
        return UtilItemModular.getSelectedModuleTier(containerStack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            return UtilItemModular.getSelectedModuleStackAbs(containerStack, moduleType);
        }
        return UtilItemModular.getSelectedModuleStack(containerStack, moduleType);
    }

    @Override
    public boolean setSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.setSelectedModuleStackAbs(containerStack, moduleType, moduleStack);
        }
        return UtilItemModular.setSelectedModuleStack(containerStack, moduleType, moduleStack);
    }

    @Override
    public boolean changeSelectedModule(ItemStack containerStack, ItemModule.ModuleType moduleType, boolean reverse) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            return UtilItemModular.changeSelectedModuleAbs(containerStack, moduleType, reverse);
        }
        return UtilItemModular.changeSelectedModule(containerStack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack containerStack) {
        return UtilItemModular.getAllModules(containerStack);
    }

    @Override
    public boolean setAllModules(ItemStack containerStack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(containerStack, modules);
    }

    @Override
    public boolean setModule(ItemStack containerStack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(containerStack, index, nbt);
    }
}

