/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.enderutilities.client.effects.Effects;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemEnderSword
extends ItemLocationBoundModular {
    public static final int ENDER_CHARGE_COST = 50;
    private float damageVsEntity;
    private final Item.ToolMaterial material = ItemEnderTool.ENDER_ALLOY_ADVANCED;

    public ItemEnderSword() {
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.setNoRepair();
        this.damageVsEntity = 5.0f + this.material.func_78000_c();
        this.func_77655_b("endersword");
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ILocationBound) {
            String targetName;
            String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                String pre = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + moduleStack.func_82833_r() + rst;
                }
                return itemName + " " + pre + moduleStack.func_82833_r() + rst;
            }
            if (moduleStack.func_77973_b() instanceof ItemLinkCrystal && (targetName = ((ItemLinkCrystal)moduleStack.func_77973_b()).getTargetDisplayName(moduleStack)) != null) {
                return itemName + " " + EnumChatFormatting.GREEN.toString() + targetName + rst;
            }
        }
        return super.func_77653_i(stack);
    }

    public boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (stack == null || this.isToolBroken(stack)) {
            return false;
        }
        amount = Math.min(amount, this.getMaxDamage(stack) - stack.func_77952_i());
        stack.func_77972_a(amount, living2);
        if (this.isToolBroken(stack)) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack == null || stack.func_77952_i() >= this.getMaxDamage(stack);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 1.5f;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attacker) {
        if (targetEntity != null && !targetEntity.field_70170_p.field_72995_K && SwordMode.fromStack(stack) == SwordMode.SUMMON) {
            this.summonFighterEndermen(targetEntity.field_70170_p, targetEntity, 3);
        }
        return this.addToolDamage(stack, 1, targetEntity, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase playerIn) {
        if (block.func_176195_g(world, pos) != 0.0f && !this.isToolBroken(stack)) {
            int amount = Math.min(2, this.getMaxDamage(stack) - stack.func_77952_i());
            stack.func_77972_a(amount, playerIn);
            if (this.isToolBroken(stack)) {
                playerIn.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    private IItemHandler getLinkedInventoryWithChecks(ItemStack toolStack, EntityPlayer player) {
        SwordMode mode = SwordMode.fromStack(toolStack);
        if (mode == SwordMode.NORMAL) {
            return null;
        }
        if (mode == SwordMode.PLAYER && !(player instanceof FakePlayer) && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 2) {
            return new PlayerMainInvWrapper(player.field_71071_by);
        }
        if (mode == SwordMode.REMOTE && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 1 && UtilItemModular.useEnderCharge(toolStack, 50, true)) {
            return UtilItemModular.getBoundInventory(toolStack, player, 30);
        }
        return null;
    }

    private ItemStack tryTeleportItems(ItemStack itemsIn, ItemStack toolStack, EntityPlayer player) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) != 2) {
            return itemsIn;
        }
        WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
        if (targetWorld == null) {
            return itemsIn;
        }
        ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4, 30);
        EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, itemsIn.func_77946_l());
        entityItem.field_70179_y = 0.0;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.15;
        if (targetWorld.func_72838_d((Entity)entityItem)) {
            Effects.spawnParticles((World)targetWorld, EnumParticleTypes.PORTAL, target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
            return null;
        }
        return itemsIn;
    }

    public void handleLivingDropsEvent(ItemStack toolStack, LivingDropsEvent event) {
        EntityItem item;
        if (event.entity.field_70170_p.field_72995_K || this.isToolBroken(toolStack) || event.drops == null || event.drops.size() == 0) {
            return;
        }
        SwordMode mode = SwordMode.fromStack(toolStack);
        if (mode == SwordMode.NORMAL || mode == SwordMode.SUMMON) {
            return;
        }
        boolean transported = false;
        EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
        Iterator iter = event.drops.iterator();
        IItemHandler inv = this.getLinkedInventoryWithChecks(toolStack, player);
        while (iter.hasNext()) {
            item = (EntityItem)iter.next();
            ItemStack stack = item.func_92059_d();
            if (stack == null || stack.func_77973_b() == null) {
                iter.remove();
                continue;
            }
            ItemStack stackTmp = stack;
            if (mode == SwordMode.PLAYER && MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, item))) {
                Effects.addItemTeleportEffects(player.field_70170_p, player.func_180425_c());
                stackTmp = null;
            } else if (inv != null) {
                stackTmp = InventoryUtils.tryInsertItemStackToInventory(inv, stack.func_77946_l());
            } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
                stackTmp = this.tryTeleportItems(stack, toolStack, player);
            }
            if (stackTmp == null || stackTmp.field_77994_a <= 0) {
                iter.remove();
                transported = true;
                continue;
            }
            if (stackTmp.field_77994_a == stack.field_77994_a) continue;
            stack.field_77994_a = stackTmp.field_77994_a;
            item.func_92058_a(stack);
            transported = true;
        }
        if (transported) {
            if (mode == SwordMode.REMOTE) {
                UtilItemModular.useEnderCharge(toolStack, 50, false);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, event.entity.field_70165_t + 0.5, event.entity.field_70163_u + 0.5, event.entity.field_70161_v + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(event.entity.field_71093_bK, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 24.0));
        }
        if (event.drops.size() > 0 && mode == SwordMode.REMOTE) {
            iter = event.drops.iterator();
            while (iter.hasNext()) {
                item = (EntityItem)iter.next();
                MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, item));
                if (!item.field_70128_L && item.func_92059_d() != null && item.func_92059_d().field_77994_a > 0) continue;
                iter.remove();
            }
        }
        if (event.drops.isEmpty()) {
            event.setCanceled(true);
        }
    }

    private void summonFighterEndermen(World world, EntityLivingBase targetEntity, int amount) {
        if (targetEntity instanceof EntityEndermanFighter) {
            return;
        }
        double r = 16.0;
        double x = targetEntity.field_70165_t;
        double y = targetEntity.field_70163_u;
        double z = targetEntity.field_70161_v;
        int numReTargeted = 0;
        AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + r), (double)(y + r), (double)(z + r));
        List list = world.func_72872_a(EntityEndermanFighter.class, bb);
        for (EntityEndermanFighter fighter : list) {
            if (fighter.func_70638_az() != null || fighter.func_145818_k_()) continue;
            fighter.setPrimaryTarget(targetEntity);
            ++numReTargeted;
        }
        if (numReTargeted >= amount) {
            return;
        }
        int count = numReTargeted;
        for (int i = 0; i < 64; ++i) {
            x = targetEntity.field_70165_t - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
            y = targetEntity.field_70163_u - 2.0 + (double)world.field_73012_v.nextFloat() * 4.0;
            z = targetEntity.field_70161_v - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
            EntityEndermanFighter fighter = new EntityEndermanFighter(world);
            fighter.func_70107_b(x, targetEntity.field_70163_u, z);
            Block block = world.func_180495_p(new BlockPos((int)x, (int)targetEntity.field_70163_u - 1, (int)z)).func_177230_c();
            if (!world.func_72945_a((Entity)fighter, fighter.func_174813_aQ()).isEmpty() || world.func_72953_d(fighter.func_174813_aQ()) || !block.func_149688_o().func_76230_c()) continue;
            for (int j = 0; j < 16; ++j) {
                float vx = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                float vy = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                float vz = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                world.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, (double)vx, (double)vy, (double)vz, new int[0]);
            }
            world.func_72908_a(x, y, z, "mob.endermen.portal", 1.0f, 1.0f);
            world.func_72838_d((Entity)fighter);
            fighter.setPrimaryTarget(targetEntity);
            if (++count >= amount) break;
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (player != null && player.func_70093_af() && te != null && (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || te.getClass() == TileEntityEnderChest.class) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            if (!world.field_72995_K) {
                UtilItemModular.setTarget(stack, player, pos, side, hitX, hitY, hitZ, false, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, player, slot, isCurrent);
        if (!world.field_72995_K && EnergyBridgeTracker.dimensionHasEnergyBridge(world.field_73011_w.func_177502_q()) && (world.field_73011_w.func_177502_q() == 1 || EnergyBridgeTracker.dimensionHasEnergyBridge(1))) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        double dmg = this.damageVsEntity;
        if (this.isToolBroken(stack) || SwordMode.fromStack(stack) == SwordMode.SUMMON) {
            dmg = 0.0;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", dmg, 0));
        return multimap;
    }

    public void cycleSwordMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "SwordMode", 3);
    }

    @Override
    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (data != null && data.isOwner(player)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.setTarget(stack, player, true);
        } else if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.cycleSwordMode(stack);
        } else if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.changePrivacyMode(stack, player);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        int tier = imodule.getModuleTier(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && tier != 0 && tier != 1) {
            return 0;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier < 0 || tier > 2)) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE);
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        SwordMode mode = SwordMode.fromStack(stack);
        String str = mode == SwordMode.NORMAL ? "enderutilities.tooltip.item.normal" : (mode == SwordMode.PLAYER ? "enderutilities.tooltip.item.endertool.playerinv" : (mode == SwordMode.REMOTE ? "enderutilities.tooltip.item.endertool.remote" : "enderutilities.tooltip.item.endersword.summon"));
        str = StatCollector.func_74838_a((String)str);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + preDGreen + str + rst);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endercore") + ": ";
        if (coreTier >= 0 && coreTier <= 2) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = StatCollector.func_74838_a((String)coreType);
            str = str + preDGreen + coreType + rst + " (" + preBlue + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tier") + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = EnumChatFormatting.RED.toString();
            str = str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.none") + rst;
        }
        list.add(str);
        if (linkCrystalStack != null && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (capacitorStack != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addInformationSelective(capacitorStack, player, list, advancedTooltips, verbose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ModelResourceLocation("enderutilities:item_endertool", "inventory")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return new ModelResourceLocation("enderutilities:item_endertool", "inventory");
    }

    public static enum SwordMode {
        NORMAL("enderutilities.tooltip.item.normal"),
        PLAYER("enderutilities.tooltip.item.endertool.playerinv"),
        REMOTE("enderutilities.tooltip.item.endertool.remote"),
        SUMMON("enderutilities.tooltip.item.endersword.summon");

        private final String unlocalized;

        private SwordMode(String unlocalized) {
            this.unlocalized = unlocalized;
        }

        public static SwordMode fromStack(ItemStack stack) {
            int mode = MathHelper.func_76125_a((int)NBTUtils.getByte(stack, null, "SwordMode"), (int)0, (int)3);
            return SwordMode.values()[mode];
        }

        public String getDisplayName() {
            return StatCollector.func_74838_a((String)this.unlocalized);
        }
    }
}

