/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageKeyPressed
implements IMessage {
    private int keyPressed;

    public MessageKeyPressed() {
    }

    public MessageKeyPressed(int key) {
        this.keyPressed = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.keyPressed = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.keyPressed);
    }

    public static class Handler
    implements IMessageHandler<MessageKeyPressed, IMessage> {
        public IMessage onMessage(final MessageKeyPressed message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageKeyPressed: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("Sending player was null in MessageKeyPressed");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageKeyPressed");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageKeyPressed message, EntityPlayer player) {
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() instanceof IKeyBound) {
                ((IKeyBound)stack.func_77973_b()).doKeyBindingAction(player, stack, message.keyPressed);
            } else {
                stack = InventoryUtils.getFirstKeyBoundUnselectedItem(player);
                if (stack != null) {
                    ((IKeyBoundUnselected)stack.func_77973_b()).doUnselectedKeyAction(player, stack, message.keyPressed);
                }
            }
        }
    }
}

