/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityEnderUtilities
extends TileEntity {
    protected String tileEntityName;
    protected int rotation = 0;
    protected String ownerName = null;
    protected UUID ownerUUID = null;
    protected boolean isPublic = false;

    public TileEntityEnderUtilities(String name) {
        this.tileEntityName = name;
    }

    public String getTEName() {
        return this.tileEntityName;
    }

    public void setRotation(int rot) {
        this.rotation = rot;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setOwner(EntityPlayer player) {
        if (player != null) {
            this.ownerName = player.func_70005_c_();
            this.ownerUUID = player.func_110124_au();
        } else {
            this.ownerName = null;
            this.ownerUUID = null;
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.rotation = nbt.func_74771_c("Rotation");
        NBTHelperPlayer playerData = NBTHelperPlayer.getPlayerDataFromNBT(nbt);
        if (playerData != null) {
            this.ownerUUID = new UUID(playerData.playerUUIDMost, playerData.playerUUIDLeast);
            this.ownerName = playerData.playerName;
            this.isPublic = playerData.isPublic;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromNBTCustom(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("Version", "0.5.6");
        nbt.func_74774_a("Rotation", (byte)this.rotation);
        if (this.ownerUUID != null && this.ownerName != null) {
            NBTHelperPlayer.writePlayerTagToNBT(nbt, this.ownerUUID.getMostSignificantBits(), this.ownerUUID.getLeastSignificantBits(), this.ownerName, this.isPublic);
        }
    }

    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt.func_74774_a("r", (byte)(this.getRotation() & 7));
        if (this.ownerName != null) {
            nbt.func_74778_a("o", this.ownerName);
        }
        return nbt;
    }

    public Packet<INetHandlerPlayClient> func_145844_m() {
        if (this.field_145850_b != null) {
            return new S35PacketUpdateTileEntity(this.func_174877_v(), 0, this.getDescriptionPacketTag(new NBTTagCompound()));
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        if (nbt.func_74764_b("r")) {
            this.setRotation((byte)(nbt.func_74771_c("r") & 7));
        }
        if (nbt.func_150297_b("o", 8)) {
            this.ownerName = nbt.func_74779_i("o");
        }
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.func_174877_v() + ")@" + System.identityHashCode((Object)this);
    }
}

