/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityEnderUtilitiesInventory
extends TileEntityEnderUtilities {
    protected ItemStackHandlerTileEntity itemHandlerBase;
    protected IItemHandler itemHandlerExternal;
    protected String customInventoryName;

    public TileEntityEnderUtilitiesInventory(String name) {
        super(name);
    }

    public void setInventoryName(String name) {
        this.customInventoryName = name;
    }

    public boolean hasCustomName() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customInventoryName : "enderutilities.container." + this.tileEntityName;
    }

    public IItemHandler getBaseItemHandler() {
        return this.itemHandlerBase;
    }

    public IItemHandler getWrappedInventoryForContainer() {
        return new ItemHandlerWrapperContainer(this.itemHandlerBase, this.itemHandlerExternal);
    }

    protected void readItemsFromNBT(NBTTagCompound nbt) {
        this.itemHandlerBase.deserializeNBT(nbt);
    }

    public void writeItemsToNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(this.itemHandlerBase.serializeNBT());
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customInventoryName = nbt.func_74779_i("CustomName");
        }
        this.readItemsFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeItemsToNBT(nbt);
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customInventoryName);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerExternal != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerExternal;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void inventoryChanged(int inventoryId, int slot) {
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return false;
        }
        return !(player.func_174818_b(this.func_174877_v()) >= 64.0);
    }

    public void performGuiAction(EntityPlayer player, int action, int element) {
    }

    public ContainerEnderUtilities getContainer(EntityPlayer player) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return null;
    }
}

