/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleportEntityNetherPortal {
    public EnumFacing portalAxis = EnumFacing.NORTH;
    public EnumFacing teleportSide = EnumFacing.EAST;
    public int portalPosX = 0;
    public int portalPosY = 0;
    public int portalPosZ = 0;
    public double entityPosX = 0.0;
    public double entityPosY = 0.0;
    public double entityPosZ = 0.0;

    public Entity travelToDimension(Entity entity, int dimension, double idealX, double idealY, double idealZ, int portalSearchRadius, boolean placeInsidePortal) {
        WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(dimension);
        if (!this.searchForExistingPortal((World)worldServer, idealX, idealY, idealZ, portalSearchRadius)) {
            double origX = entity.field_70165_t;
            double origY = entity.field_70163_u;
            double origZ = entity.field_70161_v;
            entity.field_70165_t = idealX;
            entity.field_70163_u = idealY;
            entity.field_70161_v = idealZ;
            worldServer.func_85176_s().func_85188_a(entity);
            entity.field_70165_t = origX;
            entity.field_70163_u = origY;
            entity.field_70161_v = origZ;
            if (!this.searchForExistingPortal((World)worldServer, idealX, idealY, idealZ, 20)) {
                return null;
            }
        }
        this.getTeleportPosition((World)worldServer, placeInsidePortal);
        return TeleportEntity.teleportEntity(entity, this.entityPosX, this.entityPosY, this.entityPosZ, dimension, true, true);
    }

    public boolean searchForExistingPortal(World world, double idealX, double idealY, double idealZ, int searchRadius) {
        double distance = -1.0;
        int x = (int)idealX - searchRadius;
        while ((double)x <= idealX + (double)searchRadius) {
            double dx = (double)x + 0.5 - idealX;
            int z = (int)idealZ - searchRadius;
            while ((double)z <= idealZ + (double)searchRadius) {
                double dz = (double)z + 0.5 - idealZ;
                for (int y = world.func_72940_L() - 1; y >= 0; --y) {
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150427_aO) continue;
                    while (world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == Blocks.field_150427_aO) {
                        --y;
                    }
                    double dy = (double)y + 0.5 - idealY;
                    double tdist = dx * dx + dy * dy + dz * dz;
                    if (!(distance < 0.0) && !(tdist < distance)) continue;
                    distance = tdist;
                    this.portalPosX = x;
                    this.portalPosY = y;
                    this.portalPosZ = z;
                }
                ++z;
            }
            ++x;
        }
        if (distance >= 0.0) {
            this.getPortalOrientation(world);
        }
        return distance >= 0.0;
    }

    public void getPortalOrientation(World world) {
        BlockPos pos = new BlockPos(this.portalPosX, this.portalPosY, this.portalPosZ);
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150427_aO || world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150427_aO) {
            this.portalAxis = EnumFacing.EAST;
        } else if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150427_aO || world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150427_aO) {
            this.portalAxis = EnumFacing.SOUTH;
        }
    }

    public void getTeleportPosition(World world, boolean placeInsidePortal) {
        if (placeInsidePortal) {
            this.entityPosX = (double)this.portalPosX + 0.5;
            this.entityPosY = (double)this.portalPosY + 0.5;
            this.entityPosZ = (double)this.portalPosZ + 0.5;
        } else {
            EnumFacing dirSide = this.portalAxis.func_176746_e();
            EnumFacing dirPortal = this.portalAxis;
            BlockPos posTmp = new BlockPos(this.portalPosX + dirPortal.func_82601_c(), this.portalPosY, this.portalPosZ + dirPortal.func_82599_e());
            if (world.func_180495_p(posTmp).func_177230_c() != Blocks.field_150427_aO) {
                dirPortal = dirPortal.func_176734_d();
            }
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            int xPos = this.portalPosX + dirSide.func_82601_c();
            int zPos = this.portalPosZ + dirSide.func_82599_e();
            int xNeg = this.portalPosX - dirSide.func_82601_c();
            int zNeg = this.portalPosZ - dirSide.func_82599_e();
            list.add(new BlockPos(xPos, this.portalPosY - 1, zPos));
            list.add(new BlockPos(xPos, this.portalPosY - 2, zPos));
            list.add(new BlockPos(xPos + dirPortal.func_82601_c(), this.portalPosY - 1, zPos + dirPortal.func_82599_e()));
            list.add(new BlockPos(xPos + dirPortal.func_82601_c(), this.portalPosY - 2, zPos + dirPortal.func_82599_e()));
            list.add(new BlockPos(xNeg, this.portalPosY - 1, zNeg));
            list.add(new BlockPos(xNeg, this.portalPosY - 2, zNeg));
            list.add(new BlockPos(xNeg + dirPortal.func_82601_c(), this.portalPosY - 1, zNeg + dirPortal.func_82599_e()));
            list.add(new BlockPos(xNeg + dirPortal.func_82601_c(), this.portalPosY - 2, zNeg + dirPortal.func_82599_e()));
            for (BlockPos pos : list) {
                if (!World.func_175683_a((IBlockAccess)world, (BlockPos)pos) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 1)) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) continue;
                this.entityPosX = (double)pos.func_177958_n() + 0.5;
                this.entityPosY = (double)pos.func_177956_o() + 1.5;
                this.entityPosZ = (double)pos.func_177952_p() + 0.5;
                return;
            }
            for (BlockPos pos : list) {
                if (!world.func_175623_d(pos) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 1)) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) continue;
                world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 3);
                this.entityPosX = (double)pos.func_177958_n() + 0.5;
                this.entityPosY = (double)pos.func_177956_o() + 1.5;
                this.entityPosZ = (double)pos.func_177952_p() + 0.5;
                return;
            }
            this.entityPosX = (double)(this.portalPosX + dirSide.func_82601_c()) + 0.5;
            this.entityPosY = (double)this.portalPosY + 0.5;
            this.entityPosZ = (double)(this.portalPosZ + dirSide.func_82599_e()) + 0.5;
        }
    }
}

