/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityEnderArrow
extends EntityArrow {
    public int blockX = -1;
    public int blockY = -1;
    public int blockZ = -1;
    public Block inBlock;
    public int field_70253_h;
    public boolean field_70254_i;
    public int canBePickedUp;
    public int field_70249_b;
    public EntityLivingBase field_70250_c;
    public int field_70252_j;
    public int field_70257_an;
    public TargetData tpTarget;
    public byte tpMode;
    public boolean applyPersistence;
    public UUID shooterUUID;
    public float teleportDamage = 2.0f;

    public EntityEnderArrow(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.shooterUUID = UUID.randomUUID();
    }

    public EntityEnderArrow(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityEnderArrow(World worldIn, EntityLivingBase shooter, EntityLivingBase par3EntityLivingBase, float par4, float par5) {
        super(worldIn);
        this.field_70250_c = shooter;
        this.shooterUUID = shooter.func_110124_au();
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
            if (((EntityPlayer)shooter).field_71075_bZ.field_75098_d) {
                this.canBePickedUp = 2;
            }
        }
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = par3EntityLivingBase.field_70165_t - shooter.field_70165_t;
        double d1 = par3EntityLivingBase.func_174813_aQ().field_72338_b + (double)(par3EntityLivingBase.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = par3EntityLivingBase.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, par4, par5);
        }
    }

    public EntityEnderArrow(World worldIn, EntityLivingBase shooter, float velocity) {
        super(worldIn);
        this.field_70250_c = shooter;
        this.shooterUUID = shooter.func_110124_au();
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
            if (((EntityPlayer)shooter).field_71075_bZ.field_75098_d) {
                this.canBePickedUp = 2;
            }
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        double x = this.field_70165_t - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        double z = this.field_70161_v - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        x -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.74f) * (double)MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double y = this.field_70163_u - (double)0.1f;
        z += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.74f) * (double)MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        if (worldIn.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)(x -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f))), (int)y, MathHelper.func_76128_c((double)(z -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f)))))) {
            this.field_70165_t = x;
            this.field_70161_v = z;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.8f, 1.0f);
    }

    public void setTpMode(byte mode) {
        this.tpMode = mode;
    }

    public void setPersistence(boolean enabled) {
        this.applyPersistence = enabled;
    }

    public void setTpTarget(TargetData target) {
        this.tpTarget = target;
    }

    public void dropAsItem(boolean doDrop) {
        if (this.canBePickedUp != 1 || !doDrop) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184550_j());
        Random r = new Random();
        entityitem.field_70159_w = 0.01 * r.nextGaussian();
        entityitem.field_70181_x = 0.01 * r.nextGaussian() + 0.05;
        entityitem.field_70179_y = 0.01 * r.nextGaussian();
        entityitem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)entityitem);
    }

    public void func_70071_h_() {
        float f1;
        int i;
        AxisAlignedBB aabb;
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        BlockPos pos = new BlockPos(this.blockX, this.blockY, this.blockZ);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (state.func_185904_a() != Material.field_151579_a && (aabb = state.func_185890_d(this.field_70170_p, pos)) != Block.field_185506_k && aabb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i) {
            int meta = block.func_176201_c(state);
            if (block == this.inBlock && meta == this.field_70253_h) {
                ++this.field_70252_j;
                if (this.field_70252_j == 1200) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
            return;
        }
        ++this.field_70257_an;
        Vec3d vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTraceResult = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
        vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (rayTraceResult != null) {
            vec3 = new Vec3d(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
        }
        EntityLivingBase shooter = this.getShooter();
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || EntityUtils.doesEntityStackContainEntity((Entity)shooter, entity1)) continue;
            f1 = 0.3f;
            AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
            RayTraceResult rayTraceResultTmp = axisalignedbb1.func_72327_a(vec31, vec3);
            if (rayTraceResultTmp == null || rayTraceResultTmp.field_72313_a == RayTraceResult.Type.ENTITY && rayTraceResultTmp.field_72308_g instanceof EntityPlayerMP && ((EntityPlayerMP)rayTraceResultTmp.field_72308_g).func_175149_v() || !((d1 = vec31.func_72438_d(rayTraceResultTmp.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            rayTraceResult = new RayTraceResult(entity);
        }
        if (rayTraceResult != null) {
            if (this.tpMode == 1) {
                if (!this.field_70170_p.field_72995_K && shooter != null) {
                    if (TeleportEntity.entityTeleportWithProjectile((Entity)shooter, (Entity)this, rayTraceResult, this.teleportDamage, true, true)) {
                        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                    this.dropAsItem(false);
                    this.func_70106_y();
                }
            } else if (this.tpMode == 0 && rayTraceResult.field_72308_g != null) {
                if (shooter != null && !EntityUtils.doesEntityStackContainEntity(rayTraceResult.field_72308_g, (Entity)shooter)) {
                    this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    if (!(EntityUtils.doesEntityStackHaveBlacklistedEntities(rayTraceResult.field_72308_g) || !Configs.enderBowAllowPlayers && EntityUtils.doesEntityStackHavePlayers(rayTraceResult.field_72308_g))) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.tpTarget = TeleportEntity.adjustTargetPosition(this.tpTarget, rayTraceResult.field_72308_g);
                            if (this.tpTarget != null) {
                                Entity e = rayTraceResult.field_72308_g;
                                if (this.tpTarget.hasRotation && entity != null) {
                                    entity.func_70080_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, this.tpTarget.yaw, this.tpTarget.pitch);
                                }
                                if (this.applyPersistence && e instanceof EntityLiving) {
                                    EntityUtils.applyMobPersistence((EntityLiving)e);
                                }
                                TeleportEntity.teleportEntity(e, this.tpTarget.dPosX, this.tpTarget.dPosY, this.tpTarget.dPosZ, this.tpTarget.dimension, true, true);
                            }
                            this.dropAsItem(false);
                            this.func_70106_y();
                        }
                    } else {
                        this.field_70159_w *= (double)-0.1f;
                        this.field_70181_x *= (double)-0.1f;
                        this.field_70179_y *= (double)-0.1f;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        this.field_70257_an = 0;
                    }
                }
            } else {
                BlockPos mopPos = rayTraceResult.func_178782_a();
                this.blockX = mopPos.func_177958_n();
                this.blockY = mopPos.func_177956_o();
                this.blockZ = mopPos.func_177952_p();
                state = this.field_70170_p.func_180495_p(mopPos);
                this.inBlock = state.func_177230_c();
                this.field_70253_h = this.inBlock.func_176201_c(state);
                this.field_70159_w = (float)(rayTraceResult.field_72307_f.field_72450_a - this.field_70165_t);
                this.field_70181_x = (float)(rayTraceResult.field_72307_f.field_72448_b - this.field_70163_u);
                this.field_70179_y = (float)(rayTraceResult.field_72307_f.field_72449_c - this.field_70161_v);
                float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.field_70254_i = true;
                this.field_70249_b = 7;
                this.func_70243_d(false);
                if (state.func_185904_a() != Material.field_151579_a) {
                    this.inBlock.func_180634_a(this.field_70170_p, mopPos, state, (Entity)this);
                }
            }
        }
        if (this.func_70241_g()) {
            for (i = 0; i < 4; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f3 = 0.99f;
        f1 = 0.05f;
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f3 = 0.8f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)f3;
        this.field_70181_x *= (double)f3;
        this.field_70179_y *= (double)f3;
        this.field_70181_x -= (double)f1;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("xTile", (int)((short)this.blockX));
        tagCompound.func_74768_a("yTile", (int)((short)this.blockY));
        tagCompound.func_74768_a("zTile", (int)((short)this.blockZ));
        tagCompound.func_74768_a("inTile", Block.func_149682_b((Block)this.inBlock));
        tagCompound.func_74774_a("inData", (byte)this.field_70253_h);
        tagCompound.func_74777_a("life", (short)this.field_70252_j);
        tagCompound.func_74774_a("shake", (byte)this.field_70249_b);
        tagCompound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        tagCompound.func_74774_a("pickup", (byte)this.canBePickedUp);
        tagCompound.func_74772_a("shooterUUIDMost", this.shooterUUID.getMostSignificantBits());
        tagCompound.func_74772_a("shooterUUIDLeast", this.shooterUUID.getLeastSignificantBits());
        if (this.tpTarget != null) {
            this.tpTarget.writeToNBT(tagCompound);
        }
        tagCompound.func_74774_a("tpMode", this.tpMode);
        tagCompound.func_74757_a("Persistence", this.applyPersistence);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.blockX = tagCompound.func_74762_e("xTile");
        this.blockY = tagCompound.func_74762_e("yTile");
        this.blockZ = tagCompound.func_74762_e("zTile");
        this.inBlock = Block.func_149729_e((int)tagCompound.func_74762_e("inTile"));
        this.field_70253_h = tagCompound.func_74771_c("inData") & 0xF;
        this.field_70252_j = tagCompound.func_74765_d("life");
        this.field_70249_b = tagCompound.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = tagCompound.func_74771_c("inGround") == 1;
        if (tagCompound.func_150297_b("pickup", 99)) {
            this.canBePickedUp = tagCompound.func_74771_c("pickup");
        } else if (tagCompound.func_150297_b("player", 99)) {
            int n = this.canBePickedUp = tagCompound.func_74767_n("player") ? 1 : 0;
        }
        if (tagCompound.func_150297_b("shooterUUIDMost", 4) && tagCompound.func_150297_b("shooterUUIDLeast", 4)) {
            this.shooterUUID = new UUID(tagCompound.func_74763_f("shooterUUIDMost"), tagCompound.func_74763_f("shooterUUIDLeast"));
            this.field_70250_c = this.field_70170_p.func_152378_a(this.shooterUUID);
        }
        this.tpTarget = TargetData.readTargetFromNBT(tagCompound);
        this.tpMode = tagCompound.func_74771_c("tpMode");
        this.applyPersistence = tagCompound.func_74767_n("Persistence");
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.field_70254_i && this.field_70249_b <= 0 && this.canBePickedUp != 0) {
            if (this.canBePickedUp == 1) {
                if (par1EntityPlayer.field_71071_by.func_70441_a(this.func_184550_j())) {
                    this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    par1EntityPlayer.func_71001_a((Entity)this, 1);
                    this.func_70106_y();
                }
            } else if (this.canBePickedUp == 2) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.func_70106_y();
            }
        }
    }

    public EntityLivingBase getShooter() {
        if (this.field_70250_c == null && this.shooterUUID != null) {
            this.field_70250_c = this.field_70170_p.func_152378_a(this.shooterUUID);
        }
        return this.field_70250_c;
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((Item)EnderUtilitiesItems.enderArrow);
    }
}

