/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class AnvilUpdateEventHandler {
    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_77973_b() == EnderUtilitiesItems.enderTool || left.func_77973_b() == EnderUtilitiesItems.enderSword) {
            if (right.func_77973_b() == EnderUtilitiesItems.enderPart && right.func_77960_j() == 2) {
                this.fullyRepairItem(event, 1, 15);
            } else if (right.func_77973_b() == Items.field_151134_bR) {
                this.enhantItem(event, (ItemEnchantedBook)right.func_77973_b());
            } else {
                event.setCanceled(true);
            }
        } else if (left.func_77973_b() == EnderUtilitiesItems.enderBow) {
            if (right.func_77973_b() == EnderUtilitiesItems.enderPart && right.func_77960_j() == 1) {
                this.fullyRepairItem(event, 1, 15);
            } else if (right.func_77973_b() != Items.field_151134_bR) {
                event.setCanceled(true);
            }
        }
    }

    private void fullyRepairItem(AnvilUpdateEvent event, int materialCost, int xpCost) {
        ItemStack left = event.getLeft();
        ItemStack repaired = left.func_77946_l();
        if (repaired.func_77973_b() == EnderUtilitiesItems.enderTool) {
            if (repaired.func_77952_i() == 0) {
                event.setCanceled(true);
                return;
            }
            ((ItemEnderTool)repaired.func_77973_b()).repairTool(repaired, -1);
        } else if (repaired.func_77973_b() == EnderUtilitiesItems.enderSword) {
            if (repaired.func_77952_i() == 0) {
                event.setCanceled(true);
                return;
            }
            int repairAmount = Math.min(repaired.func_77958_k(), repaired.func_77952_i());
            repaired.func_77964_b(repaired.func_77952_i() - repairAmount);
        }
        event.setMaterialCost(materialCost);
        event.setCost(xpCost);
        event.setOutput(repaired);
        this.updateItemName(event, repaired);
    }

    private void enhantItem(AnvilUpdateEvent event, ItemEnchantedBook book) {
        ItemStack toolStack = event.getLeft().func_77946_l();
        ItemStack bookStack = event.getRight().func_77946_l();
        NBTTagList bookEnchantmentList = book.func_92110_g(bookStack);
        if (bookEnchantmentList.func_74745_c() <= 0 || !toolStack.func_77973_b().isBookEnchantable(toolStack, bookStack)) {
            return;
        }
        Map oldEnchantments = EnchantmentHelper.func_82781_a((ItemStack)toolStack);
        Map bookEnchantments = EnchantmentHelper.func_82781_a((ItemStack)bookStack);
        Iterator iterBookEnchantments = bookEnchantments.entrySet().iterator();
        int cost = oldEnchantments.size() * 2;
        boolean levelIncreased = false;
        while (iterBookEnchantments.hasNext()) {
            Map.Entry enchantmentEntry = iterBookEnchantments.next();
            Enchantment enchBook = (Enchantment)enchantmentEntry.getKey();
            if (enchBook == null) continue;
            int oldEnchLvl = oldEnchantments.containsKey(enchBook) ? (Integer)oldEnchantments.get(enchBook) : 0;
            int bookEnchLvl = (Integer)enchantmentEntry.getValue();
            int newLvl = bookEnchLvl == oldEnchLvl ? oldEnchLvl + 1 : Math.max(oldEnchLvl, bookEnchLvl);
            newLvl = Math.min(newLvl, enchBook.func_77325_b());
            if (!this.canApplyEnchantment(enchBook, toolStack)) {
                event.setCanceled(true);
                return;
            }
            if (newLvl > oldEnchLvl) {
                levelIncreased = true;
            }
            Iterator iterOldEnchantments = oldEnchantments.entrySet().iterator();
            while (iterOldEnchantments.hasNext()) {
                Enchantment enchOld = (Enchantment)iterOldEnchantments.next().getKey();
                if (enchOld.equals(enchBook) || enchBook.func_77326_a(enchOld) && enchOld.func_77326_a(enchBook)) continue;
                event.setCanceled(true);
                return;
            }
            oldEnchantments.put(enchBook, newLvl);
            cost += newLvl * 2;
        }
        if (!levelIncreased) {
            event.setCanceled(true);
            return;
        }
        EnchantmentHelper.func_82782_a((Map)oldEnchantments, (ItemStack)toolStack);
        event.setOutput(toolStack);
        event.setCost(cost);
        this.updateItemName(event, toolStack);
        event.setCost(Math.min(event.getCost(), 39));
    }

    private boolean canApplyEnchantment(Enchantment ench, ItemStack stack) {
        if (ench.field_77351_y == EnumEnchantmentType.BREAKABLE || ench.field_77351_y == EnumEnchantmentType.ALL) {
            return true;
        }
        if (stack.func_77973_b() == EnderUtilitiesItems.enderSword) {
            return ench.field_77351_y == EnumEnchantmentType.WEAPON;
        }
        if (stack.func_77973_b() == EnderUtilitiesItems.enderTool) {
            ItemEnderTool.ToolType type = ItemEnderTool.ToolType.fromStack(stack);
            if (type == ItemEnderTool.ToolType.HOE || type == ItemEnderTool.ToolType.INVALID) {
                return false;
            }
            if (type == ItemEnderTool.ToolType.AXE && ench.field_77351_y == EnumEnchantmentType.WEAPON) {
                return true;
            }
            return ench.field_77351_y == EnumEnchantmentType.DIGGER;
        }
        return false;
    }

    private void updateItemName(AnvilUpdateEvent event, ItemStack outputStack) {
        String name = event.getName();
        if (!StringUtils.isBlank((CharSequence)name)) {
            outputStack.func_151001_c(name);
            event.setCost(event.getCost() + 1);
        } else if (StringUtils.isBlank((CharSequence)name) && outputStack.func_82837_s()) {
            outputStack.func_135074_t();
            event.setCost(event.getCost() + 1);
        }
    }
}

