/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.item.ItemLivingManipulator;
import fi.dy.masa.enderutilities.item.ItemMobHarness;
import fi.dy.masa.enderutilities.item.ItemPortalScaler;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack == null) {
            return;
        }
        Item item = stack.func_77973_b();
        boolean isRemote = player.field_70170_p.field_72995_K;
        if (item == EnderUtilitiesItems.livingManipulator) {
            if (event.getTarget() instanceof EntityLivingBase) {
                if (!isRemote) {
                    ((ItemLivingManipulator)item).handleInteraction(stack, player, (EntityLivingBase)event.getTarget());
                }
                event.setCanceled(true);
            }
        } else if (item == EnderUtilitiesItems.mobHarness && event.getTarget() instanceof EntityLivingBase) {
            ((ItemMobHarness)item).handleInteraction(stack, player, event.getTarget());
            event.setCanceled(true);
        } else if (item == EnderUtilitiesItems.enderLasso && event.getTarget() instanceof EntityLivingBase) {
            if ((Configs.enderLassoAllowPlayers || !EntityUtils.doesEntityStackHavePlayers(event.getTarget())) && OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) && UtilItemModular.useEnderCharge(stack, 1000, false)) {
                if (event.getTarget() instanceof EntityLiving && UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                    EntityUtils.applyMobPersistence((EntityLiving)event.getTarget());
                }
                if (isRemote || TeleportEntity.teleportEntityUsingModularItem(event.getTarget(), stack) != null) {
                    event.setCanceled(true);
                }
            }
        } else if (player.field_71093_bK == 1 && event.getTarget() instanceof EntityEnderCrystal && !isRemote) {
            int tier;
            if (item instanceof IChargeable) {
                IChargeable chargeable = (IChargeable)item;
                chargeable.addCharge(stack, chargeable.getCapacity(stack) >> 2, true);
            } else if (item instanceof IModule && item == EnderUtilitiesItems.enderPart && ((IModule)item).getModuleType(stack).equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier = ((IModule)item).getModuleTier(stack)) >= 10 && tier <= 12) {
                ((ItemEnderPart)item).activateEnderCore(stack);
            }
        }
    }

    @SubscribeEvent
    public void onTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        int dim = event.getDimension();
        if (dim != 0 && dim != -1 || entity.field_71093_bK != 0 && entity.field_71093_bK != -1 || !(entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)((EntityPlayer)entity), EnderUtilitiesItems.portalScaler);
        if (stack != null && EntityUtils.isEntityCollidingWithBlockSpace(entity.field_70170_p, entity, (Block)Blocks.field_150427_aO) && ((ItemPortalScaler)stack.func_77973_b()).usePortalWithPortalScaler(stack, entity.field_70170_p, (EntityPlayer)entity)) {
            event.setCanceled(true);
        }
    }
}

