/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.block.BlockPortalPanel;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.client.renderer.item.BuildersWandRenderer;
import fi.dy.masa.enderutilities.client.renderer.item.RulerRenderer;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortalPanel;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class RenderEventHandler {
    private static RenderEventHandler INSTANCE;
    public Minecraft mc;
    protected BuildersWandRenderer buildersWandRenderer;
    protected RulerRenderer rulerRenderer;
    protected BlockPos portalPanelPosLast = BlockPos.field_177992_a;
    protected EnumFacing panelFacingLast = EnumFacing.DOWN;
    protected List<AxisAlignedBB> panelBoxes;
    protected float partialTicks;

    public RenderEventHandler() {
        this.mc = Minecraft.func_71410_x();
        this.buildersWandRenderer = new BuildersWandRenderer();
        this.rulerRenderer = new RulerRenderer();
        this.panelBoxes = new ArrayList<AxisAlignedBB>();
        INSTANCE = this;
    }

    public static RenderEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.renderItemExtras((World)this.mc.field_71441_e, (EntityPlayer)this.mc.field_71439_g, (EntityPlayer)this.mc.field_71439_g, event.getPartialTicks());
        if (Configs.buildersWandRenderForOtherPlayers) {
            for (EntityPlayer player : this.mc.field_71441_e.func_175661_b(EntityPlayer.class, EntitySelectors.field_180132_d)) {
                this.renderItemExtras((World)this.mc.field_71441_e, player, (EntityPlayer)this.mc.field_71439_g, event.getPartialTicks());
            }
        }
    }

    private void renderItemExtras(World world, EntityPlayer usingPlayer, EntityPlayer clientPlayer, float partialTicks) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)usingPlayer, EnderUtilitiesItems.buildersWand);
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.buildersWand) {
            this.buildersWandRenderer.renderSelectedArea(world, usingPlayer, stack, clientPlayer, partialTicks);
        }
        this.rulerRenderer.renderAllPositionPairs(usingPlayer, clientPlayer, partialTicks);
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!(this.mc.field_71462_r instanceof GuiChat)) {
            this.buildersWandRenderer.renderHud();
            this.rulerRenderer.renderHud();
        }
    }

    @SubscribeEvent
    public void onBlockHilight(DrawBlockHighlightEvent event) {
        IBlockState state;
        RayTraceResult trace = event.getTarget();
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && (state = this.mc.field_71441_e.func_180495_p(trace.func_178782_a())).func_177230_c() == EnderUtilitiesBlocks.blockPortalPanel) {
            this.renderPortalPanelText(trace.func_178782_a(), event.getPartialTicks());
            this.renderPortalPanelHilight(event.getContext(), state, trace.func_178782_a(), event.getPartialTicks());
        }
    }

    private void renderPortalPanelText(BlockPos pos, float partialTicks) {
        TileEntity te;
        IBlockState state = this.mc.field_71441_e.func_180495_p(pos);
        if (state.func_177230_c() == EnderUtilitiesBlocks.blockPortalPanel && (te = this.mc.field_71441_e.func_175625_s(pos)) instanceof TileEntityPortalPanel) {
            String name = ((TileEntityPortalPanel)te).getDisplayName();
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPortalPanel.FACING);
            if (!StringUtils.isBlank((CharSequence)name) && name.length() > 0) {
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                this.renderPortalPanelText(name, (EntityPlayer)this.mc.field_71439_g, pos, facing, partialTicks);
            }
        }
    }

    protected void renderPortalPanelText(String text, EntityPlayer player, BlockPos pos, EnumFacing facing, float partialTicks) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        float angleH = 0.0f;
        float angleV = 0.0f;
        double frontOffset = 0.32;
        if (facing.func_176740_k().func_176722_c()) {
            int frontX = facing.func_82601_c();
            int frontZ = facing.func_82599_e();
            if (facing == EnumFacing.NORTH || facing == EnumFacing.WEST) {
                frontX = -frontX;
                frontZ = -frontZ;
                frontOffset = 1.0 - frontOffset;
            }
            x += (double)frontX * frontOffset + (double)frontZ * 0.5;
            z += (double)frontZ * frontOffset + (double)frontX * 0.5;
            y += 1.25;
            angleH = facing.func_185119_l() + 180.0f;
        } else {
            if (facing == EnumFacing.DOWN) {
                frontOffset = 1.0 - frontOffset;
                x += 0.5;
                z -= 0.25;
            } else {
                x += 0.5;
                z += 1.25;
            }
            y += frontOffset;
            angleV = (float)facing.func_96559_d() * -90.0f;
        }
        this.renderLabel(text, x - dx, y - dy, z - dz, angleH, angleV);
    }

    protected void renderLabel(String text, double x, double y, double z, float angleH, float angleV) {
        boolean flag = false;
        FontRenderer fontrenderer = this.mc.field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleH), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleV), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int strLenHalved = fontrenderer.func_78256_a(text) / 2;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strLenHalved - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strLenHalved - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(strLenHalved + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(strLenHalved + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(text, -strLenHalved, 0, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(text, -strLenHalved, 0, flag ? 0x20FFFFFF : -1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected void renderPortalPanelHilight(RenderGlobal context, IBlockState state, BlockPos pos, float partialTicks) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEnderUtilities.FACING);
        if (!pos.equals((Object)this.portalPanelPosLast) || facing != this.panelFacingLast) {
            this.updatePanelBoxBounds(pos, facing);
            this.portalPanelPosLast = pos;
            this.panelFacingLast = facing;
        }
        this.partialTicks = partialTicks;
    }

    public AxisAlignedBB getSelectedBoundingBox() {
        int index = EntityUtils.getPointedBox(this.mc.func_175606_aa(), 6.0, this.panelBoxes, this.partialTicks);
        if (index >= 0 && index < this.panelBoxes.size()) {
            return this.panelBoxes.get(index);
        }
        return PositionUtils.ZERO_BB;
    }

    private void updatePanelBoxBounds(BlockPos pos, EnumFacing facing) {
        this.panelBoxes.clear();
        Vec3d reference = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_1.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_2.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_3.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_4.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_5.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_6.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_7.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_8.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.BUTTON_M.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
        this.panelBoxes.add(PositionUtils.rotateBoxAroundPoint(BlockPortalPanel.PANEL_BOUNDS_BASE.func_186670_a(pos), reference, EnumFacing.NORTH, facing));
    }
}

