/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TaskReplaceBlocks
implements IPlayerTask {
    protected final int dimension;
    protected final UUID wandUUID;
    protected final List<BlockPosStateDist> positions;
    protected final int blocksPerTick;
    protected int listIndex = 0;
    protected int placedCount = 0;
    protected int failCount = 0;

    public TaskReplaceBlocks(World world, UUID wandUUID, List<BlockPosStateDist> positions, int blocksPerTick) {
        this.dimension = world.field_73011_w.getDimension();
        this.wandUUID = wandUUID;
        this.positions = positions;
        this.blocksPerTick = blocksPerTick;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.buildersWand);
        if (stack != null && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            int i = 0;
            while (i < this.blocksPerTick && this.listIndex < this.positions.size()) {
                if (this.replaceBlock(world, player, stack, this.positions.get(this.listIndex))) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++i;
                }
                ++this.listIndex;
            }
            if (this.listIndex >= this.positions.size()) {
                return true;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean replaceBlock(World world, EntityPlayer player, ItemStack stack, BlockPosStateDist posIn) {
        BlockPos pos = posIn.toBlockPos();
        if (this.canReplaceBlock(world, player, stack, posIn)) {
            this.handleOldBlock(world, player, pos, posIn.side);
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            return wand.placeBlockToPosition(stack, world, player, posIn);
        }
        return false;
    }

    private boolean canReplaceBlock(World world, EntityPlayer player, ItemStack stack, BlockPosStateDist posIn) {
        return ItemBuildersWand.hasEnoughCharge(stack, player) && ItemBuildersWand.canManipulateBlock(world, posIn.toBlockPos(), player, stack, true) && (player.field_71075_bZ.field_75098_d || ItemBuildersWand.getAndConsumeBuildItem(stack, world, posIn.toBlockPos(), posIn.blockInfo.blockState, player, true) != null);
    }

    private void handleOldBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing side) {
        ItemStack stack;
        if (!player.field_71075_bZ.field_75098_d && (stack = BlockUtils.getStackedItemFromBlock(world, pos, player, side)) != null && (stack = InventoryUtils.tryInsertItemStackToInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack)) != null) {
            EntityUtils.dropItemStacksInWorld(world, pos, stack, -1, true);
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    @Override
    public void stop() {
        this.positions.clear();
    }
}

