/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.ContainerTileEntityInventory;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModules;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotModuleModularItem;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IStringInput;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerToolWorkstation
extends ContainerTileEntityInventory
implements IContainerItem,
IStringInput {
    private final TileEntityToolWorkstation tetw;
    public static final int CONT_SLOT_TOOL = 0;
    public static final int CONT_SLOT_MODULES_START = 1;
    public static final int CONT_SLOT_RENAME = 20;
    public static final int NUM_MODULE_SLOTS = 10;
    public static final int NUM_STORAGE_SLOTS = 9;
    public final InventoryItemModules inventoryItem;

    public ContainerToolWorkstation(EntityPlayer player, TileEntityToolWorkstation te) {
        super(player, te);
        this.tetw = te;
        ItemStack tool = this.inventory.getStackInSlot(0);
        this.inventoryItem = new InventoryItemModules(tool, 10, te.func_145831_w().field_72995_K, player);
        this.inventoryItem.readFromContainerItemStack();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 135);
    }

    @Override
    protected void addCustomInventorySlots() {
        int i;
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 0, 8, 19));
        int x = 80;
        int y = 19;
        for (i = 0; i < 10; ++i) {
            this.func_75146_a((Slot)new SlotModuleModularItem((IItemHandler)this.inventoryItem, i, x, y, ItemModule.ModuleType.TYPE_INVALID, this));
            if (i == 4) {
                y += 18;
                x -= 90;
            }
            x += 18;
        }
        x = 8;
        y = 66;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 1 + i, x, y));
            x += 18;
        }
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 10, 8, 97));
        this.customInventorySlots = new MergeSlotRange(0, this.field_75151_b.size());
        this.setUpgradeSlotTypes();
    }

    public void func_75141_a(int slotNum, ItemStack stack) {
        super.func_75141_a(slotNum, stack);
        if (slotNum == 0) {
            this.setUpgradeSlotTypes();
        }
    }

    @Override
    public ItemStack getContainerItem() {
        return this.func_75139_a(0).func_75211_c();
    }

    private void setUpgradeSlotTypes() {
        int slotNum = 1;
        int slots = 0;
        Slot slot = this.func_75139_a(0);
        if (slot != null && slot.func_75216_d() && slot.func_75211_c().func_77973_b() instanceof IModular) {
            ItemStack toolStack = slot.func_75211_c();
            IModular imodular = (IModular)toolStack.func_77973_b();
            for (ItemModule.ModuleType moduleType : ItemModule.ModuleType.values()) {
                if (moduleType.equals(ItemModule.ModuleType.TYPE_INVALID)) continue;
                int maxOfType = imodular.getMaxModules(toolStack, moduleType);
                int i = 0;
                while (i < maxOfType && slots < 10) {
                    slot = this.func_75139_a(slotNum);
                    if (slot instanceof SlotModuleModularItem) {
                        ((SlotModuleModularItem)slot).setModuleType(moduleType);
                    }
                    ++i;
                    ++slotNum;
                    ++slots;
                }
                if (slots >= 10) break;
            }
        }
        while (slotNum < 11) {
            slot = this.func_75139_a(slotNum);
            if (slot instanceof SlotModuleModularItem) {
                ((SlotModuleModularItem)slot).setModuleType(ItemModule.ModuleType.TYPE_INVALID);
            }
            ++slotNum;
        }
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot = this.func_75139_a(slotNum);
        ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
        if (slot != null && slot instanceof SlotItemHandler && ((SlotItemHandler)slot).getItemHandler() == this.inventoryItem) {
            this.inventoryItem.onContentsChanged(slot.getSlotIndex());
        } else if (this.inventoryItem.getContainerItemStack() != this.inventory.getStackInSlot(0)) {
            this.inventoryItem.setContainerItemStack(this.inventory.getStackInSlot(0));
            this.setUpgradeSlotTypes();
        }
        this.func_75142_b();
        return stack;
    }

    @Override
    public void handleString(EntityPlayer player, ItemStack stack, String text) {
        this.tetw.renameItem(text);
    }
}

