/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemLocationBound
extends ItemEnderUtilities
implements ILocationBound,
IKeyBound {
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            if (!world.field_72995_K) {
                boolean adjustPosHit = stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((ItemLinkCrystal)stack.func_77973_b()).getModuleTier(stack) == 0;
                this.setTarget(stack, player, pos, side, hitX, hitY, hitZ, adjustPosHit, false);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.setTarget(stack, player, true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public String getBaseItemDisplayName(ItemStack stack) {
        String itemName = super.getBaseItemDisplayName(stack);
        if (itemName.length() >= 14 && this.shouldDisplayTargetName(stack)) {
            itemName = EUStringUtils.getInitialsWithDots(itemName);
        }
        return itemName;
    }

    @Override
    public boolean shouldDisplayTargetName(ItemStack stack) {
        if (stack.func_82837_s()) {
            return false;
        }
        String targetName = this.getTargetDisplayName(stack);
        return targetName != null && targetName.length() > 0;
    }

    @Override
    public String getTargetDisplayName(ItemStack stack) {
        TargetData target = TargetData.getTargetFromItem(stack);
        return target != null ? target.getTargetBlockDisplayName() : null;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.shouldDisplayTargetName(stack)) {
            String targetName = this.getTargetDisplayName(stack);
            String pre = TextFormatting.GREEN.toString();
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            return this.getBaseItemDisplayName(stack) + " " + pre + targetName + rst;
        }
        return super.getBaseItemDisplayName(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        OwnerData playerData;
        TargetData target = this.getTarget(stack);
        if (target == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.notargetset", (Object[])new Object[0]));
            return;
        }
        String preBlue = TextFormatting.BLUE.toString();
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        if (OwnerData.canAccessItem(stack, (Entity)player)) {
            String s;
            Block block;
            ItemStack targetStack;
            String dimName = target.getDimensionName(false);
            boolean showBlock = false;
            String blockName = "";
            Item item = stack.func_77973_b();
            if (item instanceof IModule && ((IModule)item).getModuleType(stack).equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && ((IModule)item).getModuleTier(stack) == 1 && (targetStack = new ItemStack(block = Block.func_149684_b((String)target.blockName), 1, target.itemMeta)) != null && targetStack.func_77973_b() != null) {
                blockName = targetStack.func_82833_r();
                showBlock = true;
            }
            if (verbose) {
                s = I18n.func_135052_a((String)"enderutilities.tooltip.dimension", (Object[])new Object[0]) + ": " + preBlue + target.dimension + rst;
                if (dimName.length() > 0) {
                    s = s + " - " + preDGreen + dimName + rst;
                }
                list.add(s);
                list.add(String.format("x: %s%.2f%s y: %s%.2f%s z: %s%.2f%s", preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                if (target.hasRotation) {
                    list.add(String.format("yaw: %s%.1f%s pitch: %s%.1f%s", preBlue, Float.valueOf(target.yaw), rst, preBlue, Float.valueOf(target.pitch), rst));
                }
                if (showBlock) {
                    list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.target", (Object[])new Object[0]) + ": " + preDGreen + blockName + rst);
                    if (advancedTooltips) {
                        list.add(String.format("%s meta: %d Side: %s (%d)", target.blockName, target.blockMeta, target.facing, target.blockFace));
                    }
                }
            } else {
                s = preDGreen + dimName + rst;
                if (dimName.length() == 0) {
                    s = I18n.func_135052_a((String)"enderutilities.tooltip.dimension.compact", (Object[])new Object[0]) + ": " + preBlue + target.dimension + rst;
                }
                if (showBlock) {
                    list.add(String.format("%s%s%s - %s @ %s%.2f%s %s%.2f%s %s%.2f%s", preDGreen, blockName, rst, s, preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                } else {
                    list.add(String.format("%s @ %s%.2f%s %s%.2f%s %s%.2f%s", s, preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                }
            }
        }
        if ((playerData = OwnerData.getOwnerDataFromItem(stack)) == null) {
            return;
        }
        String strPublic = "";
        strPublic = playerData.getIsPublic() ? TextFormatting.GREEN.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.public", (Object[])new Object[0]) + rst : TextFormatting.RED.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.private", (Object[])new Object[0]) + rst;
        if (verbose) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + strPublic);
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.owner", (Object[])new Object[0]) + ": " + preDGreen + playerData.getOwnerName() + rst);
        } else {
            list.add(strPublic + " - " + preDGreen + playerData.getOwnerName() + rst);
        }
    }

    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        OwnerData.togglePrivacyModeOnItem(stack, (Entity)player);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 262144)) {
            this.changePrivacyMode(stack, player);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            this.setTarget(stack, player, true);
        }
    }

    @Override
    public TargetData getTarget(ItemStack stack) {
        return TargetData.getTargetFromItem(stack);
    }

    public void setTarget(ItemStack stack, EntityPlayer player, boolean storeRotation) {
        BlockPos pos = player.func_180425_c();
        double hitX = player.field_70165_t - (double)pos.func_177958_n();
        double hitY = player.field_70163_u - (double)pos.func_177956_o();
        double hitZ = player.field_70161_v - (double)pos.func_177952_p();
        boolean adjustPosHit = stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((ItemLinkCrystal)stack.func_77973_b()).getModuleTier(stack) == 0;
        this.setTarget(stack, player, pos, EnumFacing.UP, hitX, hitY, hitZ, adjustPosHit, storeRotation);
    }

    @Override
    public void setTarget(ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        if (!OwnerData.canAccessItem(stack, (Entity)player)) {
            return;
        }
        TargetData.writeTargetTagToItem(stack, pos, player.field_71093_bK, side, player, hitX, hitY, hitZ, doHitOffset, player.field_70177_z, player.field_70125_A, storeRotation);
        OwnerData.addOwnerDataToItemOptional(stack, (Entity)player, true);
    }
}

