/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiCreationStation;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperPermissions;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerCreationStation;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCrafting;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public class TileEntityCreationStation
extends TileEntityEnderUtilitiesInventory
implements IModularInventoryHolder,
ITickable {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 2;
    public static final int GUI_ACTION_CLEAR_CRAFTING_GRID = 3;
    public static final int GUI_ACTION_RECIPE_LOAD = 4;
    public static final int GUI_ACTION_RECIPE_STORE = 5;
    public static final int GUI_ACTION_RECIPE_CLEAR = 6;
    public static final int GUI_ACTION_TOGGLE_MODE = 7;
    public static final int GUI_ACTION_SORT_ITEMS = 8;
    public static final int INV_SIZE_ITEMS = 27;
    public static final int INV_ID_MODULES = 1;
    public static final int INV_ID_CRAFTING_LEFT = 2;
    public static final int INV_ID_CRAFTING_RIGHT = 3;
    public static final int INV_ID_FURNACE = 4;
    public static final int COOKTIME_INC_SLOW = 12;
    public static final int COOKTIME_INC_FAST = 30;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int MODE_BIT_LEFT_CRAFTING_OREDICT = 1;
    public static final int MODE_BIT_LEFT_CRAFTING_KEEPONE = 2;
    public static final int MODE_BIT_LEFT_CRAFTING_AUTOUSE = 4;
    public static final int MODE_BIT_RIGHT_CRAFTING_OREDICT = 8;
    public static final int MODE_BIT_RIGHT_CRAFTING_KEEPONE = 16;
    public static final int MODE_BIT_RIGHT_CRAFTING_AUTOUSE = 32;
    public static final int MODE_BIT_LEFT_FAST = 64;
    public static final int MODE_BIT_RIGHT_FAST = 128;
    public static final int MODE_BIT_SHOW_RECIPE_LEFT = 16384;
    public static final int MODE_BIT_SHOW_RECIPE_RIGHT = 32768;
    private final IItemHandler itemHandlerMemoryCards;
    private final InventoryItemCallback itemInventory;
    private final ItemHandlerWrapperPermissions wrappedInventory;
    private final ItemStackHandlerTileEntity furnaceInventory;
    private final IItemHandler furnaceInventoryWrapper;
    private final InventoryItemCrafting[] craftingInventories;
    private final IItemHandler[] craftingInventoryWrappers;
    private final ItemStack[][] craftingGridTemplates;
    protected final ItemStackHandlerBasic[] craftResults;
    protected final ItemStack[][] recipeItems;
    protected int selectedModule;
    protected int actionMode;
    protected Map<UUID, Long> clickTimes;
    protected int numPlayersUsing;
    protected ItemStack[] smeltingResultCache;
    public int[] burnTimeRemaining;
    public int[] burnTimeFresh;
    public int[] cookTime;
    protected boolean[] inputDirty;
    protected int modeMask;
    protected byte furnaceMode;
    protected int recipeLoadClickCount;
    public int lastInteractedCraftingGrid;

    public TileEntityCreationStation() {
        super("creationstation");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(1, 4, 1, false, "Items", this);
        this.itemHandlerMemoryCards = new TileEntityHandyChest.ItemHandlerWrapperMemoryCards(this.getBaseItemHandler());
        this.itemInventory = new InventoryItemCallback(null, 27, true, false, null, this);
        this.wrappedInventory = new ItemHandlerWrapperPermissions(this.itemInventory, null);
        this.itemHandlerExternal = this.wrappedInventory;
        this.craftingInventories = new InventoryItemCrafting[2];
        this.craftingInventoryWrappers = new IItemHandler[2];
        this.craftingGridTemplates = new ItemStack[][]{null, null};
        this.craftResults = new ItemStackHandlerBasic[]{new ItemStackHandlerBasic(1), new ItemStackHandlerBasic(1)};
        this.recipeItems = new ItemStack[][]{new ItemStack[10], new ItemStack[10]};
        this.furnaceInventory = new ItemStackHandlerTileEntity(4, 6, 1024, true, "FurnaceItems", this);
        this.furnaceInventoryWrapper = new ItemHandlerWrapperFurnace(this.furnaceInventory);
        this.clickTimes = new HashMap<UUID, Long>();
        this.numPlayersUsing = 0;
        this.smeltingResultCache = new ItemStack[2];
        this.burnTimeRemaining = new int[2];
        this.burnTimeFresh = new int[2];
        this.cookTime = new int[2];
        this.inputDirty = new boolean[]{true, true};
        this.modeMask = 0;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setSelectedModuleSlot(nbt.func_74771_c("SelModule"));
        this.actionMode = nbt.func_74771_c("QuickMode");
        this.modeMask = nbt.func_74771_c("FurnaceMode");
        for (int i = 0; i < 2; ++i) {
            this.burnTimeRemaining[i] = nbt.func_74762_e("BurnTimeRemaining" + i);
            this.burnTimeFresh[i] = nbt.func_74762_e("BurnTimeFresh" + i);
            this.cookTime[i] = nbt.func_74762_e("CookTime" + i);
        }
        super.readFromNBTCustom(nbt);
        this.readModeMaskFromModule();
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        super.readItemsFromNBT(nbt);
        this.furnaceInventory.deserializeNBT(nbt);
        this.itemInventory.setContainerItemStack(this.getContainerStack());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        nbt.func_74774_a("FurnaceMode", (byte)(this.modeMask & 0xC0));
        for (int i = 0; i < 2; ++i) {
            nbt.func_74768_a("BurnTimeRemaining" + i, this.burnTimeRemaining[i]);
            nbt.func_74768_a("BurnTimeFresh" + i, this.burnTimeFresh[i]);
            nbt.func_74768_a("CookTime" + i, this.cookTime[i]);
        }
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        super.writeItemsToNBT(nbt);
        nbt.func_179237_a(this.furnaceInventory.serializeNBT());
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.selectedModule = tag.func_74771_c("msel");
        this.itemInventory.setIsRemote(true);
        super.handleUpdateTag(tag);
    }

    public IItemHandler getItemInventory(EntityPlayer player) {
        return new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return this.getItemInventory(player);
    }

    public InventoryItemCrafting getCraftingInventory(int id, Container container, EntityPlayer player) {
        if (this.craftingInventories[id] == null) {
            this.craftingInventories[id] = new InventoryItemCrafting(container, 3, 3, this.getContainerStack(), this.field_145850_b.field_72995_K, player, this, "CraftItems_" + id);
            this.craftingInventories[id].readFromContainerItemStack();
            this.craftingInventoryWrappers[id] = new InvWrapper((IInventory)this.craftingInventories[id]);
        }
        return this.craftingInventories[id];
    }

    public IItemHandler getCraftingInventoryWrapper(int id) {
        return this.craftingInventoryWrappers[id];
    }

    public ItemStackHandlerBasic getCraftResultInventory(int id) {
        return this.craftResults[id];
    }

    public IItemHandler getMemoryCardInventory() {
        return this.itemHandlerMemoryCards;
    }

    public IItemHandler getFurnaceInventory() {
        return this.furnaceInventoryWrapper;
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public int getSelectedModuleSlot() {
        return this.selectedModule;
    }

    public void setSelectedModuleSlot(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.itemHandlerMemoryCards.getSlots() - 1));
    }

    public int getModeMask() {
        return this.modeMask;
    }

    protected int readModeMaskFromModule() {
        NBTTagCompound tag;
        this.modeMask &= 0xC0;
        if (this.getContainerStack() != null && (tag = NBTUtils.getCompoundTag(this.getContainerStack(), null, "CreationStation", false)) != null) {
            this.modeMask |= tag.func_74765_d("ConfigMask");
        }
        return this.modeMask;
    }

    protected void writeModeMaskToModule() {
        int modeMask = this.modeMask;
        ItemStack stack = this.itemHandlerMemoryCards.extractItem(this.selectedModule, 1, false);
        if (stack != null) {
            NBTTagCompound tag = NBTUtils.getCompoundTag(stack, null, "CreationStation", true);
            tag.func_74777_a("ConfigMask", (short)(modeMask & 0xFFFFFF3F));
            this.itemHandlerMemoryCards.insertItem(this.selectedModule, stack, false);
        }
    }

    public int getRecipeId(int invId) {
        int s = invId == 1 ? 11 : 8;
        return this.modeMask >> s & 7;
    }

    public void setRecipeId(int invId, int recipeId) {
        int shift = invId == 1 ? 11 : 8;
        int mask = invId == 1 ? 14336 : 1792;
        this.modeMask = this.modeMask & ~mask | (recipeId & 7) << shift;
    }

    public boolean getShowRecipe(int invId) {
        return invId == 1 ? (this.modeMask & 0x8000) != 0 : (this.modeMask & 0x4000) != 0;
    }

    public void setShowRecipe(int invId, boolean show) {
        int mask;
        int n = mask = invId == 1 ? 32768 : 16384;
        this.modeMask = show ? (this.modeMask |= mask) : (this.modeMask &= ~mask);
    }

    public void getRecipeOutput(int invId, int recipeId) {
    }

    public ItemStack[] getRecipeItems(int invId) {
        invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1);
        return this.recipeItems[invId];
    }

    public NBTTagCompound getRecipeTag(int invId, int recipeId, boolean create) {
        ItemStack stack = this.getContainerStack();
        if (stack == null) {
            return null;
        }
        return NBTUtils.getCompoundTag(stack, "CreationStation", "Recipes_" + invId, create);
    }

    protected void loadRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            this.clearLoadedRecipe(invId);
            ItemStack[] items = this.getRecipeItems(invId);
            NBTUtils.readStoredItemsFromTag(tag, items, "Recipe_" + recipeId);
        } else {
            this.removeRecipe(invId, recipeId);
        }
    }

    protected void storeRecipe(int invId, int recipeId) {
        IItemHandler invCrafting = this.craftingInventoryWrappers[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return;
        }
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, true);
        if (tag != null) {
            int invSize = invCrafting.getSlots();
            ItemStack[] items = this.getRecipeItems(invId);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = invCrafting.getStackInSlot(i);
                if (stack != null) {
                    stack = stack.func_77946_l();
                    stack.field_77994_a = 1;
                }
                items[i] = stack;
            }
            items[items.length - 1] = ItemStack.func_77944_b((ItemStack)this.craftResults[invId].getStackInSlot(0));
            NBTUtils.writeItemsToTag(tag, items, "Recipe_" + recipeId, true);
        }
    }

    protected void clearLoadedRecipe(int invId) {
        ItemStack[] items = this.getRecipeItems(invId);
        for (int i = 0; i < items.length; ++i) {
            items[i] = null;
        }
    }

    protected void removeRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            tag.func_82580_o("Recipe_" + recipeId);
        }
        this.clearLoadedRecipe(invId);
    }

    protected boolean addOneSetOfRecipeItemsIntoGrid(int invId, int recipeId) {
        IItemHandler invCrafting = this.craftingInventoryWrappers[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return false;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        ItemStack[] template = this.getRecipeItems(invId);
        InventoryUtils.clearInventoryToMatchTemplate(invCrafting, (IItemHandler)this.itemInventory, template);
        return InventoryUtils.restockInventoryBasedOnTemplate(invCrafting, (IItemHandler)this.itemInventory, template, 1, true, useOreDict);
    }

    protected void fillCraftingGrid(int invId, int recipeId) {
        IItemHandler invCrafting = this.craftingInventoryWrappers[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return;
        }
        int largestStack = InventoryUtils.getLargestExistingStackSize(invCrafting);
        if (largestStack == 1) {
            largestStack = 64;
        }
        ItemStack[] template = InventoryUtils.createInventorySnapshot(invCrafting);
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        Map<ItemType, Integer> slotCounts = InventoryUtils.getSlotCountPerItem(invCrafting);
        if (InventoryUtils.tryMoveAllItems(invCrafting, (IItemHandler)this.itemInventory) == InventoryUtils.InvResult.MOVED_ALL) {
            for (Map.Entry<ItemType, Integer> entry : slotCounts.entrySet()) {
                int numSlots;
                int numFound;
                int maxSize;
                ItemType item = entry.getKey();
                if (item.getStack().func_77976_d() == 1 || (maxSize = (numFound = InventoryUtils.getNumberOfMatchingItemsInInventory((IItemHandler)this.itemInventory, item.getStack(), useOreDict)) / (numSlots = entry.getValue().intValue())) >= largestStack) continue;
                largestStack = maxSize;
            }
            InventoryUtils.restockInventoryBasedOnTemplate(invCrafting, (IItemHandler)this.itemInventory, template, largestStack, false, useOreDict);
        }
    }

    protected InventoryUtils.InvResult clearCraftingGrid(int invId, EntityPlayer player) {
        IItemHandler inv = this.craftingInventoryWrappers[MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (inv == null) {
            return InventoryUtils.InvResult.MOVED_NOTHING;
        }
        if (InventoryUtils.tryMoveAllItems(inv, (IItemHandler)this.itemInventory) != InventoryUtils.InvResult.MOVED_ALL) {
            return InventoryUtils.tryMoveAllItems(inv, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP));
        }
        return InventoryUtils.InvResult.MOVED_ALL;
    }

    public boolean canCraftItems(int invId) {
        boolean useOreDict;
        int maskKeepOne = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 16 : 2;
        int maskAutoUse = invId == 1 ? 32 : 4;
        this.craftingGridTemplates[invId] = null;
        IItemHandler invCrafting = this.craftingInventoryWrappers[invId];
        if (invCrafting == null) {
            return false;
        }
        if ((this.modeMask & maskAutoUse) != 0) {
            this.craftingGridTemplates[invId] = InventoryUtils.createInventorySnapshot(invCrafting);
        }
        if ((this.modeMask & maskKeepOne) == 0) {
            return true;
        }
        if ((this.modeMask & maskAutoUse) == 0 && InventoryUtils.getMinNonEmptyStackSize(invCrafting) <= 1) {
            return false;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean bl = useOreDict = (this.modeMask & maskOreDict) != 0;
        return InventoryUtils.getMinNonEmptyStackSize(invCrafting) > 1 || InventoryUtils.checkInventoryHasAllItems((IItemHandler)this.itemInventory, invCrafting, 1, useOreDict);
    }

    public void restockCraftingGrid(int invId) {
        int maskAutoUse;
        this.recipeLoadClickCount = 0;
        int n = maskAutoUse = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 32 : 4;
        if ((this.modeMask & maskAutoUse) == 0) {
            return;
        }
        if (this.craftingInventoryWrappers[invId] == null || this.craftingGridTemplates[invId] == null) {
            return;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        InventoryUtils.clearInventoryToMatchTemplate(this.craftingInventoryWrappers[invId], (IItemHandler)this.itemInventory, this.craftingGridTemplates[invId]);
        InventoryUtils.restockInventoryBasedOnTemplate(this.craftingInventoryWrappers[invId], (IItemHandler)this.itemInventory, this.craftingGridTemplates[invId], 1, true, useOreDict);
        this.craftingGridTemplates[invId] = null;
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemHandlerMemoryCards.getStackInSlot(this.selectedModule);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (inventoryId == 4) {
            this.inputDirty[1] = true;
            this.inputDirty[0] = true;
            return;
        }
        this.itemInventory.setContainerItemStack(this.getContainerStack());
        this.readModeMaskFromModule();
        if (this.craftingInventories[0] != null) {
            this.craftingInventories[0].setContainerItemStack(this.getContainerStack());
        }
        if (this.craftingInventories[1] != null) {
            this.craftingInventories[1].setContainerItemStack(this.getContainerStack());
        }
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
        this.func_70296_d();
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.wrappedInventory.isAccessibleByPlayer(player);
    }

    public void openInventory(EntityPlayer player) {
        ++this.numPlayersUsing;
    }

    public void closeInventory(EntityPlayer player) {
        if (--this.numPlayersUsing <= 0) {
            this.numPlayersUsing = 0;
            this.craftingInventories[0] = null;
            this.craftingInventories[1] = null;
            this.craftingInventoryWrappers[0] = null;
            this.craftingInventoryWrappers[1] = null;
        }
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.field_145850_b.func_82737_E() - last < 5L) {
            this.performGuiAction(player, 1, this.actionMode);
            player.field_70170_p.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.field_145850_b.func_82737_E());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.setSelectedModuleSlot(element);
            this.inventoryChanged(1, element);
        } else if (action == 1 && element >= 0 && element < 6) {
            ItemHandlerWrapperPermissions inventory = new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
            if (!inventory.isAccessibleByPlayer(player)) {
                return;
            }
            IItemHandlerModifiable playerMainInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            PlayerOffhandInvWrapper offhandInv = new PlayerOffhandInvWrapper(player.field_71071_by);
            CombinedInvWrapper playerInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{playerMainInv, offhandInv});
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, (IItemHandler)inventory, new SlotRange(9, 27), new SlotRange((IItemHandler)inventory));
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IItemHandler)playerInv, (IItemHandler)inventory, new SlotRange(9, 27), new SlotRange((IItemHandler)inventory));
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, (IItemHandler)inventory, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItems((IItemHandler)inventory, (IItemHandler)playerInv);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItems((IItemHandler)inventory, (IItemHandler)playerInv);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItems((IItemHandler)inventory, (IItemHandler)playerInv);
                }
            }
        } else if (action == 2 && element >= 0 && element < 6) {
            this.actionMode = element;
        } else if (action == 3 && element >= 0 && element <= 1) {
            IItemHandler inv = this.craftingInventoryWrappers[element];
            if (InventoryUtils.isInventoryEmpty(inv)) {
                this.setShowRecipe(element, false);
                this.clearLoadedRecipe(element);
                this.writeModeMaskToModule();
            } else {
                this.clearCraftingGrid(element, player);
            }
            this.recipeLoadClickCount = 0;
            this.lastInteractedCraftingGrid = element;
        } else if (action == 4 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            if (this.getRecipeId(invId) == recipeId && this.getShowRecipe(invId)) {
                if (this.recipeLoadClickCount == 0) {
                    if (this.addOneSetOfRecipeItemsIntoGrid(invId, recipeId)) {
                        ++this.recipeLoadClickCount;
                    }
                } else {
                    this.fillCraftingGrid(invId, recipeId);
                }
            } else {
                this.loadRecipe(invId, recipeId);
                this.setRecipeId(invId, recipeId);
                this.recipeLoadClickCount = 0;
            }
            this.setShowRecipe(invId, true);
            this.writeModeMaskToModule();
            this.lastInteractedCraftingGrid = invId;
        } else if (action == 5 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            this.storeRecipe(invId, recipeId);
            this.setShowRecipe(invId, true);
            this.setRecipeId(invId, recipeId);
            this.writeModeMaskToModule();
            this.lastInteractedCraftingGrid = invId;
        } else if (action == 6 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            this.removeRecipe(invId, recipeId);
            this.setShowRecipe(invId, false);
            this.writeModeMaskToModule();
            this.recipeLoadClickCount = 0;
            this.lastInteractedCraftingGrid = invId;
        } else if (action == 7 && element >= 0 && element < 8) {
            switch (element) {
                case 0: {
                    this.modeMask ^= 1;
                    break;
                }
                case 1: {
                    this.modeMask ^= 2;
                    break;
                }
                case 2: {
                    this.modeMask ^= 4;
                    break;
                }
                case 3: {
                    this.modeMask ^= 0x20;
                    break;
                }
                case 4: {
                    this.modeMask ^= 0x10;
                    break;
                }
                case 5: {
                    this.modeMask ^= 8;
                    break;
                }
                case 6: {
                    this.modeMask ^= 0x40;
                    break;
                }
                case 7: {
                    this.modeMask ^= 0x80;
                    break;
                }
            }
            if (element <= 5) {
                this.lastInteractedCraftingGrid = element / 3;
            }
            this.writeModeMaskToModule();
        } else if (action == 8 && element >= 0 && element <= 1) {
            if (element == 0) {
                ItemHandlerWrapperPermissions inventory = new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
                if (!inventory.isAccessibleByPlayer(player)) {
                    return;
                }
                InventoryUtils.sortInventoryWithinRange(this.itemInventory, new SlotRange((IItemHandler)this.itemInventory));
            } else {
                IItemHandlerModifiable inv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                InventoryUtils.sortInventoryWithinRange(inv, new SlotRange(9, 27));
            }
        }
    }

    public boolean isBurning(int id) {
        return this.burnTimeRemaining[id] > 0;
    }

    private void updateSmeltingResult(int id) {
        if (this.inputDirty[id]) {
            ItemStack inputStack = this.furnaceInventory.getStackInSlot(id * 3);
            this.smeltingResultCache[id] = inputStack != null ? FurnaceRecipes.func_77602_a().func_151395_a(inputStack) : null;
            this.inputDirty[id] = false;
        }
    }

    public boolean hasFuelAvailable(int id) {
        ItemStack fuelStack = this.furnaceInventory.getStackInSlot(id * 3 + 1);
        if (fuelStack == null) {
            return false;
        }
        return TileEntityEnderFurnace.itemContainsFluidFuel(fuelStack) || TileEntityEnderFurnace.getItemBurnTime(fuelStack) > 0;
    }

    public int consumeFuelItem(int id) {
        if (this.furnaceInventory.getStackInSlot(id * 3 + 1) == null) {
            return 0;
        }
        ItemStack fuelStack = this.furnaceInventory.extractItem(id * 3 + 1, 1, false);
        int burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(fuelStack);
        if (burnTime > 0) {
            this.furnaceInventory.insertItem(id * 3 + 1, fuelStack, false);
            this.burnTimeFresh[id] = burnTime;
        } else {
            burnTime = TileEntityEnderFurnace.getItemBurnTime(fuelStack);
            if (burnTime > 0) {
                this.burnTimeFresh[id] = burnTime;
                ItemStack containerStack = fuelStack.func_77973_b().getContainerItem(fuelStack);
                if (this.furnaceInventory.getStackInSlot(id * 3 + 1) == null && containerStack != null) {
                    this.furnaceInventory.insertItem(id * 3 + 1, containerStack, false);
                }
            }
        }
        return burnTime;
    }

    public boolean canSmelt(int id) {
        ItemStack inputStack = this.furnaceInventory.getStackInSlot(id * 3);
        if (inputStack == null || this.smeltingResultCache[id] == null) {
            return false;
        }
        int amount = 0;
        ItemStack outputStack = this.furnaceInventory.getStackInSlot(id * 3 + 2);
        if (outputStack != null) {
            if (!InventoryUtils.areItemStacksEqual(this.smeltingResultCache[id], outputStack)) {
                return false;
            }
            amount = outputStack.field_77994_a;
        }
        return this.furnaceInventory.getInventoryStackLimit() - amount >= this.smeltingResultCache[id].field_77994_a;
    }

    public void smeltItem(int id) {
        if (this.canSmelt(id)) {
            this.furnaceInventory.insertItem(id * 3 + 2, this.smeltingResultCache[id], false);
            this.furnaceInventory.extractItem(id * 3, 1, false);
            if (this.furnaceInventory.getStackInSlot(id * 3) == null) {
                this.inputDirty[id] = true;
            }
        }
    }

    protected void smeltingLogic(int id) {
        this.updateSmeltingResult(id);
        boolean dirty = false;
        boolean hasFuel = this.hasFuelAvailable(id);
        boolean isFastMode = id == 0 ? (this.modeMask & 0x40) != 0 : (this.modeMask & 0x80) != 0;
        int cookTimeIncrement = 12;
        if (this.burnTimeRemaining[id] == 0 && !hasFuel) {
            return;
        }
        if (isFastMode) {
            cookTimeIncrement = 30;
        }
        boolean canSmelt = this.canSmelt(id);
        if (this.burnTimeRemaining[id] > 0) {
            int btUse;
            int n = btUse = isFastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining[id]) {
                if (hasFuel && canSmelt) {
                    int n2 = id;
                    this.burnTimeRemaining[n2] = this.burnTimeRemaining[n2] + this.consumeFuelItem(id);
                    hasFuel = this.hasFuelAvailable(id);
                } else {
                    cookTimeIncrement = this.burnTimeRemaining[id] * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining[id];
                }
            }
            int n3 = id;
            this.burnTimeRemaining[n3] = this.burnTimeRemaining[n3] - btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            int n = id;
            this.burnTimeRemaining[n] = this.burnTimeRemaining[n] + this.consumeFuelItem(id);
            hasFuel = this.hasFuelAvailable(id);
            dirty = true;
        }
        if (canSmelt) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] + cookTimeIncrement;
            if (this.cookTime[id] >= 1200) {
                this.smeltItem(id);
                canSmelt = this.canSmelt(id);
                if (canSmelt && this.cookTime[id] > 1200) {
                    int n4 = id;
                    this.cookTime[n4] = this.cookTime[n4] - 1200;
                } else {
                    this.cookTime[id] = 0;
                }
            }
            if (this.burnTimeRemaining[id] == 0 && hasFuel && canSmelt) {
                int n5 = id;
                this.burnTimeRemaining[n5] = this.burnTimeRemaining[n5] + this.consumeFuelItem(id);
            }
            dirty = true;
        } else if (this.cookTime[id] > 0) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] - Math.min(this.cookTime[id], 6);
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.smeltingLogic(0);
        this.smeltingLogic(1);
    }

    public int getSmeltProgressScaled(int id, int i) {
        return this.cookTime[id] * i / 1200;
    }

    public int getBurnTimeRemainingScaled(int id, int i) {
        if (this.burnTimeFresh[id] == 0) {
            return 0;
        }
        return this.burnTimeRemaining[id] * i / this.burnTimeFresh[id];
    }

    @Override
    public ContainerCreationStation getContainer(EntityPlayer player) {
        return new ContainerCreationStation(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiCreationStation(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperFurnace
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperFurnace(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return true;
            }
            if (slot == 0 || slot == 3) {
                return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
            }
            return (slot == 1 || slot == 4) && TileEntityEnderFurnace.isItemFuel(stack);
        }
    }
}

