/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.BlockPortalPanel;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiPortalPanel;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.inventory.container.ContainerPortalPanel;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.PortalFormer;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;

public class TileEntityPortalPanel
extends TileEntityEnderUtilitiesInventory {
    private final ItemHandlerWrapper inventoryWrapper;
    private byte activeTargetId;
    private byte portalTargetId;
    private String displayName = "";
    private int[] colors = new int[9];

    public TileEntityPortalPanel() {
        super("portal_panel");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 16, 1, false, "Items", this);
        this.inventoryWrapper = new ItemHandlerWrapper(this.itemHandlerBase);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.itemHandlerBase, this.inventoryWrapper);
    }

    public int getActiveTargetId() {
        return this.activeTargetId;
    }

    private TargetData getActiveTarget() {
        int slot = this.getActiveTargetId();
        ItemStack stack = this.itemHandlerBase.getStackInSlot(slot);
        if (stack != null) {
            return TargetData.getTargetFromItem(stack);
        }
        return null;
    }

    private OwnerData getOwner() {
        int slot = this.getActiveTargetId();
        ItemStack stack = this.itemHandlerBase.getStackInSlot(slot);
        if (stack != null) {
            return OwnerData.getOwnerDataFromItem(stack);
        }
        return null;
    }

    public void setActiveTargetId(int target) {
        this.activeTargetId = (byte)MathHelper.func_76125_a((int)target, (int)0, (int)7);
    }

    public int getActiveColor() {
        return this.getColorFromItems(8);
    }

    private int getColorFromItems(int target) {
        ItemStack stack;
        if (target == 8) {
            target = this.activeTargetId;
        }
        if (target >= 0 && target < 8 && (stack = this.itemHandlerBase.getStackInSlot(target + 8)) != null && stack.func_77973_b() == Items.field_151100_aR) {
            return EnumDyeColor.func_176766_a((int)stack.func_77960_j()).func_176768_e().field_76291_p;
        }
        return 0xFFFFFF;
    }

    public int getColor(int target) {
        target = MathHelper.func_76125_a((int)target, (int)0, (int)8);
        return this.colors[target];
    }

    private String getActiveName() {
        ItemStack stack;
        if (this.activeTargetId >= 0 && this.activeTargetId < 8 && (stack = this.itemHandlerBase.getStackInSlot(this.activeTargetId)) != null && stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return "";
    }

    public void setTargetName(String name) {
        ItemStack stack;
        if (this.activeTargetId >= 0 && this.activeTargetId < 8 && (stack = this.itemHandlerBase.extractItem(this.activeTargetId, 64, false)) != null) {
            if (StringUtils.isBlank((CharSequence)name)) {
                stack.func_135074_t();
            } else {
                stack.func_151001_c(name);
            }
            this.itemHandlerBase.insertItem(this.activeTargetId, stack, false);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.setActiveTargetId(nbt.func_74771_c("SelectedTarget"));
        this.portalTargetId = nbt.func_74771_c("PortalTarget");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("SelectedTarget", this.activeTargetId);
        nbt.func_74774_a("PortalTarget", this.portalTargetId);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("s", this.activeTargetId);
        String name = this.getActiveName();
        if (!StringUtils.isBlank((CharSequence)name)) {
            nbt.func_74778_a("n", name);
        }
        for (int i = 0; i < 9; ++i) {
            nbt.func_74768_a("c" + i, this.getColorFromItems(i));
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.activeTargetId = tag.func_74771_c("s");
        this.displayName = tag.func_74779_i("n");
        for (int i = 0; i < 9; ++i) {
            this.colors[i] = tag.func_74762_e("c" + i);
            if (this.colors[i] != 0) continue;
            this.colors[i] = 0xFFFFFF;
        }
        super.handleUpdateTag(tag);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        super.inventoryChanged(inventoryId, slot);
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 8) {
            this.setActiveTargetId(element);
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
        }
    }

    @Override
    public ContainerEnderUtilities getContainer(EntityPlayer player) {
        return new ContainerPortalPanel(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiPortalPanel(this.getContainer(player), this);
    }

    public void tryTogglePortal() {
        boolean recreate;
        World world = this.func_145831_w();
        BlockPos posPanel = this.func_174877_v();
        BlockPos posFrame = posPanel.func_177972_a(((EnumFacing)world.func_180495_p(posPanel).func_177229_b((IProperty)BlockPortalPanel.FACING)).func_176734_d());
        PortalFormer portalFormer = new PortalFormer(world, posFrame, EnderUtilitiesBlocks.blockPortalFrame, EnderUtilitiesBlocks.blockPortal);
        portalFormer.setPortalData(this.getActiveTarget(), this.getOwner(), this.getActiveColor());
        portalFormer.analyzePortal();
        boolean state = portalFormer.getPortalState();
        boolean bl = recreate = this.activeTargetId != this.portalTargetId;
        if (!state) {
            if (portalFormer.togglePortalState(false)) {
                this.portalTargetId = this.activeTargetId;
                world.func_184133_a(null, posPanel, SoundEvents.field_187606_E, SoundCategory.MASTER, 0.5f, 1.0f);
            }
        } else if (portalFormer.togglePortalState(recreate)) {
            if (recreate) {
                this.portalTargetId = this.activeTargetId;
                world.func_184133_a(null, posPanel, SoundEvents.field_187606_E, SoundCategory.MASTER, 0.5f, 1.0f);
            } else {
                world.func_184133_a(null, posPanel, SoundEvents.field_187712_dQ, SoundCategory.MASTER, 0.4f, 0.85f);
            }
        }
    }

    private class ItemHandlerWrapper
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapper(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (slot < 8) {
                return stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((IModule)stack.func_77973_b()).getModuleTier(stack) == 0;
            }
            return stack.func_77973_b() == Items.field_151100_aR;
        }
    }
}

