/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockInfo {
    public final IBlockState blockState;
    public final IBlockState blockStateActual;
    public final Block block;
    public final int blockMeta;
    public final int itemMeta;
    public final ResourceLocation resource;

    public BlockInfo(IBlockState state, IBlockState stateActual, Block block, int meta, int itemMeta) {
        this.blockState = state;
        this.blockStateActual = stateActual;
        this.block = block;
        this.blockMeta = meta;
        this.resource = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.block);
        this.itemMeta = itemMeta;
    }

    public BlockInfo(ResourceLocation resource, int blockMeta, int itemMeta) {
        this((Block)ForgeRegistries.BLOCKS.getValue(resource), blockMeta, itemMeta);
    }

    public BlockInfo(Block block, int blockMeta, int itemMeta) {
        this.block = block;
        this.blockMeta = blockMeta;
        this.itemMeta = itemMeta;
        this.blockStateActual = this.blockState = this.block.func_176203_a(this.blockMeta);
        this.resource = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
    }

    public static BlockInfo getBlockInfo(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateActual = state.func_185899_b((IBlockAccess)world, pos);
        Block block = state.func_177230_c();
        ItemStack stack = block.func_185473_a(world, pos, state);
        return new BlockInfo(state, stateActual, block, block.func_176201_c(state), stack != null ? stack.func_77960_j() : 0);
    }

    public String toString() {
        return String.format("BlockInfo: {ResourceLocation: %s, blockMeta: %d, itemMeta: %d}", this.resource, this.blockMeta, this.itemMeta);
    }
}

