/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockUtils {
    public static void breakBlockAsPlayer(World world, BlockPos pos, EntityPlayerMP playerMP, ItemStack toolStack) {
        PlayerInteractionManager manager = playerMP.field_71134_c;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)manager.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
        if (exp != -1) {
            IBlockState stateExisting = world.func_180495_p(pos);
            Block blockExisting = stateExisting.func_177230_c();
            blockExisting.func_176208_a(world, pos, stateExisting, (EntityPlayer)playerMP);
            boolean harvest = blockExisting.removedByPlayer(stateExisting, world, pos, (EntityPlayer)playerMP, true);
            if (harvest) {
                blockExisting.func_176206_d(world, pos, stateExisting);
                blockExisting.func_180657_a(world, (EntityPlayer)playerMP, pos, stateExisting, world.func_175625_s(pos), toolStack);
            }
        }
    }

    public static void placeBlock(World world, BlockPos pos, IBlockState newState, int setBlockStateFlags) {
        world.func_180501_a(pos, newState, setBlockStateFlags);
        SoundType soundtype = newState.func_177230_c().func_185467_w();
        world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
    }

    public static ItemStack getStackedItemFromBlock(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return BlockUtils.getStackedItemFromBlock(world, pos, state, player, side);
    }

    public static ItemStack getStackedItemFromBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side) {
        RayTraceResult trace = new RayTraceResult(new Vec3d((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5), side, pos);
        return state.func_177230_c().getPickBlock(state, trace, world, pos, player);
    }

    public static ItemStack getStackedItemFromBlock(World world, BlockPos pos) {
        return BlockUtils.getStackedItemFromBlock(world.func_180495_p(pos));
    }

    public static ItemStack getStackedItemFromBlock(IBlockState state) {
        Block block = state.func_177230_c();
        ItemStack stack = null;
        try {
            Method method = ReflectionHelper.findMethod(Block.class, (Object)block, (String[])new String[]{"func_180643_i", "createStackedBlock"}, (Class[])new Class[]{IBlockState.class});
            stack = (ItemStack)method.invoke((Object)block, state);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            EnderUtilities.logger.error("Error while trying reflect Block#createStackBlock() from {} (UnableToFindMethodException)", new Object[]{block.getClass().getSimpleName()});
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            EnderUtilities.logger.error("Error while trying reflect Block#createStackBlock() from {} (InvocationTargetException)", new Object[]{block.getClass().getSimpleName()});
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            EnderUtilities.logger.error("Error while trying reflect Block#createStackBlock() from {} (IllegalAccessException)", new Object[]{block.getClass().getSimpleName()});
            e.printStackTrace();
        }
        return stack;
    }

    public static boolean blockMatches(World world, BlockPos pos, Block requiredBlock, int requiredMeta, Class<? extends TileEntity> TEClass, EnumFacing requiredOrientation) {
        IBlockState iBlockState = world.func_180495_p(pos);
        Block block = iBlockState.func_177230_c();
        int meta = block.func_176201_c(iBlockState);
        TileEntity te = world.func_175625_s(pos);
        if (block != requiredBlock || meta != requiredMeta && requiredMeta != Short.MAX_VALUE) {
            return false;
        }
        if (te == null && TEClass == null) {
            return true;
        }
        return te != null && TEClass != null && TEClass.isAssignableFrom(te.getClass()) && (requiredOrientation == null || te instanceof TileEntityEnderUtilities && ((TileEntityEnderUtilities)te).getFacing() == requiredOrientation);
    }

    public static boolean checkCanPlaceBlockAt(World world, BlockPos pos, EnumFacing side, Block blockNew, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block blockExisting = world.func_180495_p(pos).func_177230_c();
        if (blockExisting == Blocks.field_150431_aC && blockExisting.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
        } else if (!blockExisting.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        return world.func_175716_a(blockNew, pos, false, side, (Entity)null, stack);
    }
}

