/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TemplateEnderUtilities {
    protected final List<TemplateBlockInfo> blocks = Lists.newArrayList();
    protected final List<TemplateEntityInfo> entities = Lists.newArrayList();
    protected PlacementSettings placement;
    protected BlockPos size = BlockPos.field_177992_a;
    protected String author = "?";
    protected ReplaceMode replaceMode;
    protected boolean dropOldBlocks;

    public TemplateEnderUtilities() {
    }

    public TemplateEnderUtilities(PlacementSettings placement, ReplaceMode replaceMode) {
        this.placement = placement;
        this.replaceMode = replaceMode;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public BlockPos getTemplateSize() {
        return this.size;
    }

    public void setPlacementSettings(PlacementSettings placement) {
        this.placement = placement;
    }

    public PlacementSettings getPlacementSettings() {
        return this.placement;
    }

    public void setReplaceMode(ReplaceMode mode) {
        this.replaceMode = mode;
    }

    public List<TemplateBlockInfo> getBlockList() {
        return this.blocks;
    }

    public void setDropOldBlocks(boolean drop) {
        this.dropOldBlocks = drop;
    }

    public void addBlocksToWorld(World world, BlockPos posStart) {
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.placeBlockAtIndex(world, i, posStart);
        }
        this.addEntitiesToWorld(world, posStart);
    }

    public void placeBlockAtIndex(World world, int index, BlockPos posStart) {
        if (index < this.blocks.size()) {
            TemplateBlockInfo blockInfo = this.blocks.get(index);
            BlockPos pos = TemplateEnderUtilities.transformedBlockPos(this.placement, blockInfo.pos).func_177971_a((Vec3i)posStart);
            IBlockState state = blockInfo.blockState;
            if (this.replaceMode == ReplaceMode.EVERYTHING || this.replaceMode == ReplaceMode.WITH_NON_AIR && state.func_185904_a() != Material.field_151579_a || world.func_175623_d(pos)) {
                TileEntity te;
                state = state.func_185902_a(this.placement.func_186212_b()).func_185907_a(this.placement.func_186215_c());
                boolean success = false;
                if (this.dropOldBlocks) {
                    IBlockState stateOld = world.func_180495_p(pos);
                    stateOld.func_177230_c().func_176226_b(world, pos, stateOld, 0);
                    world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 4);
                    success = world.func_180501_a(pos, state, 2);
                } else {
                    world.restoringBlockSnapshots = true;
                    world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 4);
                    success = world.func_180501_a(pos, state, 2);
                    world.restoringBlockSnapshots = false;
                }
                if (success && blockInfo.tileEntityData != null && (te = world.func_175625_s(pos)) != null) {
                    NBTUtils.setPositionInTileEntityNBT(blockInfo.tileEntityData, pos);
                    te.func_145839_a(blockInfo.tileEntityData);
                    te.func_70296_d();
                }
            }
        }
    }

    public void notifyBlocks(World world, BlockPos posStart) {
        for (TemplateBlockInfo blockInfo : this.blocks) {
            BlockPos pos = TemplateEnderUtilities.transformedBlockPos(this.placement, blockInfo.pos).func_177971_a((Vec3i)posStart);
            IBlockState state = world.func_180495_p(pos);
            if (blockInfo.tileEntityData != null) {
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    te.func_70296_d();
                }
                world.func_184138_a(pos, state, state, 7);
                continue;
            }
            world.func_175722_b(pos, blockInfo.blockState.func_177230_c());
        }
    }

    public void addEntitiesToWorld(World world, BlockPos posStart) {
        if (this.placement.func_186221_e()) {
            return;
        }
        Mirror mirror = this.placement.func_186212_b();
        Rotation rotation = this.placement.func_186215_c();
        int x1 = posStart.func_177958_n();
        int y1 = posStart.func_177956_o();
        int z1 = posStart.func_177952_p();
        int x2 = this.size.func_177958_n();
        int y2 = this.size.func_177956_o();
        int z2 = this.size.func_177952_p();
        AxisAlignedBB bb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)(x1 + x2), (double)(y1 + y2), (double)(z1 + z2));
        List existingEntities = world.func_72839_b(null, bb);
        for (TemplateEntityInfo entityInfo : this.entities) {
            Entity entity;
            BlockPos pos = TemplateEnderUtilities.transformedBlockPos(this.placement, entityInfo.blockPos).func_177971_a((Vec3i)posStart);
            NBTTagCompound nbt = entityInfo.entityData;
            UUID uuidOriginal = nbt.func_186857_a("UUID");
            Vec3d vec3d = PositionUtils.transformedVec3d(entityInfo.pos, mirror, rotation);
            Vec3d vec3d1 = vec3d.func_72441_c((double)posStart.func_177958_n(), (double)posStart.func_177956_o(), (double)posStart.func_177952_p());
            NBTTagList tagList = new NBTTagList();
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbt.func_74782_a("Pos", (NBTBase)tagList);
            nbt.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
            }
            catch (Exception e) {
                entity = null;
            }
            if (entity == null) continue;
            if (entity instanceof EntityPainting) {
                entity.func_184217_a(mirror);
                entity.func_184229_a(rotation);
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            } else {
                float f = entity.func_184217_a(mirror);
                entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
            }
            Object existing = EntityUtils.findEntityByUUID(existingEntities, uuidOriginal);
            if (existing != null) {
                world.func_72973_f(existing);
                entity.func_184221_a(uuidOriginal);
            } else if (world instanceof WorldServer && ((WorldServer)world).func_175733_a(uuidOriginal) == null) {
                entity.func_184221_a(uuidOriginal);
            }
            world.func_72838_d(entity);
        }
    }

    public void takeBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos endPosRelative, boolean takeEntities) {
        BlockPos endPos = startPos.func_177971_a((Vec3i)endPosRelative);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        this.size = PositionUtils.getAreaSizeFromRelativeEndPosition(endPosRelative);
        for (BlockPos.MutableBlockPos posMutable : BlockPos.func_177975_b((BlockPos)startPos, (BlockPos)endPos)) {
            BlockPos posRelative = posMutable.func_177973_b((Vec3i)startPos);
            IBlockState state = worldIn.func_180495_p((BlockPos)posMutable);
            TileEntity te = worldIn.func_175625_s((BlockPos)posMutable);
            if (te != null) {
                NBTTagCompound tag = new NBTTagCompound();
                te.func_189515_b(tag);
                tag.func_82580_o("x");
                tag.func_82580_o("y");
                tag.func_82580_o("z");
                list1.add(new TemplateBlockInfo(posRelative, state, tag));
                continue;
            }
            if (!state.func_185913_b() && !state.func_185917_h()) {
                list2.add(new TemplateBlockInfo(posRelative, state, null));
                continue;
            }
            list.add(new TemplateBlockInfo(posRelative, state, null));
        }
        this.blocks.clear();
        this.blocks.addAll(list);
        this.blocks.addAll(list1);
        this.blocks.addAll(list2);
        if (takeEntities) {
            this.takeEntitiesFromWorld(worldIn, startPos, endPos.func_177982_a(1, 1, 1));
        } else {
            this.entities.clear();
        }
    }

    public void takeEntitiesFromWorld(World world, BlockPos startPos, BlockPos endPos) {
        List list = world.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return !(entity instanceof EntityPlayer);
            }
        });
        this.entities.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.field_70165_t - (double)startPos.func_177958_n(), entity.field_70163_u - (double)startPos.func_177956_o(), entity.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound nbt = new NBTTagCompound();
            entity.func_70039_c(nbt);
            BlockPos pos = entity instanceof EntityPainting ? ((EntityPainting)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new TemplateEntityInfo(vec3d, pos, nbt));
        }
    }

    public void write(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        ResourceLocation[] idMap = new ResourceLocation[4096];
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int stateId = 0;
        int blockId = 0;
        for (TemplateBlockInfo templateBlockInfo : this.blocks) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("pos", (NBTBase)NBTUtils.writeInts(templateBlockInfo.pos.func_177958_n(), templateBlockInfo.pos.func_177956_o(), templateBlockInfo.pos.func_177952_p()));
            stateId = Block.func_176210_f((IBlockState)templateBlockInfo.blockState);
            nbt.func_74768_a("state", stateId);
            blockId = stateId & 0xFFF;
            if (idMap[blockId] == null) {
                idMap[blockId] = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)templateBlockInfo.blockState.func_177230_c());
                ids.add(blockId);
            }
            if (templateBlockInfo.tileEntityData != null) {
                nbt.func_74782_a("nbt", (NBTBase)templateBlockInfo.tileEntityData);
            }
            nbttaglist.func_74742_a((NBTBase)nbt);
        }
        NBTTagList tagIdMap = new NBTTagList();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (idMap[id] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", idMap[id].toString());
            tag.func_74777_a("id", (short)id);
            tagIdMap.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("blockidmap", (NBTBase)tagIdMap);
        NBTTagList nBTTagList = new NBTTagList();
        for (TemplateEntityInfo entityInfo : this.entities) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("pos", (NBTBase)NBTUtils.writeDoubles(entityInfo.pos.field_72450_a, entityInfo.pos.field_72448_b, entityInfo.pos.field_72449_c));
            nbttagcompound1.func_74782_a("blockPos", (NBTBase)NBTUtils.writeInts(entityInfo.blockPos.func_177958_n(), entityInfo.blockPos.func_177956_o(), entityInfo.blockPos.func_177952_p()));
            if (entityInfo.entityData != null) {
                nbttagcompound1.func_74782_a("nbt", (NBTBase)entityInfo.entityData);
            }
            nBTTagList.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("blocks", (NBTBase)nbttaglist);
        compound.func_74782_a("entities", (NBTBase)nBTTagList);
        compound.func_74782_a("size", (NBTBase)NBTUtils.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        compound.func_74768_a("version", 1);
        compound.func_74778_a("author", this.author);
    }

    public void read(NBTTagCompound compound) {
        NBTTagList tagListPos;
        int i;
        this.blocks.clear();
        this.entities.clear();
        this.author = compound.func_74779_i("author");
        NBTTagList tagList = compound.func_150295_c("size", 3);
        this.size = new BlockPos(tagList.func_186858_c(0), tagList.func_186858_c(1), tagList.func_186858_c(2));
        boolean hasIdMap = compound.func_150297_b("blockidmap", 9);
        Block[] blockMap = new Block[4096];
        if (hasIdMap) {
            NBTTagList tagIdMap = compound.func_150295_c("blockidmap", 10);
            for (int i2 = 0; i2 < tagIdMap.func_74745_c(); ++i2) {
                NBTTagCompound tag = tagIdMap.func_150305_b(i2);
                short id = (short)(tag.func_74765_d("id") & 0xFFF);
                blockMap[id] = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("name")));
            }
        }
        tagList = compound.func_150295_c("blocks", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            Block block;
            NBTTagCompound tag = tagList.func_150305_b(i);
            tagListPos = tag.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(tagListPos.func_186858_c(0), tagListPos.func_186858_c(1), tagListPos.func_186858_c(2));
            int stateId = tag.func_74762_e("state");
            if (hasIdMap && (block = blockMap[stateId & 0xFFF]) != null) {
                stateId &= 0xF000;
                stateId |= Block.func_149682_b((Block)block);
            }
            IBlockState iblockstate = Block.func_176220_d((int)stateId);
            NBTTagCompound tagTileEntityData = tag.func_74764_b("nbt") ? tag.func_74775_l("nbt") : null;
            this.blocks.add(new TemplateBlockInfo(blockpos, iblockstate, tagTileEntityData));
        }
        tagList = compound.func_150295_c("entities", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            tagListPos = tag.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(tagListPos.func_150309_d(0), tagListPos.func_150309_d(1), tagListPos.func_150309_d(2));
            tagListPos = tag.func_150295_c("blockPos", 3);
            BlockPos blockpos1 = new BlockPos(tagListPos.func_186858_c(0), tagListPos.func_186858_c(1), tagListPos.func_186858_c(2));
            if (!tag.func_74764_b("nbt")) continue;
            NBTTagCompound tagEntityNBT = tag.func_74775_l("nbt");
            this.entities.add(new TemplateEntityInfo(vec3d, blockpos1, tagEntityNBT));
        }
    }

    public static BlockPos transformedBlockPos(PlacementSettings placement, BlockPos pos) {
        return PositionUtils.getTransformedBlockPos(pos, placement.func_186212_b(), placement.func_186215_c());
    }

    public static enum ReplaceMode {
        NOTHING,
        EVERYTHING,
        WITH_NON_AIR;

    }

    public static class TemplateEntityInfo {
        public final Vec3d pos;
        public final BlockPos blockPos;
        public final NBTTagCompound entityData;

        TemplateEntityInfo(Vec3d vecIn, BlockPos posIn, NBTTagCompound entityNBT) {
            this.pos = vecIn;
            this.blockPos = posIn;
            this.entityData = entityNBT;
        }
    }

    public static class TemplateBlockInfo {
        public final BlockPos pos;
        public final IBlockState blockState;
        public final NBTTagCompound tileEntityData;

        TemplateBlockInfo(BlockPos posIn, IBlockState stateIn, NBTTagCompound tileEntityNBT) {
            this.pos = posIn;
            this.blockState = stateIn;
            this.tileEntityData = tileEntityNBT;
        }
    }
}

