/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionHelper;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TeleportEntity {
    public static void addTeleportSoundsAndParticles(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(1, 3, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 24.0));
        }
    }

    public static boolean canTeleportEntity(Entity entity) {
        return !EntityUtils.doesEntityStackHaveBlacklistedEntities(entity);
    }

    public static boolean teleportEntityRandomly(Entity entity, double maxDist) {
        if (entity == null || !TeleportEntity.canTeleportEntity(entity) || entity.field_70170_p.field_72995_K) {
            return false;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        double deltaYaw = 0.0;
        double deltaPitch = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        maxDist -= Math.random() * maxDist / 2.0;
        for (int i = 0; i < 10; ++i) {
            deltaYaw = Math.random() * 360.0 / 180.0 * Math.PI;
            deltaPitch = Math.random() * 90.0 / 180.0 * Math.PI;
            x = entity.field_70165_t;
            y = entity.field_70163_u;
            z = entity.field_70161_v;
            x += Math.cos(deltaPitch) * Math.cos(deltaYaw) * maxDist;
            z += Math.cos(deltaPitch) * Math.sin(deltaYaw) * maxDist;
            y += Math.sin(deltaPitch) * maxDist;
            if (entity.func_174813_aQ() == null || !entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) continue;
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
            return true;
        }
        return false;
    }

    public static boolean entityTeleportWithProjectile(Entity entity, Entity projectile, RayTraceResult rayTraceResult, float teleportDamage, boolean allowMounts, boolean allowRiders) {
        Entity entNew;
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return false;
        }
        PositionHelper pos = new PositionHelper(rayTraceResult, projectile);
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            pos.adjustPositionToTouchFace(entity, rayTraceResult.field_178784_b);
        }
        if ((entNew = TeleportEntity.teleportEntity(entity, pos.posX, pos.posY, pos.posZ, projectile.field_71093_bK, allowMounts, allowRiders)) != null) {
            Entity bottom;
            if (teleportDamage != 0.0f && (bottom = EntityUtils.getBottomEntity(entNew)) instanceof EntityLivingBase) {
                bottom.func_70097_a(DamageSource.field_76379_h, teleportDamage);
            }
            entNew.field_70143_R = 0.0f;
            return true;
        }
        return false;
    }

    public static TargetData adjustTargetPosition(TargetData target, Entity entity) {
        if (target == null || target.blockFace < 0) {
            return target;
        }
        float widthAdj = 0.5f;
        float heightAdj = 1.0f;
        if (entity != null) {
            widthAdj = entity.field_70130_N / 2.0f;
            heightAdj = entity.field_70131_O;
        }
        target.dPosX += (double)((float)target.facing.func_82601_c() * widthAdj);
        target.dPosZ += (double)((float)target.facing.func_82599_e() * widthAdj);
        if (target.facing.equals((Object)EnumFacing.DOWN)) {
            target.dPosY -= (double)heightAdj;
        }
        return target;
    }

    public static Entity teleportEntityUsingModularItem(Entity entity, ItemStack stack) {
        return TeleportEntity.teleportEntityUsingModularItem(entity, stack, true, true);
    }

    public static Entity teleportEntityUsingModularItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        return TeleportEntity.teleportEntityUsingItem(entity, UtilItemModular.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL), allowMounts, allowRiders);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack) {
        return TeleportEntity.teleportEntityUsingItem(entity, stack, true, true);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        TargetData target = TargetData.getTargetFromItem(stack);
        if (target != null) {
            return TeleportEntity.teleportEntityUsingTarget(entity, target, allowMounts, allowRiders);
        }
        return null;
    }

    public static Entity teleportEntityUsingTarget(Entity entity, TargetData target, boolean allowMounts, boolean allowRiders) {
        if (target == null || entity == null) {
            return null;
        }
        TeleportEntity.adjustTargetPosition(target, entity);
        if (target.hasRotation && entity != null) {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, target.yaw, target.pitch);
            } else {
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, target.yaw, target.pitch);
            }
        }
        return TeleportEntity.teleportEntity(entity, target.dPosX, target.dPosY, target.dPosZ, target.dimension, allowMounts, allowRiders);
    }

    public static Entity teleportEntity(Entity entityIn, double x, double y, double z, int dimDst, boolean allowMounts, boolean allowRiders) {
        Entity teleported;
        if (entityIn == null || entityIn.field_70170_p == null || entityIn.field_70170_p.field_72995_K) {
            return null;
        }
        if (!allowMounts && entityIn.func_184218_aH()) {
            return null;
        }
        if (!allowRiders && entityIn.func_184207_aI()) {
            return null;
        }
        if (!TeleportEntity.canTeleportEntity(entityIn)) {
            return null;
        }
        UUID uuidOriginal = entityIn.func_110124_au();
        Entity entity = EntityUtils.getBottomEntity(entityIn);
        List passengers = null;
        boolean ridden = false;
        boolean reCreate = EntityUtils.doesEntityStackHavePlayers(entityIn);
        boolean isOriginal = entity != entityIn;
        ridden = entity.func_184207_aI();
        if (ridden) {
            passengers = entity.func_184188_bt();
            for (Entity passenger : passengers) {
                passenger.func_184210_p();
            }
        }
        if ((teleported = TeleportEntity.teleportEntity(entity, x, y, z, dimDst, reCreate)) == null) {
            return null;
        }
        teleported.field_70143_R = 0.0f;
        if (ridden) {
            for (Entity passenger : passengers) {
                Entity teleportedPassenger = TeleportEntity.teleportEntity(passenger, x, y, z, dimDst, allowMounts, allowRiders);
                if (teleportedPassenger == null) continue;
                teleportedPassenger.func_184205_a(teleported, true);
            }
        }
        if (isOriginal) {
            teleported = EntityUtils.findEntityFromStackByUUID(teleported, uuidOriginal);
        }
        return teleported;
    }

    private static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean forceRecreate) {
        EnderTeleportEvent etpEvent;
        if (entity == null || entity.field_70128_L || !TeleportEntity.canTeleportEntity(entity) || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(etpEvent = new EnderTeleportEvent((EntityLivingBase)entity, x, y, z, 0.0f)))) {
            return null;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p instanceof WorldServer) {
            WorldServer worldServerDst = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimDst);
            if (worldServerDst == null) {
                EnderUtilities.logger.warn("teleportEntity(): worldServerDst == null");
                return null;
            }
            int chunkX = (int)x >> 4;
            int chunkZ = (int)z >> 4;
            if (!worldServerDst.func_72863_F().func_73149_a(chunkX, chunkZ)) {
                worldServerDst.func_72863_F().func_186028_c(chunkX, chunkZ);
            }
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70657_f(0.0f);
                ((EntityLiving)entity).func_70661_as().func_75499_g();
            }
            if (entity.field_71093_bK != dimDst || entity.field_70170_p instanceof WorldServer && entity.field_70170_p != worldServerDst) {
                entity = TeleportEntity.transferEntityToDimension(entity, dimDst, x, y, z);
            } else if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
        }
        if (entity != null) {
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
        }
        return entity;
    }

    private static Entity transferEntityToDimension(Entity entitySrc, int dimDst, double x, double y, double z) {
        if (entitySrc == null || entitySrc.field_70128_L || entitySrc.field_71093_bK == dimDst || entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        if (entitySrc instanceof EntityPlayerMP) {
            return TeleportEntity.transferPlayerToDimension((EntityPlayerMP)entitySrc, dimDst, x, y, z);
        }
        ChunkLoading.getInstance().loadChunkForcedWithModTicket(dimDst, (int)x >> 4, (int)z >> 4, 10);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldServerSrc = server.func_71218_a(entitySrc.field_71093_bK);
        WorldServer worldServerDst = server.func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            EnderUtilities.logger.warn("transferEntityToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        entitySrc.field_71093_bK = dimDst;
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        EntityUtils.copyDataFromOld(entityDst, entitySrc);
        if (entitySrc instanceof EntityMinecartContainer) {
            entitySrc.field_70128_L = true;
        } else {
            entitySrc.field_70170_p.func_72900_e(entitySrc);
        }
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_72866_a(entityDst, false);
        entityDst.func_70029_a((World)worldServerDst);
        entitySrc.field_70128_L = true;
        worldServerSrc.func_82742_i();
        worldServerDst.func_82742_i();
        return entityDst;
    }

    private static EntityPlayer transferPlayerToDimension(EntityPlayerMP player, int dimDst, double x, double y, double z) {
        DragonFightManager manager;
        if (player == null || player.field_70128_L || player.field_71093_bK == dimDst || player.field_70170_p.field_72995_K) {
            return null;
        }
        int dimSrc = player.field_71093_bK;
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldServerSrc = server.func_71218_a(dimSrc);
        WorldServer worldServerDst = server.func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            EnderUtilities.logger.warn("transferPlayerToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        player.field_71093_bK = dimDst;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71133_b.func_184103_al().func_187243_f(player);
        worldServerSrc.func_72900_e((Entity)player);
        player.field_70128_L = false;
        worldServerDst.func_72838_d((Entity)player);
        worldServerDst.func_72866_a((Entity)player, false);
        player.func_70029_a((World)worldServerDst);
        player.field_71133_b.func_184103_al().func_72375_a(player, worldServerSrc);
        player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServerDst);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        player.field_71133_b.func_184103_al().func_72354_b(player, worldServerDst);
        player.field_71133_b.func_184103_al().func_72385_f(player);
        player.func_82242_a(0);
        player.func_71118_n();
        if (worldServerSrc.field_73011_w instanceof WorldProviderEnd && (manager = ((WorldProviderEnd)worldServerSrc.field_73011_w).func_186063_s()) != null) {
            try {
                BossInfoServer bossInfo = (BossInfoServer)ReflectionHelper.getPrivateValue(DragonFightManager.class, (Object)manager, (String[])new String[]{"field_186109_c", "bossInfo"});
                if (bossInfo != null) {
                    bossInfo.func_186761_b(player);
                }
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                EnderUtilities.logger.warn("TeleportEntity.transferPlayerToDimension: Failed to get DragonFightManager#bossInfo");
            }
        }
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimSrc, dimDst);
        return player;
    }
}

