/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleportEntityNetherPortal {
    private EnumFacing portalAxis = EnumFacing.NORTH;
    private BlockPos portalPos = null;
    private BlockPos entityPos = null;

    public Entity travelToDimension(Entity entity, int dimension, BlockPos idealPos, int portalSearchRadius, boolean placeInsidePortal) {
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        if (!this.searchForExistingPortal((World)worldServer, idealPos, portalSearchRadius)) {
            double origX = entity.field_70165_t;
            double origY = entity.field_70163_u;
            double origZ = entity.field_70161_v;
            entity.field_70165_t = (double)idealPos.func_177958_n() + 0.5;
            entity.field_70163_u = (double)idealPos.func_177956_o() + 0.5;
            entity.field_70161_v = (double)idealPos.func_177952_p() + 0.5;
            worldServer.func_85176_s().func_85188_a(entity);
            entity.field_70165_t = origX;
            entity.field_70163_u = origY;
            entity.field_70161_v = origZ;
            if (!this.searchForExistingPortal((World)worldServer, idealPos, 20)) {
                return null;
            }
        }
        this.findTeleportPosition((World)worldServer, placeInsidePortal);
        return TeleportEntity.teleportEntity(entity, (double)this.entityPos.func_177958_n() + 0.5, (double)this.entityPos.func_177956_o() + 0.5, (double)this.entityPos.func_177952_p() + 0.5, dimension, true, true);
    }

    public boolean searchForExistingPortal(World world, BlockPos idealPos, int searchRadius) {
        BlockPos pos = null;
        double distance = -1.0;
        for (int x = idealPos.func_177958_n() - searchRadius; x <= idealPos.func_177958_n() + searchRadius; ++x) {
            double dx = (double)x + 0.5 - (double)idealPos.func_177958_n();
            for (int z = idealPos.func_177952_p() - searchRadius; z <= idealPos.func_177952_p() + searchRadius; ++z) {
                double dz = (double)z + 0.5 - (double)idealPos.func_177952_p();
                for (int y = world.func_72940_L() - 1; y >= 0; --y) {
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150427_aO) continue;
                    while (world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == Blocks.field_150427_aO) {
                        --y;
                    }
                    double dy = (double)y + 0.5 - (double)idealPos.func_177956_o();
                    double distTemp = dx * dx + dy * dy + dz * dz;
                    if (!(distance < 0.0) && !(distTemp < distance)) continue;
                    distance = distTemp;
                    pos = new BlockPos(x, y, z);
                }
            }
        }
        if (distance >= 0.0) {
            this.portalPos = pos;
            this.getPortalOrientation(world);
        }
        return distance >= 0.0;
    }

    public void getPortalOrientation(World world) {
        BlockPos pos = this.portalPos;
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150427_aO || world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150427_aO) {
            this.portalAxis = EnumFacing.EAST;
        } else if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150427_aO || world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150427_aO) {
            this.portalAxis = EnumFacing.SOUTH;
        }
    }

    public void findTeleportPosition(World world, boolean placeInsidePortal) {
        if (placeInsidePortal) {
            this.entityPos = this.portalPos;
        } else {
            EnumFacing dirSide = this.portalAxis.func_176746_e();
            EnumFacing dirPortal = this.portalAxis;
            BlockPos posTmp = this.portalPos.func_177982_a(dirPortal.func_82601_c(), 0, dirPortal.func_82599_e());
            if (world.func_180495_p(posTmp).func_177230_c() != Blocks.field_150427_aO) {
                dirPortal = dirPortal.func_176734_d();
            }
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            int xOff = dirSide.func_82601_c();
            int zOff = dirSide.func_82599_e();
            list.add(this.portalPos.func_177982_a(xOff, -1, zOff));
            list.add(this.portalPos.func_177982_a(xOff, -2, zOff));
            list.add(this.portalPos.func_177982_a(xOff + dirPortal.func_82601_c(), -1, zOff + dirPortal.func_82599_e()));
            list.add(this.portalPos.func_177982_a(xOff + dirPortal.func_82601_c(), -2, zOff + dirPortal.func_82599_e()));
            list.add(this.portalPos.func_177982_a(-xOff, -1, -zOff));
            list.add(this.portalPos.func_177982_a(-xOff, -2, -zOff));
            list.add(this.portalPos.func_177982_a(-xOff + dirPortal.func_82601_c(), -1, -zOff + dirPortal.func_82599_e()));
            list.add(this.portalPos.func_177982_a(-xOff + dirPortal.func_82601_c(), -2, -zOff + dirPortal.func_82599_e()));
            for (BlockPos pos : list) {
                if (!world.isSideSolid(pos, EnumFacing.UP) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 1)) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) continue;
                this.entityPos = pos.func_177984_a();
                return;
            }
            for (BlockPos pos : list) {
                if (!world.func_175623_d(pos) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 1)) || !world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) continue;
                world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 3);
                this.entityPos = pos.func_177984_a();
                return;
            }
            this.entityPos = this.portalPos.func_177982_a(dirSide.func_82601_c(), 0, dirSide.func_82599_e());
        }
    }
}

