/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities;

import fi.dy.masa.enderutilities.gui.EnderUtilitiesGUIHandler;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.proxy.IProxy;
import fi.dy.masa.enderutilities.setup.ConfigReader;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.ModRegistry;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="enderutilities", name="Ender Utilities", version="0.6.5", guiFactory="fi.dy.masa.enderutilities.setup.EnderUtilitiesGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/enderutilities/master/update.json", acceptedMinecraftVersions="1.10.2")
public class EnderUtilities {
    @Mod.Instance(value="enderutilities")
    public static EnderUtilities instance;
    @SidedProxy(clientSide="fi.dy.masa.enderutilities.proxy.ClientProxy", serverSide="fi.dy.masa.enderutilities.proxy.CommonProxy")
    public static IProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        logger = event.getModLog();
        ConfigReader.loadConfigsAll(event.getSuggestedConfigurationFile());
        EnderUtilitiesItems.init();
        EnderUtilitiesBlocks.init();
        PacketHandler.init();
        proxy.registerModels();
        proxy.registerEntities();
        proxy.registerTileEntities();
        proxy.registerKeyBindings();
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        proxy.registerSounds();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new EnderUtilitiesGUIHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerColorHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Registry.registerEnderbagLists();
        Registry.registerTeleportBlacklist();
        ModRegistry.checkLoadedMods();
    }

    @Mod.EventHandler
    public void onServerStartingEvent(FMLServerStartingEvent event) {
        ChunkLoading.getInstance().init();
        EnergyBridgeTracker.readFromDisk();
    }

    @Mod.EventHandler
    public void onMissingMappingEvent(FMLMissingMappingsEvent event) {
        List list = event.get();
        for (FMLMissingMappingsEvent.MissingMapping mapping : list) {
            ResourceLocation newLoc;
            ResourceLocation oldLoc;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                oldLoc = mapping.resourceLocation;
                newLoc = new ResourceLocation(oldLoc.func_110624_b(), oldLoc.func_110623_a().replaceAll("\\.", "_"));
                logger.info(String.format("Re-mapping block '%s' to '%s'", oldLoc, newLoc));
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(newLoc);
                if (block == null) continue;
                mapping.remap(block);
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            oldLoc = mapping.resourceLocation;
            newLoc = new ResourceLocation(oldLoc.func_110624_b(), oldLoc.func_110623_a().replaceAll("\\.", "_"));
            logger.info(String.format("Re-mapping item '%s' to '%s'", oldLoc, newLoc));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(newLoc);
            if (item == null) continue;
            mapping.remap(item);
        }
    }
}

