/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity.base;

import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityThrowableEU
extends EntityThrowable {
    public int blockX;
    public int blockY;
    public int blockZ;
    public Block inBlock;
    public UUID throwerUUID;
    public int field_70194_h;
    public int field_70195_i;

    public EntityThrowableEU(World world) {
        super(world);
    }

    public EntityThrowableEU(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setThrower(entity);
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.func_70030_z();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.field_174854_a) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.blockX, this.blockY, this.blockZ)).func_177230_c() == this.inBlock) {
                if (++this.field_70194_h >= 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.field_174854_a = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70194_h = 0;
            this.field_70195_i = 0;
        } else {
            ++this.field_70195_i;
        }
        Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTraceImpact = this.field_70170_p.func_72933_a(currentPos, nextPos);
        if (rayTraceImpact != null) {
            nextPos = new Vec3d(rayTraceImpact.field_72307_f.field_72450_a, rayTraceImpact.field_72307_f.field_72448_b, rayTraceImpact.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase thrower = this.func_85052_h();
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double distance = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                double distanceTmp;
                Entity entityIter = (Entity)list.get(j);
                if (!entityIter.func_70067_L() || thrower != null && EntityUtils.doesEntityStackContainEntity(entityIter, (Entity)thrower)) continue;
                double s = 0.1;
                AxisAlignedBB axisalignedbb = entityIter.func_174813_aQ().func_72314_b(s, s, s);
                RayTraceResult rayTraceResult1 = axisalignedbb.func_72327_a(currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), nextPos);
                if (rayTraceResult1 == null || !((distanceTmp = currentPos.func_72438_d(rayTraceResult1.field_72307_f)) < distance) && distance != 0.0) continue;
                entity = entityIter;
                distance = distanceTmp;
            }
            if (entity != null) {
                rayTraceImpact = new RayTraceResult(entity);
            }
        }
        if (rayTraceImpact != null) {
            if (rayTraceImpact.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(rayTraceImpact.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(rayTraceImpact.func_178782_a());
            } else if (rayTraceImpact.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(rayTraceImpact.func_178782_a()).func_177230_c() == Blocks.field_150321_G) {
                this.func_70110_aj();
            } else {
                this.func_70184_a(rayTraceImpact);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float motionFactor = 0.99f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            motionFactor = 0.8f;
        } else if (this.field_70134_J) {
            this.field_70134_J = false;
            this.field_70159_w *= 0.3;
            this.field_70181_x *= 0.3;
            this.field_70179_y *= 0.3;
        }
        this.field_70159_w *= (double)motionFactor;
        this.field_70181_x *= (double)motionFactor;
        this.field_70179_y *= (double)motionFactor;
        this.field_70181_x -= (double)this.func_70185_h();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.blockX);
        nbt.func_74777_a("yTile", (short)this.blockY);
        nbt.func_74777_a("zTile", (short)this.blockZ);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inBlock));
        nbt.func_74774_a("shake", (byte)this.field_70191_b);
        nbt.func_74774_a("inGround", (byte)(this.field_174854_a ? 1 : 0));
        if (this.throwerUUID != null) {
            nbt.func_74772_a("ownerUUIDM", this.throwerUUID.getMostSignificantBits());
            nbt.func_74772_a("ownerUUIDL", this.throwerUUID.getLeastSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.blockX = nbt.func_74765_d("xTile");
        this.blockY = nbt.func_74765_d("yTile");
        this.blockZ = nbt.func_74765_d("zTile");
        this.inBlock = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        this.field_70191_b = nbt.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_174854_a = nbt.func_74771_c("inGround") == 1;
        if (nbt.func_150297_b("ownerUUIDM", 4) && nbt.func_150297_b("ownerUUIDL", 4)) {
            this.throwerUUID = new UUID(nbt.func_74763_f("ownerUUIDM"), nbt.func_74763_f("ownerUUIDL"));
        }
    }

    public void setThrower(EntityLivingBase entity) {
        this.throwerUUID = entity.func_110124_au();
    }

    public EntityLivingBase func_85052_h() {
        if (this.throwerUUID != null) {
            return this.field_70170_p.func_152378_a(this.throwerUUID);
        }
        return null;
    }
}

