/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.gui.client.GuiScreenBuilderWandTemplate;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageKeyPressed;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.Keybindings;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    public static final TIntIntHashMap KEY_CODE_MAPPINGS = new TIntIntHashMap(16);
    private final Minecraft mc = Minecraft.func_71410_x();
    private static int scrollingMask = 0;
    private static int modifierMask = 0;

    public static void resetModifiers() {
        scrollingMask = 0;
        modifierMask = 0;
    }

    public static boolean isHoldingKeyboundItem(EntityPlayer player) {
        return EntityUtils.isHoldingItemOfType((EntityLivingBase)player, IKeyBound.class);
    }

    public static boolean hasKeyBoundUnselectedItem(EntityPlayer player) {
        return InventoryUtils.getFirstItemOfType(player, IKeyBoundUnselected.class) != null;
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        int eventKey = Keyboard.getEventKey();
        boolean keyState = Keyboard.getEventKeyState();
        if (KEY_CODE_MAPPINGS.containsKey(eventKey)) {
            int mask = KEY_CODE_MAPPINGS.get(eventKey);
            if (keyState) {
                modifierMask |= mask;
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
                    scrollingMask |= mask;
                }
            } else {
                modifierMask &= ~mask;
                scrollingMask &= ~mask;
            }
        }
        if (FMLClientHandler.instance().getClient().field_71415_G) {
            BlockPos pos;
            IBlockState state;
            if (eventKey == Keybindings.keyToggleMode.func_151463_i() && keyState) {
                if (this.buildersWandClientSideHandling()) {
                    return;
                }
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player) || InputEventHandler.hasKeyBoundUnselectedItem((EntityPlayer)player)) {
                    int keyCode = 1 | modifierMask;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(keyCode));
                }
            } else if (eventKey == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
                boolean shouldOpen = keyState && player.func_70093_af() == Configs.handyBagOpenRequiresSneak;
                GuiEventHandler.instance().setHandyBagShouldOpen(shouldOpen);
            } else if (eventKey == 1) {
                GuiEventHandler.instance().setHandyBagShouldOpen(false);
            }
            if (keyState && (eventKey == this.mc.field_71474_y.field_74314_A.func_151463_i() || eventKey == this.mc.field_71474_y.field_74311_E.func_151463_i()) && (state = player.field_70170_p.func_180495_p((pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177977_b())).func_177230_c() == EnderUtilitiesBlocks.blockElevator) {
                int key = eventKey == this.mc.field_71474_y.field_74314_A.func_151463_i() ? 0x2000000 : 0x1000000;
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        int dWheel = event.getDwheel();
        if (dWheel != 0) {
            EntityPlayerSP player;
            dWheel /= 120;
            if (scrollingMask != 0 && InputEventHandler.isHoldingKeyboundItem((EntityPlayer)(player = FMLClientHandler.instance().getClientPlayerEntity()))) {
                int key = 0x1000 | scrollingMask;
                if (dWheel > 0) {
                    key |= 0x100000;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
            }
        }
    }

    private boolean buildersWandClientSideHandling() {
        if (GuiScreen.func_146272_n() || GuiScreen.func_146271_m() || GuiScreen.func_175283_s()) {
            return false;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.buildersWand && ItemBuildersWand.Mode.getMode(stack) == ItemBuildersWand.Mode.COPY) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBuilderWandTemplate());
            return true;
        }
        return false;
    }

    static {
        KEY_CODE_MAPPINGS.put(42, 65536);
        KEY_CODE_MAPPINGS.put(54, 65536);
        KEY_CODE_MAPPINGS.put(29, 131072);
        KEY_CODE_MAPPINGS.put(157, 131072);
        KEY_CODE_MAPPINGS.put(56, 262144);
        KEY_CODE_MAPPINGS.put(184, 262144);
    }
}

