/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class TaskBuildersWand
implements IPlayerTask {
    protected final int dimension;
    protected final UUID wandUUID;
    protected final List<BlockPosStateDist> positions;
    protected final int blocksPerTick;
    protected int listIndex;
    protected int placedCount;
    protected int failCount;

    public TaskBuildersWand(World world, UUID wandUUID, List<BlockPosStateDist> positions, int blocksPerTick) {
        this.dimension = world.field_73011_w.getDimension();
        this.wandUUID = wandUUID;
        this.positions = positions;
        this.blocksPerTick = blocksPerTick;
        this.listIndex = 0;
        this.placedCount = 0;
        this.failCount = 0;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.buildersWand);
        if (stack != null && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            int i = 0;
            while (i < this.blocksPerTick && this.listIndex < this.positions.size()) {
                if (wand.placeBlockToPosition(stack, world, player, this.positions.get(this.listIndex))) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++i;
                }
                ++this.listIndex;
            }
            if (this.listIndex >= this.positions.size()) {
                ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
                BlockPosEU pos = wand.getPosition(stack, true);
                if (pos != null && mode != ItemBuildersWand.Mode.WALLS && mode != ItemBuildersWand.Mode.CUBE && wand.getMovePosition(stack, mode)) {
                    wand.setPosition(stack, pos.offset(pos.side, 1), true);
                }
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 0.4f, 1.0f);
                return true;
            }
        } else {
            ++this.failCount;
        }
        return this.failCount > 200;
    }

    @Override
    public void stop() {
        this.positions.clear();
    }
}

