/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.TemplateEnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class TaskTemplatePlaceBlocks
implements IPlayerTask {
    protected final TemplateEnderUtilities template;
    protected final BlockPos posStart;
    protected final UUID playerUUID;
    protected final UUID wandUUID;
    protected final int dimension;
    protected final int blocksPerTick;
    protected final boolean tileEntities;
    protected final boolean entities;
    protected int listIndex;
    protected int placedCount;
    protected int failCount;

    public TaskTemplatePlaceBlocks(TemplateEnderUtilities template, BlockPos posStart, int dimension, UUID playerUUID, UUID wandUUID, int blocksPerTick, boolean copyTileEntities, boolean placeEntities) {
        this.template = template;
        this.posStart = posStart;
        this.playerUUID = playerUUID;
        this.wandUUID = wandUUID;
        this.dimension = dimension;
        this.blocksPerTick = blocksPerTick;
        this.tileEntities = copyTileEntities;
        this.entities = placeEntities;
        this.listIndex = 0;
        this.placedCount = 0;
        this.failCount = 0;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.buildersWand);
        if (stack != null && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            PlacementSettings placement = this.template.getPlacementSettings();
            int i = 0;
            while (i < this.blocksPerTick && this.listIndex < this.template.getBlockList().size()) {
                TemplateEnderUtilities.TemplateBlockInfo blockInfo = this.template.getBlockList().get(this.listIndex);
                IBlockState state = blockInfo.blockState.func_185902_a(placement.func_186212_b()).func_185907_a(placement.func_186215_c());
                BlockPos pos = TemplateEnderUtilities.transformedBlockPos(placement, blockInfo.pos).func_177971_a((Vec3i)this.posStart);
                if (wand.placeBlockToPosition(stack, world, player, pos, EnumFacing.UP, state, 2, true, true)) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++i;
                }
                ++this.listIndex;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        if (this.listIndex >= this.template.getBlockList().size()) {
            this.template.addEntitiesToWorld(world, this.posStart);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
    }
}

