/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.inventory.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.ContainerTileEntityInventory;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncCustomSlot;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerMemoryChest
extends ContainerTileEntityInventory
implements ICustomSlotSync {
    protected TileEntityMemoryChest temc;
    protected List<ItemStack> templateStacksLast;
    protected long templateMask;

    public ContainerMemoryChest(EntityPlayer player, TileEntityMemoryChest te) {
        super(player, te);
        this.temc = te;
        this.templateStacksLast = new ArrayList<ItemStack>();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, ((Slot)this.field_75151_b.get((int)(this.field_75151_b.size() - 1))).field_75221_f + 32);
    }

    @Override
    protected void addCustomInventorySlots() {
        int customInvStart = this.field_75151_b.size();
        int posX = 8;
        int posY = 26;
        int tier = this.temc.getStorageTier();
        int rows = TileEntityMemoryChest.INV_SIZES[tier] / 9;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        this.customInventorySlots = new MergeSlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
    }

    @Override
    protected boolean transferStackToPrioritySlots(EntityPlayer player, int slotNum, boolean reverse) {
        boolean ret = false;
        long mask = this.temc.getTemplateMask();
        long bit = 1L;
        int i = 0;
        while (i < this.field_75151_b.size()) {
            if ((mask & bit) != 0L) {
                ret |= this.transferStackToSlotRange(player, slotNum, new MergeSlotRange(i, 1), reverse);
            }
            ++i;
            bit <<= 1;
        }
        return ret;
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (clickType == ClickType.CLONE && dragType == 2 && slotNum >= 0 && slotNum < this.inventory.getSlots()) {
            int invSlotNum;
            int n = invSlotNum = this.func_75139_a(slotNum) != null ? this.func_75139_a(slotNum).getSlotIndex() : -1;
            if (invSlotNum != -1) {
                ItemStack stackSlot = this.inventory.getStackInSlot(invSlotNum);
                ItemStack stackCursor = this.player.field_71071_by.func_70445_o();
                if (stackCursor != null && stackSlot == null && (this.temc.getTemplateMask() & (long)(1 << invSlotNum)) == 0L) {
                    this.temc.setTemplateStack(invSlotNum, stackCursor);
                } else {
                    this.temc.setTemplateStack(invSlotNum, stackSlot);
                }
                this.temc.toggleTemplateMask(invSlotNum);
            }
            return null;
        }
        ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
        this.func_75142_b();
        return stack;
    }

    public TileEntityMemoryChest getTileEntity() {
        return this.temc;
    }

    protected Slot func_75146_a(Slot slot) {
        this.templateStacksLast.add(null);
        return super.func_75146_a(slot);
    }

    @Override
    public void putCustomStack(int typeId, int slotNum, ItemStack stack) {
        this.temc.setTemplateStack(slotNum, stack);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.temc.func_145831_w().field_72995_K) {
            return;
        }
        for (int i = 0; i < this.templateStacksLast.size(); ++i) {
            ItemStack currentStack = this.temc.getTemplateStack(i);
            ItemStack prevStack = this.templateStacksLast.get(i);
            if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)currentStack)) continue;
            prevStack = currentStack != null ? currentStack.func_77946_l() : null;
            this.templateStacksLast.set(i, prevStack);
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
                if (!(listener instanceof EntityPlayerMP)) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncCustomSlot(this.field_75152_c, 0, i, prevStack), (EntityPlayerMP)listener);
            }
        }
        long mask = this.temc.getTemplateMask();
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            if (this.templateMask == mask) continue;
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
            listener.func_71112_a((Container)this, 0, (int)(mask & 0xFFFFL));
            listener.func_71112_a((Container)this, 1, (int)(mask >> 16 & 0xFFFFL));
            listener.func_71112_a((Container)this, 2, (int)(mask >> 32 & 0xFFFFL));
            listener.func_71112_a((Container)this, 3, (int)(mask >> 48 & 0xFFFFL));
        }
        this.templateMask = mask;
    }

    public void func_75137_b(int var, int val) {
        if (var >= 0 && var <= 3) {
            this.templateMask &= 65535L << var * 16 ^ 0xFFFFFFFFFFFFFFFFL;
            this.templateMask |= (long)val << var * 16;
            this.temc.setTemplateMask(this.templateMask);
        }
    }
}

