/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.item;

import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventoryItemPermissions
extends InventoryItem {
    protected UUID accessorUUID;

    public InventoryItemPermissions(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, player, "Items");
    }

    public InventoryItemPermissions(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player, String tagName) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, player, tagName, null, null);
    }

    public InventoryItemPermissions(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, EntityPlayer player, String tagName, UUID containerUUID, IItemHandler hostInv) {
        super(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, player, tagName, containerUUID, hostInv);
        if (player != null) {
            this.accessorUUID = player.func_110124_au();
        }
    }

    @Override
    public boolean isCurrentlyAccessible() {
        return this.isAccessibleBy(this.accessorUUID);
    }

    @Override
    public boolean isAccessibleByPlayer(EntityPlayer player) {
        return OwnerData.canAccessItem(this.getContainerItemStack(), (Entity)player);
    }

    @Override
    public boolean isAccessibleBy(UUID uuid) {
        return OwnerData.canAccessItem(this.getContainerItemStack(), uuid);
    }
}

