/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionHelper;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLivingManipulator
extends ItemModular
implements IKeyBound {
    public static final int MAX_ENTITIES_PER_CARD = 16;
    public static final String WRAPPER_TAG_NAME = "LivingManipulator";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_POS = "Position";

    public ItemLivingManipulator() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("livingmanipulator");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.NORMAL || mode == Mode.RELEASE) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            return this.releaseEntity(stack, world, pos, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ, side);
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult handleInteraction(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase) {
        if (player.field_70170_p.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.RELEASE) {
            return this.releaseEntity(stack, player.field_70170_p, livingBase.func_180425_c(), livingBase.field_70165_t, livingBase.field_70163_u, livingBase.field_70161_v, EnumFacing.UP);
        }
        return this.captureEntity(stack, player, livingBase);
    }

    public EnumActionResult captureEntity(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase) {
        if (livingBase == null || livingBase instanceof EntityPlayer || !livingBase.func_184222_aU()) {
            return EnumActionResult.PASS;
        }
        int count = this.getStoredEntityCount(stack);
        if (count < 16) {
            return this.storeEntity(stack, livingBase);
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.memorycard.full", new Object[0]));
        return EnumActionResult.FAIL;
    }

    public EnumActionResult releaseEntity(ItemStack containerStack, World world, BlockPos pos, double x, double y, double z, EnumFacing side) {
        NBTTagCompound tag;
        int numEntities;
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return EnumActionResult.PASS;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
        if (tagList == null || tagList.func_74745_c() == 0) {
            return EnumActionResult.PASS;
        }
        int current = NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current");
        if (current >= (numEntities = tagList.func_74745_c())) {
            int n = current = numEntities > 0 ? numEntities - 1 : 0;
        }
        if ((tag = tagList.func_150305_b(current)) != null) {
            Entity entity;
            boolean isShulker = false;
            if (tag.func_74779_i("id").equals("Shulker") && tag.func_150297_b("APX", 3)) {
                int xi = pos.func_177958_n() + side.func_82601_c();
                int yi = pos.func_177956_o() + side.func_96559_d();
                int zi = pos.func_177952_p() + side.func_82599_e();
                tag.func_74782_a("Pos", (NBTBase)NBTUtils.writeDoubles((double)xi + 0.5, yi, (double)zi + 0.5));
                tag.func_74768_a("APX", xi);
                tag.func_74768_a("APY", yi);
                tag.func_74768_a("APZ", zi);
                System.out.printf("side: %s - %d\n", side, side.func_176745_a());
                tag.func_74774_a("AttachFace", (byte)side.func_176745_a());
                isShulker = true;
            }
            if ((entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)world)) == null) {
                return EnumActionResult.FAIL;
            }
            if (!isShulker) {
                PositionHelper posHelper = new PositionHelper(x, y, z);
                posHelper.adjustPositionToTouchFace(entity, side);
                entity.func_70012_b(posHelper.posX, posHelper.posY, posHelper.posZ, entity.field_70177_z, entity.field_70125_A);
            }
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.field_70122_E = true;
            if (entity instanceof EntityLiving && this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                EntityUtils.applyMobPersistence((EntityLiving)entity);
            }
            world.func_72838_d(entity);
            tagList.func_74744_a(current);
        }
        if (current >= (numEntities = tagList.func_74745_c())) {
            current = numEntities > 0 ? numEntities - 1 : 0;
        }
        NBTUtils.setByte(moduleStack, WRAPPER_TAG_NAME, "Current", (byte)current);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult storeEntity(ItemStack containerStack, EntityLivingBase livingBase) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return EnumActionResult.PASS;
        }
        livingBase.func_184210_p();
        livingBase.func_184226_ay();
        NBTTagCompound nbtEntity = new NBTTagCompound();
        if (!livingBase.func_70039_c(nbtEntity)) {
            return EnumActionResult.FAIL;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, true);
        tagList = NBTUtils.insertToTagList(tagList, (NBTBase)nbtEntity, NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current"));
        NBTUtils.setTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", tagList);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        livingBase.field_70128_L = true;
        return EnumActionResult.SUCCESS;
    }

    public int getStoredEntityCount(ItemStack containerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return 0;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
        return tagList != null ? tagList.func_74745_c() : 0;
    }

    public int getCurrentIndex(ItemStack containerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return 0;
        }
        return NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current");
    }

    public void setCurrentIndex(ItemStack containerStack, byte index) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return;
        }
        NBTUtils.setByte(moduleStack, WRAPPER_TAG_NAME, "Current", index);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
    }

    public String getEntityName(ItemStack containerStack, int index) {
        NBTTagCompound tag;
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return null;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
        if (tagList != null && tagList.func_74745_c() > index && (tag = tagList.func_150305_b(index)) != null) {
            String pre = TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString();
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            String name = tag.func_74779_i("CustomName");
            if (tag.func_150297_b("id", 8)) {
                String translated;
                String id = tag.func_74779_i("id");
                if (!id.equals(translated = I18n.func_135052_a((String)("entity." + id + ".name"), (Object[])new Object[0]))) {
                    id = translated;
                }
                name = name.length() > 0 ? pre + name + rst + " (" + id + ")" : id;
            }
            return name;
        }
        return null;
    }

    public void changeEntitySelection(ItemStack containerStack, boolean reverse) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack == null) {
            return;
        }
        int numEntities = this.getStoredEntityCount(containerStack);
        int current = this.getCurrentIndex(containerStack);
        if (reverse) {
            if (--current < 0) {
                current = numEntities > 0 ? numEntities - 1 : 0;
            }
        } else if (++current >= numEntities) {
            current = 0;
        }
        NBTUtils.setByte(moduleStack, WRAPPER_TAG_NAME, "Current", (byte)current);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
    }

    public String func_77653_i(ItemStack stack) {
        String str = super.func_77653_i(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String preGreenIta = preGreen + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack != null) {
            if (str.length() >= 14) {
                str = EUStringUtils.getInitialsWithDots(str);
            }
            str = moduleStack.func_82837_s() ? str + " " + preGreenIta + moduleStack.func_82833_r() + rst : str + " MC: " + preGreen + (UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1) + rst;
            int index = this.getCurrentIndex(stack);
            int count = this.getStoredEntityCount(stack);
            str = str + " E: " + preGreen + (index + 1) + "/" + count + rst;
            String entity = this.getEntityName(stack, index);
            if (entity != null) {
                str = str + " -> " + entity;
            }
        }
        return str;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        ItemStack memoryCardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + Mode.getMode(stack).getDisplayName() + rst);
        if (verbose && this.getMaxModules(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
            String s = this.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0 ? I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
            list.add(s);
        }
        if (memoryCardStack != null) {
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1;
                String dName = memoryCardStack.func_82837_s() ? preWhiteIta + memoryCardStack.func_82833_r() + rst + " " : "";
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
                NBTTagList tagList = NBTUtils.getTagList(memoryCardStack, WRAPPER_TAG_NAME, "Entities", 10, false);
                if (tagList == null) {
                    return;
                }
                int current = this.getCurrentIndex(stack);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    if (tag == null) continue;
                    String pre = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
                    String name = tag.func_74779_i("CustomName");
                    if (tag.func_150297_b("id", 8)) {
                        String translated;
                        String id = tag.func_74779_i("id");
                        if (!id.equals(translated = I18n.func_135052_a((String)("entity." + id + ".name"), (Object[])new Object[0]))) {
                            id = translated;
                        }
                        name = name.length() > 0 ? pre + name + rst + " (" + id + ")" : id;
                    }
                    name = i == current ? "-> " + name : "   " + name;
                    list.add(name);
                }
            }
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nomemorycards", (Object[])new Object[0]));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            this.changeEntitySelection(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            NBTUtils.cycleByteValue(stack, WRAPPER_TAG_NAME, TAG_NAME_MODE, Mode.values().length - 1);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC)) {
            return 4;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        return this.getMaxModules(containerStack, ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "mode=normal"), new ModelResourceLocation(rl, "mode=capture"), new ModelResourceLocation(rl, "mode=release")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "mode=" + Mode.getMode(stack).getVariant());
    }

    public static enum Mode {
        NORMAL("enderutilities.tooltip.item.normal", "normal"),
        CAPTURE("enderutilities.tooltip.item.capture", "capture"),
        RELEASE("enderutilities.tooltip.item.release", "release");

        private String unlocName;
        private String variant;

        private Mode(String unlocName, String variant) {
            this.unlocName = unlocName;
            this.variant = variant;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocName, (Object[])new Object[0]);
        }

        public String getVariant() {
            return this.variant;
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.getMode(NBTUtils.getByte(stack, ItemLivingManipulator.WRAPPER_TAG_NAME, ItemLivingManipulator.TAG_NAME_MODE));
        }

        public static Mode getMode(int id) {
            return id >= 0 && id < Mode.values().length ? Mode.values()[id] : NORMAL;
        }
    }
}

