/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderUtilities
extends Item {
    public String name;

    public ItemEnderUtilities() {
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.addItemOverrides();
    }

    public Item func_77655_b(String name) {
        this.name = name;
        return super.func_77655_b(ReferenceNames.getPrefixedName(name));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.equals(newStack);
    }

    public String getBaseItemDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("display");
            return TextFormatting.ITALIC.toString() + tag.func_74779_i("Name") + TextFormatting.RESET.toString();
        }
        return super.func_77653_i(stack);
    }

    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 2) {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshiftfordescription", (Object[])new Object[0]));
            } else {
                list.addAll(tmpList);
            }
        }
        tmpList.clear();
        this.addInformationSelective(stack, player, tmpList, advancedTooltips, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addInformationSelective(stack, player, tmpList, advancedTooltips, false);
            if (tmpList.size() > 0) {
                list.add(tmpList.get(0));
            }
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshift", (Object[])new Object[0]));
        } else {
            list.addAll(tmpList);
        }
    }

    public static void addTooltips(String key, List<String> list, boolean verbose) {
        String translated = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (!translated.equals(key)) {
            if (translated.contains("|lf")) {
                String[] lines;
                for (String line : lines = translated.split(Pattern.quote("|lf"))) {
                    list.add(line);
                }
            } else {
                list.add(translated);
            }
        }
    }

    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this)};
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return null;
    }

    protected void addItemOverrides() {
    }
}

