/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.part;

import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderCapacitor
extends ItemEnderUtilities
implements IChargeable,
IModule {
    public static final int CHARGE_RATE_FROM_ENERGY_BRIDGE = 100;

    public ItemEnderCapacitor() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("endercapacitor");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return super.func_77658_a() + "_" + stack.func_77960_j();
        }
        return super.func_77658_a();
    }

    public int getCapacityFromItemType(ItemStack stack) {
        int dmg = stack.func_77960_j();
        if (dmg == 0) {
            return 10000;
        }
        if (dmg == 1) {
            return 100000;
        }
        if (dmg == 2) {
            return 500000;
        }
        if (dmg == 3) {
            return 1000000000;
        }
        return 10000;
    }

    private int getCapacity(ItemStack stack, NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("EnderChargeCapacity", 3)) {
            return this.getCapacityFromItemType(stack);
        }
        return nbt.func_74762_e("EnderChargeCapacity");
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return this.getCapacity(stack, stack.func_77978_p());
    }

    @Override
    public void setCapacity(ItemStack stack, int capacity) {
        NBTUtils.setInteger(stack, null, "EnderChargeCapacity", capacity);
    }

    private int getCharge(NBTTagCompound nbt) {
        return nbt.func_74762_e("EnderChargeAmount");
    }

    @Override
    public int getCharge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null ? this.getCharge(nbt) : 0;
    }

    private void setCharge(NBTTagCompound nbt, int value) {
        nbt.func_74768_a("EnderChargeAmount", value);
    }

    @Override
    public int addCharge(ItemStack stack, int amount, boolean doCharge) {
        if (stack.func_77960_j() == 3) {
            return amount;
        }
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, true);
        int charge = this.getCharge(nbt);
        int capacity = this.getCapacity(stack, nbt);
        if (capacity - charge < amount) {
            amount = capacity - charge;
        }
        if (doCharge) {
            this.setCharge(nbt, charge + amount);
        }
        return amount;
    }

    @Override
    public int useCharge(ItemStack stack, int amount, boolean doUse) {
        if (stack.func_77960_j() == 3 && this.getCharge(stack) > 0) {
            return amount;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || amount < 0) {
            return 0;
        }
        int charge = this.getCharge(nbt);
        if (charge < amount) {
            amount = charge;
        }
        if (doUse) {
            this.setCharge(nbt, charge - amount);
        }
        return amount;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        int charge = this.getCharge(stack);
        int capacity = this.getCapacity(stack);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.charge", (Object[])new Object[0]) + ": " + EUStringUtils.formatNumberWithKSeparators(charge) + " / " + EUStringUtils.formatNumberWithKSeparators(capacity));
    }

    @Override
    public ItemModule.ModuleType getModuleType(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return ItemModule.ModuleType.TYPE_ENDERCAPACITOR;
        }
        return ItemModule.ModuleType.TYPE_INVALID;
    }

    @Override
    public int getModuleTier(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return stack.func_77960_j();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
            ItemStack tmp = new ItemStack((Item)this, 1, i);
            tmp.func_77982_d(new NBTTagCompound());
            this.setCharge(tmp.func_77978_p(), this.getCapacityFromItemType(tmp));
            list.add(tmp);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "tex=empty_0"), new ModelResourceLocation(rl, "tex=empty_1"), new ModelResourceLocation(rl, "tex=empty_2"), new ModelResourceLocation(rl, "tex=empty_3"), new ModelResourceLocation(rl, "tex=charged_0"), new ModelResourceLocation(rl, "tex=charged_1"), new ModelResourceLocation(rl, "tex=charged_2"), new ModelResourceLocation(rl, "tex=charged_3")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String pre = this.getCharge(stack) > 0 ? "tex=charged_" : "tex=empty_";
        int index = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)3);
        return new ModelResourceLocation("enderutilities:item_" + this.name, pre + index);
    }
}

