/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.IStringInput;
import fi.dy.masa.enderutilities.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSendString
implements IMessage {
    private Type type;
    private String text;

    public MessageSendString() {
    }

    public MessageSendString(Type type, String text) {
        this.type = type;
        this.text = text;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readByte() % Type.values().length];
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public static enum Type {
        ITEM,
        BLOCK;

    }

    public static class Handler
    implements IMessageHandler<MessageSendString, IMessage> {
        public IMessage onMessage(final MessageSendString message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageSendString: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("Sending player was null in MessageSendString");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageSendString");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageSendString message, EntityPlayer player) {
            if (message.type == Type.ITEM) {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IStringInput.class);
                if (stack != null) {
                    ((IStringInput)stack.func_77973_b()).handleString(player, stack, message.text);
                }
            } else if (player.field_71070_bA instanceof IStringInput) {
                ((IStringInput)player.field_71070_bA).handleString(player, null, message.text);
            }
        }
    }
}

