/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiQuickStackerAdvanced;
import fi.dy.masa.enderutilities.inventory.IItemHandlerModifiableProvider;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.ItemHandlerModifiableMuxer;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerQuickStackerAdvanced;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCallback;
import fi.dy.masa.enderutilities.item.ItemQuickStacker;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.BlockPosDistance;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityQuickStackerAdvanced
extends TileEntityEnderUtilitiesInventory
implements IModularInventoryHolder,
IItemHandlerModifiableProvider {
    public static final int NUM_TARGET_INVENTORIES = 9;
    public static final int GUI_ACTION_TOGGLE_TARGET_TYPE = 0;
    public static final int GUI_ACTION_TOGGLE_COLUMNS = 1;
    public static final int GUI_ACTION_TOGGLE_ROWS = 2;
    public static final int GUI_ACTION_TOGGLE_TARGET_ENABLED = 3;
    public static final int GUI_ACTION_SET_ACTIVE_TARGET = 4;
    public static final int GUI_ACTION_TOGGLE_FILTER_SETTINGS = 5;
    public static final int BIT_ENABLED = 1;
    public static final int BIT_WHITELIST = 2;
    public static final int BIT_META = 4;
    public static final int BIT_NBT = 8;
    private final ItemStackHandlerTileEntity inventoryFiltersAreaMode;
    private InventoryItemCallback inventoryFiltersBound;
    private InventoryItem inventoryFiltersBoundTemp;
    private final FilterSettings filtersAreaMode;
    private FilterSettings filtersBound;
    private boolean isAreaMode;
    private short enabledTargetsMask;
    private byte selectedTarget;
    private long slotMask;
    protected final Map<UUID, Long> clickTimes;

    public TileEntityQuickStackerAdvanced() {
        super("quickstackeradvanced");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 18, 1, false, "Items", this);
        this.inventoryFiltersAreaMode = new ItemStackHandlerTileEntity(1, 36, 1, false, "FilterItems", this);
        this.inventoryFiltersBound = new InventoryItemCallback(null, 36, 1, false, false, null, this, "FilterItems");
        this.inventoryFiltersBoundTemp = new InventoryItem(null, 36, 1, false, false, null, "FilterItems");
        this.filtersAreaMode = new FilterSettings(this.inventoryFiltersAreaMode);
        this.filtersBound = new FilterSettings(this.inventoryFiltersBound);
        this.clickTimes = new HashMap<UUID, Long>();
    }

    private void initStorage() {
        this.inventoryFiltersBound.setIsRemote(this.func_145831_w().field_72995_K);
        this.readFilterSettingsFromModule(this.getContainerStack());
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.getBaseItemHandler(), new ItemHandlerWrapperQuickStackerAdvanced((IItemHandler)this.getBaseItemHandler()));
    }

    public IItemHandler getFilterInventory() {
        return new ItemHandlerModifiableMuxer(this);
    }

    @Override
    public IItemHandler getInventory() {
        return this.getInventoryModifiable();
    }

    @Override
    public IItemHandlerModifiable getInventoryModifiable() {
        if (this.isAreaMode()) {
            return this.inventoryFiltersAreaMode;
        }
        return this.inventoryFiltersBound;
    }

    public FilterSettings getSelectedFilterSettings() {
        if (this.isAreaMode()) {
            return this.filtersAreaMode;
        }
        return this.filtersBound;
    }

    public FilterSettings getFilterSettings(int filterId) {
        if (this.isAreaMode()) {
            return this.filtersAreaMode;
        }
        ItemStack container = this.getContainerStack(filterId);
        NBTTagCompound nbt = null;
        if (container != null) {
            nbt = NBTUtils.getCompoundTag(container, "AdvancedQuickStacker", false);
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        FilterSettings filter = new FilterSettings(this.inventoryFiltersBoundTemp);
        this.inventoryFiltersBoundTemp.setContainerItemStack(container);
        filter.deserializeNBT(nbt);
        return filter;
    }

    @Override
    public ItemStack getContainerStack() {
        return this.getContainerStack(this.selectedTarget);
    }

    public ItemStack getContainerStack(int filterId) {
        if (filterId < 9) {
            return this.getBaseItemHandler().getStackInSlot(filterId + 9);
        }
        return null;
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.isAreaMode || this.inventoryFiltersBound.isAccessibleByPlayer(player);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        this.readFilterSettingsFromModule(this.getContainerStack());
        this.func_70296_d();
    }

    public boolean isAreaMode() {
        return this.isAreaMode;
    }

    public void setIsAreaMode(boolean isAreaMode) {
        this.isAreaMode = isAreaMode;
    }

    public byte getAreaModeSettings() {
        return this.filtersAreaMode.getAsBitMask();
    }

    public void setAreaModeSettings(byte mask) {
        this.filtersAreaMode.setFromBitMask(mask);
    }

    public short getEnabledTargetsMask() {
        return this.enabledTargetsMask;
    }

    public void setEnabledTargetsMask(short enabledTargetsMask) {
        this.enabledTargetsMask = enabledTargetsMask;
    }

    public byte getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setSelectedTarget(byte selectedTarget) {
        this.selectedTarget = selectedTarget;
        this.readFilterSettingsFromModule(this.getContainerStack());
    }

    public long getEnabledSlotsMask() {
        return this.slotMask;
    }

    public void setEnabledSlotsMask(long mask) {
        this.slotMask = mask;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.isAreaMode = nbt.func_74767_n("AreaMode");
        this.enabledTargetsMask = nbt.func_74771_c("EnabledTargets");
        this.selectedTarget = nbt.func_74771_c("SelectedTarget");
        this.slotMask = nbt.func_74763_f("EnabledSlots");
        this.filtersAreaMode.deserializeNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("AreaMode", this.isAreaMode());
        nbt.func_74774_a("EnabledTargets", (byte)this.enabledTargetsMask);
        nbt.func_74774_a("SelectedTarget", this.selectedTarget);
        nbt.func_74772_a("EnabledSlots", this.slotMask);
        nbt.func_179237_a(this.filtersAreaMode.serializeNBT());
        return nbt;
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        super.readItemsFromNBT(nbt);
        this.inventoryFiltersAreaMode.deserializeNBT(nbt);
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        super.writeItemsToNBT(nbt);
        nbt.func_179237_a(this.inventoryFiltersAreaMode.serializeNBT());
    }

    private void readFilterSettingsFromModule(ItemStack container) {
        if (!this.isAreaMode()) {
            NBTTagCompound nbt = null;
            if (container != null) {
                nbt = NBTUtils.getCompoundTag(container, "AdvancedQuickStacker", false);
            }
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            this.inventoryFiltersBound.setContainerItemStack(container);
            this.filtersBound.deserializeNBT(nbt);
        }
    }

    public void onLoad() {
        this.initStorage();
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Long last = this.clickTimes.get(player.func_110124_au());
            if (last != null && this.field_145850_b.func_82737_E() - last < 8L) {
                if (this.isAreaMode()) {
                    TileEntityQuickStackerAdvanced.quickStackToInventories(this.func_145831_w(), player, this.slotMask, PositionUtils.getTileEntityPositions(this.func_145831_w(), this.func_174877_v(), 16, 16, 16), this.getSelectedFilterSettings());
                } else {
                    this.quickStackToTargetInventories(player);
                }
                this.clickTimes.remove(player.func_110124_au());
            } else {
                this.clickTimes.put(player.func_110124_au(), this.field_145850_b.func_82737_E());
            }
        }
    }

    protected void quickStackToTargetInventories(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        boolean movedSome = false;
        int bit = 1;
        for (int slot = 0; slot < 9; ++slot) {
            IItemHandler externalInv;
            TileEntity te;
            TargetData target;
            ItemStack lcStack;
            if ((this.enabledTargetsMask & bit) != 0 && (lcStack = this.getBaseItemHandler().getStackInSlot(slot)) != null && (target = TargetData.getTargetFromItem(lcStack)) != null && this.func_145831_w().func_175668_a(target.pos, true) && target.dimension == this.func_145831_w().field_73011_w.getDimension() && PositionUtils.isWithinRange(target.pos, this.func_174877_v(), 32, 32, 32) && target.isTargetBlockUnchanged() && (te = this.func_145831_w().func_175625_s(target.pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing) && (externalInv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing)) != null) {
                FilterSettings filter = this.getFilterSettings(slot);
                ItemQuickStacker.Result result = TileEntityQuickStackerAdvanced.quickStackItems(playerInv, externalInv, this.slotMask, !player.func_70093_af(), filter);
                if (result != ItemQuickStacker.Result.MOVED_NONE) {
                    Effects.spawnParticlesFromServer(player.field_70170_p.field_73011_w.getDimension(), target.pos, EnumParticleTypes.VILLAGER_HAPPY);
                    movedSome = true;
                }
            }
            bit <<= 1;
        }
        if (movedSome) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.5f, 1.8f);
        }
    }

    public static ItemQuickStacker.Result quickStackItems(IItemHandler playerInv, IItemHandler externalInv, long slotMask, boolean matchingOnly, FilterSettings filter) {
        ItemQuickStacker.Result ret = ItemQuickStacker.Result.MOVED_NONE;
        boolean movedAll = true;
        long bit = 1L;
        for (int slotPlayer = 0; slotPlayer < playerInv.getSlots(); ++slotPlayer) {
            ItemStack stack = playerInv.getStackInSlot(slotPlayer);
            if ((slotMask & bit) != 0L && stack != null && (filter == null || filter.itemAllowedByFilter(stack))) {
                stack = playerInv.extractItem(slotPlayer, 64, false);
                if (stack == null) continue;
                if (!matchingOnly || InventoryUtils.getSlotOfLastMatchingItemStack(externalInv, stack) != -1) {
                    int sizeOrig = stack.field_77994_a;
                    stack = InventoryUtils.tryInsertItemStackToInventory(externalInv, stack);
                    if (ret == ItemQuickStacker.Result.MOVED_NONE && (stack == null || stack.field_77994_a != sizeOrig)) {
                        ret = ItemQuickStacker.Result.MOVED_SOME;
                    }
                }
                if (stack != null) {
                    playerInv.insertItem(slotPlayer, stack, false);
                    movedAll = false;
                }
            }
            bit <<= 1;
        }
        if (movedAll && ret == ItemQuickStacker.Result.MOVED_SOME) {
            ret = ItemQuickStacker.Result.MOVED_ALL;
        }
        return ret;
    }

    public static void quickStackToInventories(World world, EntityPlayer player, long enabledSlotsMask, List<BlockPosDistance> positions) {
        TileEntityQuickStackerAdvanced.quickStackToInventories(world, player, enabledSlotsMask, positions, null);
    }

    public static void quickStackToInventories(World world, EntityPlayer player, long enabledSlotsMask, List<BlockPosDistance> positions, FilterSettings filter) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        boolean movedSome = false;
        for (BlockPosDistance posDist : positions) {
            IItemHandler inv;
            TileEntity te = world.func_175625_s(posDist.pos);
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) || (inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) == null) continue;
            ItemQuickStacker.Result result = TileEntityQuickStackerAdvanced.quickStackItems(playerInv, inv, enabledSlotsMask, !player.func_70093_af(), filter);
            if (result != ItemQuickStacker.Result.MOVED_NONE) {
                Effects.spawnParticlesFromServer(world.field_73011_w.getDimension(), posDist.pos, EnumParticleTypes.VILLAGER_HAPPY);
                movedSome = true;
            }
            if (result != ItemQuickStacker.Result.MOVED_ALL) continue;
            break;
        }
        if (movedSome) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.5f, 1.8f);
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 4) {
            if (element >= 0 && element < 9) {
                this.inventoryFiltersBound.onContentsChanged(element);
                this.setSelectedTarget((byte)element);
            }
        } else if (action == 3) {
            this.enabledTargetsMask = (short)(this.enabledTargetsMask ^ 1 << element);
        } else if (action == 0) {
            this.isAreaMode = !this.isAreaMode;
        } else if (action == 2) {
            if (element >= 0 && element <= 3) {
                this.slotMask ^= 511L << element * 9;
            }
        } else if (action == 1) {
            if (element >= 0 && element < 9) {
                this.slotMask ^= 134480385L << element;
            }
        } else if (action == 5) {
            this.toggleFilterSettings(element);
        }
    }

    private void toggleFilterSettings(int element) {
        ItemStack container;
        FilterSettings filter = this.getSelectedFilterSettings();
        switch (element) {
            case 0: {
                filter.toggleIsEnabled();
                break;
            }
            case 1: {
                filter.toggleIsBlacklist();
                break;
            }
            case 2: {
                filter.toggleMatchMeta();
                break;
            }
            case 3: {
                filter.toggleMatchNBT();
            }
        }
        if (!this.isAreaMode() && (container = this.getContainerStack()) != null) {
            NBTTagCompound nbt = NBTUtils.getCompoundTag(container, "AdvancedQuickStacker", true);
            nbt.func_179237_a(filter.serializeNBT());
        }
    }

    @Override
    public ContainerQuickStackerAdvanced getContainer(EntityPlayer player) {
        return new ContainerQuickStackerAdvanced(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiQuickStackerAdvanced(this.getContainer(player), this);
    }

    public class FilterSettings
    implements INBTSerializable<NBTTagCompound> {
        private final ItemStackHandlerBasic filterInventory;
        private boolean enabled = true;
        private boolean isBlacklist;
        private boolean matchMeta = true;
        private boolean matchNBT;

        private FilterSettings(ItemStackHandlerBasic filterInventory) {
            this.filterInventory = filterInventory;
        }

        public IItemHandlerModifiable getFilterInventory() {
            return this.filterInventory;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isBlacklist() {
            return this.isBlacklist;
        }

        public boolean getMatchMeta() {
            return this.matchMeta;
        }

        public boolean getMatchNBT() {
            return this.matchNBT;
        }

        public void toggleIsEnabled() {
            this.enabled = !this.enabled;
        }

        public void toggleIsBlacklist() {
            this.isBlacklist = !this.isBlacklist;
        }

        public void toggleMatchMeta() {
            this.matchMeta = !this.matchMeta;
        }

        public void toggleMatchNBT() {
            this.matchNBT = !this.matchNBT;
        }

        public boolean itemAllowedByFilter(ItemStack stack) {
            if (!this.enabled) {
                return true;
            }
            if (InventoryUtils.matchingStackFoundInSlotRange((IItemHandler)this.filterInventory, new SlotRange((IItemHandler)this.filterInventory), stack, !this.matchMeta, !this.matchNBT)) {
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }

        public byte getAsBitMask() {
            byte mask = 0;
            if (this.isEnabled()) {
                mask = (byte)(mask | 1);
            }
            if (this.isBlacklist()) {
                mask = (byte)(mask | 2);
            }
            if (this.getMatchMeta()) {
                mask = (byte)(mask | 4);
            }
            if (this.getMatchNBT()) {
                mask = (byte)(mask | 8);
            }
            return mask;
        }

        public void setFromBitMask(byte mask) {
            this.enabled = (mask & 1) != 0;
            this.isBlacklist = (mask & 2) != 0;
            this.matchMeta = (mask & 4) != 0;
            this.matchNBT = (mask & 8) != 0;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = nbt.func_74775_l("FilterSettings");
            this.enabled = !tag.func_74767_n("Ignored");
            this.isBlacklist = tag.func_74767_n("IsBlacklist");
            this.matchMeta = !tag.func_74767_n("IgnoreMeta");
            this.matchNBT = tag.func_74767_n("MatchNBT");
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("Ignored", !this.enabled);
            tag.func_74757_a("IsBlacklist", this.isBlacklist);
            tag.func_74757_a("IgnoreMeta", !this.matchMeta);
            tag.func_74757_a("MatchNBT", this.matchNBT);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("FilterSettings", (NBTBase)tag);
            return nbt;
        }

        public String toString() {
            return String.format("Filter{enabled=%s,isBlacklist:%s,matchMeta=%s,matchNBT=%s}\n", this.enabled, this.isBlacklist, this.matchMeta, this.matchNBT);
        }
    }

    private class ItemHandlerWrapperQuickStackerAdvanced
    extends ItemHandlerWrapperSelective {
        public ItemHandlerWrapperQuickStackerAdvanced(IItemHandler baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return true;
            }
            if (slot < 9) {
                return stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((IModule)stack.func_77973_b()).getModuleTier(stack) == 1;
            }
            return stack.func_77973_b() == EnderUtilitiesItems.enderPart && ((IModule)stack.func_77973_b()).getModuleType(stack) == ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC;
        }
    }
}

