/*
 * Decompiled with CFR 0.152.
 */
package com.kodehawa.ce.event;

import com.kodehawa.ce.event.Event;
import com.kodehawa.ce.event.Listener;
import com.kodehawa.ce.event.events.EventAlert;
import com.kodehawa.ce.event.events.EventBlockClick;
import com.kodehawa.ce.event.events.EventBlockRender;
import com.kodehawa.ce.event.events.EventKey;
import com.kodehawa.ce.event.events.EventMouseClick;
import com.kodehawa.ce.event.events.EventMouseDrag;
import com.kodehawa.ce.event.events.EventRender3D;
import com.kodehawa.ce.event.events.EventSwing;
import com.kodehawa.ce.event.events.EventTick;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventHandler {
    private HashMap<Class<? extends Event>, CopyOnWriteArrayList<Listener>> eventMap = new HashMap();
    private static volatile EventHandler instance;

    public EventHandler() {
        this.eventMap.put(EventAlert.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventKey.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventRender3D.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventBlockClick.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventBlockRender.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventMouseClick.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventSwing.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventMouseDrag.class, new CopyOnWriteArrayList());
        this.eventMap.put(EventTick.class, new CopyOnWriteArrayList());
    }

    public void registerListener(Class<? extends Event> c, Listener m) {
        List l;
        if (this.eventMap.containsKey(c) && !(l = (List)this.eventMap.get(c)).contains(m)) {
            l.add(m);
        }
    }

    public void unRegisterListener(Class<? extends Event> c, Listener m) {
        List l;
        if (this.eventMap.containsKey(c) && (l = (List)this.eventMap.get(c)).contains(m)) {
            l.remove(m);
        }
    }

    public Event call(Event e) {
        if (this.eventMap.containsKey(e.getClass())) {
            List l = this.eventMap.get(e.getClass());
            for (Listener m : l) {
                try {
                    m.onEvent(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            System.out.println("Event not supported: " + e.toString() + ". Add event into eventMap.");
        }
        return e;
    }

    public static EventHandler getInstance() {
        if (instance == null) {
            instance = new EventHandler();
        }
        return instance;
    }
}

