/*
 * Decompiled with CFR 0.152.
 */
package com.kodehawa.ce.gui.api.components;

import com.kodehawa.ce.gui.api.components.Item;
import com.kodehawa.ce.gui.api.components.Value;
import com.kodehawa.ce.gui.api.render.ModGuiUtils;
import cpw.mods.fml.client.FMLClientHandler;
import java.text.DecimalFormat;

public class Slider
extends Item {
    private final Value sliderValue;
    private final int xPos;
    private final int yPos;
    private final float maxValue;
    private final float minValue;
    private boolean shouldRound;
    public boolean dragging;
    public float dragX;
    public float lastDragX;
    private final int drawSliderWidth;
    private final int sliderWidth;

    public void dragSlider(int x) {
        this.dragX = (float)x - this.lastDragX;
    }

    public Slider(Value value, int x, int y) {
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = 10.0f;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public Slider(Value value, int x, int y, float maxValue) {
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public Slider(Value value, int x, int y, float minValue, float maxValue, boolean shouldRound) {
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.drawSliderWidth = 85;
        this.shouldRound = shouldRound;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public void draw(int x) {
        if (this.dragging) {
            this.dragSlider(x);
        }
        if (this.dragX < 0.0f) {
            this.dragX = 0.0f;
        }
        if (this.dragX > (float)this.sliderWidth) {
            this.dragX = this.sliderWidth;
        }
        DecimalFormat format = new DecimalFormat(this.shouldRound ? "0" : "0.0");
        FMLClientHandler.instance().getClient().field_71466_p.func_78276_b(this.sliderValue.getName() + ": " + format.format(this.sliderValue.getValue()), this.xPos + this.parent.x, this.yPos - 3 + this.parent.y, 0xFFFFFF);
        ModGuiUtils.drawHLine(this.xPos + this.parent.x, this.xPos + this.drawSliderWidth + this.parent.x, this.yPos + 12 + this.parent.y, -5592406);
        ModGuiUtils.drawHLine(this.xPos + this.parent.x, (float)this.xPos + this.dragX + (float)this.parent.x, this.yPos + 12 + this.parent.y, -2236963);
        ModGuiUtils.drawGBRect(this.xPos + this.parent.x + (int)this.dragX, this.yPos + 9 + this.parent.y, this.xPos + 6 + this.parent.x + (int)this.dragX, (float)this.yPos + 15.5f + (float)this.parent.y, 0.5f, -11184811, -8947849, -11184811);
        float fraction = (float)this.sliderWidth / (this.maxValue - this.minValue);
        this.sliderValue.setValue(this.sliderValue.getName().equals("Step") ? this.dragX / fraction + this.minValue + 0.1f : (this.shouldRound ? (float)((int)(this.dragX / fraction)) + this.minValue : this.dragX / fraction + this.minValue));
    }

    public float getValue() {
        return Float.parseFloat(new DecimalFormat("0.0").format(this.sliderValue.getValue()));
    }

    public void setValue(float value) {
        float fraction = 80.0f / (this.maxValue - this.minValue);
        this.sliderValue.setValue(value -= this.minValue);
        this.dragX = fraction * value;
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0 && (float)x >= (float)(this.xPos + this.parent.x) + this.dragX && y >= this.yPos + 9 + this.parent.y && (float)x <= (float)(this.xPos + 6 + this.parent.x) + this.dragX && (float)y <= (float)this.yPos + 15.5f + (float)this.parent.y) {
            this.lastDragX = (float)x - this.dragX;
            this.dragging = true;
        }
    }

    public void mouseMovedOrUp(int x, int y, int b) {
        if (b == 0) {
            this.dragging = false;
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public void drag(int x, int y) {
    }

    @Override
    public void onClick(int x, int y) {
    }

    @Override
    public boolean mouseOver(int x, int y) {
        return false;
    }
}

