/*
 * Decompiled with CFR 0.152.
 */
package com.kodehawa.ce.module.core;

import com.kodehawa.ce.event.Event;
import com.kodehawa.ce.event.EventHandler;
import com.kodehawa.ce.event.Listener;
import com.kodehawa.ce.event.events.EventKey;
import com.kodehawa.ce.event.events.EventRender3D;
import com.kodehawa.ce.event.events.EventTick;
import com.kodehawa.ce.forge.loader.CheatingEssentials;
import com.kodehawa.ce.module.enums.EnumGuiCategory;
import com.kodehawa.ce.module.handlers.ModuleManager;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class CheatingEssentialsModule
implements Listener {
    public EnumGuiCategory type;
    public int keybind;
    public int color;
    public String name;
    public String desc;
    public String credits;
    public String version;
    private boolean active;
    private boolean tick;
    private boolean enabled;
    private boolean ortho;
    private boolean forgeEvent;
    private final LinkedList<Class<? extends CheatingEssentialsModule>> incompat = new LinkedList();

    public CheatingEssentialsModule(String name, String desc, int key) {
        this(name, desc, "1.6.2", key, EnumGuiCategory.UTILS, true);
    }

    public CheatingEssentialsModule(String name, String desc, EnumGuiCategory type) {
        this(name, desc, "1.6.2", 0, type, true);
    }

    public CheatingEssentialsModule(String name, String desc, EnumGuiCategory type, boolean enabled) {
        this(name, desc, "1.6.2", 0, type, enabled);
    }

    public CheatingEssentialsModule(String name, String desc, String version, int key, EnumGuiCategory type, boolean enabled) {
        this.name = name;
        this.desc = desc;
        this.keybind = key;
        this.type = type;
        this.enabled = enabled;
        this.version = version;
    }

    public void toggleModule() {
        try {
            boolean bl = this.active = !this.active;
            if (this.active) {
                this.onEnableModule();
                this.disableIncompat();
                ModuleManager.getInstance().enabledModules.add(this.name);
                if (this.getTick()) {
                    EventHandler.getInstance().registerListener(EventTick.class, this);
                }
                if (this.getType() == EnumGuiCategory.NONE) {
                    ModuleManager.getInstance().enabledModules.remove(this.name);
                }
                if (this.getEvent()) {
                    MinecraftForge.EVENT_BUS.register((Object)this);
                }
            } else {
                this.onDisableModule();
                ModuleManager.getInstance().enabledModules.remove(this.name);
                if (this.getTick()) {
                    EventHandler.getInstance().unRegisterListener(EventTick.class, this);
                }
            }
            if (this.isActive()) {
                if (this.getRender()) {
                    EventHandler.getInstance().registerListener(EventRender3D.class, this);
                }
            } else if (this.getRender()) {
                EventHandler.getInstance().unRegisterListener(EventRender3D.class, this);
            } else if (this.getEvent()) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public int getKeybinding() {
        return this.keybind;
    }

    public void setKeybinding(Integer key) {
        this.keybind = key;
    }

    public void setActive(boolean state) {
        this.enabled = state;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getMCVersion() {
        return this.version;
    }

    public EnumGuiCategory getType() {
        return this.type;
    }

    public boolean getRender() {
        return this.ortho;
    }

    public boolean getEvent() {
        return this.forgeEvent;
    }

    public boolean getTick() {
        return this.tick;
    }

    public void setTick(boolean state) {
        this.tick = state;
    }

    public void setRender(boolean state) {
        this.ortho = state;
    }

    public void setForgeEvent(boolean state) {
        this.forgeEvent = state;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    @Override
    public void onEvent(Event e) {
        if (e instanceof EventKey && ((EventKey)e).getKey() == this.getKeybinding()) {
            this.toggleModule();
        }
        if (this.getRender() && e instanceof EventRender3D) {
            this.onRenderInModule();
        }
        if (this.getTick() && e instanceof EventTick) {
            this.tick();
        }
    }

    protected static EntityClientPlayerMP getPlayer() {
        return CheatingEssentialsModule.getMinecraft().field_71439_g;
    }

    protected static Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    protected static World getWorld() {
        return CheatingEssentialsModule.getMinecraft().field_71441_e;
    }

    protected static List<TileEntity> getTileEntitiesInWorld() {
        return CheatingEssentialsModule.getWorld().field_73009_h;
    }

    protected static List<EntityPlayer> getPlayersInWorld() {
        return CheatingEssentialsModule.getWorld().field_73010_i;
    }

    protected static void displayGuiScreen(GuiScreen e) {
        CheatingEssentialsModule.getMinecraft().func_71373_a(e);
    }

    protected static void sendPacket(Packet packet) {
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    protected static void sendChatMessage(String message) {
        CheatingEssentialsModule.sendPacket((Packet)new Packet3Chat(message));
    }

    protected static double getDistanceToEntity(Entity e) {
        return CheatingEssentialsModule.getPlayer().func_70032_d(e);
    }

    protected static double getDistanceSqToEntity(Entity e) {
        return CheatingEssentialsModule.getPlayer().func_70068_e(e);
    }

    protected static List<Entity> getLoadedEntities() {
        return CheatingEssentialsModule.getWorld().field_72996_f;
    }

    protected static PlayerControllerMP getPlayerController() {
        return CheatingEssentialsModule.getMinecraft().field_71442_b;
    }

    protected static boolean getCanEntityBeSeen(Entity e) {
        return CheatingEssentialsModule.getPlayer().func_70685_l(e);
    }

    protected void setFly(boolean state) {
        CheatingEssentialsModule.getMinecraft().field_71439_g.field_71075_bZ.field_75101_c = state;
        CheatingEssentialsModule.getMinecraft().field_71439_g.func_71016_p();
    }

    protected static List<Entity> getEntitiesInRange(double range) {
        LinkedList<Entity> list = new LinkedList<Entity>();
        for (Entity e : CheatingEssentialsModule.getLoadedEntities()) {
            if (!(CheatingEssentialsModule.getDistanceToEntity(e) <= range) || !(e instanceof EntityLiving)) continue;
            list.add(e);
        }
        return list;
    }

    protected void incompat(Class<? extends CheatingEssentialsModule> module) {
        this.incompat.add(module);
    }

    private void disableIncompat() {
        for (Class clazz : this.incompat) {
            this.disableIncompat(clazz);
        }
    }

    public void disableIncompat(Class<? extends CheatingEssentialsModule> module) {
        CheatingEssentialsModule incompat = ModuleManager.getInstance().getModuleByClass(module);
        if (!incompat.isActive()) {
            return;
        }
        if (CheatingEssentialsModule.getWorld() != null && CheatingEssentialsModule.getMinecraft() != null && CheatingEssentialsModule.getPlayer() != null) {
            CheatingEssentials.instance().log("Disabling " + incompat.getName() + " because it is incompatible with " + this.getName());
        }
        incompat.toggleModule();
    }

    public void onEnableModule() {
    }

    public void onDisableModule() {
    }

    public void onRenderInModule() {
    }

    public void tick() {
    }
}

