/*
 * Decompiled with CFR 0.152.
 */
package com.kodehawa.ce.reflect;

import com.kodehawa.ce.forge.loader.CheatingEssentials;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;

public class ReflectionHelper {
    public static Object getPrivateValue(Class class1, Object obj, String s) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field field = class1.getDeclaredField(s);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getPrivateMethod(Class class1, Object obj, String s) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException {
        try {
            Method[] methods = class1.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(s)) continue;
                ReflectionHelper.getPrivateMethod(class1, obj, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object getPrivateMethod(Class class1, Object o, int num) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException {
        try {
            Method m = class1.getDeclaredMethods()[num];
            m.setAccessible(true);
            return m.invoke(o, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class[] getClassesInPackage(String cPackage) {
        ArrayList classes = new ArrayList();
        URL pResource = Thread.currentThread().getContextClassLoader().getResource(cPackage.replace(".", "/").trim());
        if (pResource == null) {
            return classes.toArray(new Class[classes.size()]);
        }
        File pDirectory = new File(pResource.getFile());
        if (pDirectory != null) {
            for (String name : pDirectory.list()) {
                if (!name.endsWith(".class")) continue;
                String cName = cPackage + "." + name;
                try {
                    classes.add(Class.forName(cName.replace(".class", "")));
                }
                catch (ClassNotFoundException cException) {
                    CheatingEssentials.instance().log("Can't load module classes");
                    cException.printStackTrace();
                }
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Field findFieldOfTypeInClass(Class source, Class type) {
        for (Field e : source.getDeclaredFields()) {
            if (!e.getType().equals(type)) continue;
            return e;
        }
        return null;
    }

    public static Method findMethodOfTypeInClass(Class source, Class type) {
        for (Method m : source.getDeclaredMethods()) {
            if (!m.getTypeParameters().equals(type)) continue;
            return m;
        }
        return null;
    }

    public static void setField(Class c, Object o, String str, Object val) {
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(str)) continue;
            CheatingEssentials.instance().log("Fix Reflection Usage: Use \"" + i + "\" instead of \"" + str + "\"!");
            ReflectionHelper.setField(c, o, i, val);
            return;
        }
        CheatingEssentials.instance().log("Fix Reflection Usage: No such field: \"" + str + "\"!");
    }

    public static void setField(Class c, Object o, int num, Object val) {
        try {
            Field f = c.getDeclaredFields()[num];
            f.setAccessible(true);
            Field modifiers = f.getClass().getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(o, val);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

