/*
 * Decompiled with CFR 0.152.
 */
package com.reeszrbteam.ce.gui.click.elements;

import com.reeszrbteam.ce.gui.click.elements.YAWWindow;
import com.reeszrbteam.ce.util.CEUtils;
import com.reeszrbteam.ce.util.Value;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;

public class YAWSlider {
    private YAWWindow window;
    private Value sliderValue;
    private int xPos;
    private int yPos;
    private float maxValue;
    private float minValue;
    private boolean shouldRound;
    public boolean dragging;
    public float dragX;
    public float lastDragX;
    private int drawSliderWidth;
    private int sliderWidth;

    public void dragSlider(int x) {
        this.dragX = (float)x - this.lastDragX;
    }

    public YAWSlider(YAWWindow window, Value value, int x, int y) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = 10.0f;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public YAWSlider(YAWWindow window, Value value, int x, int y, float maxValue) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = 0.0f;
        this.drawSliderWidth = 85;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public YAWSlider(YAWWindow window, Value value, int x, int y, float minValue, float maxValue, boolean shouldRound) {
        this.window = window;
        this.sliderValue = value;
        this.xPos = x;
        this.yPos = y;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.drawSliderWidth = 85;
        this.shouldRound = shouldRound;
        this.sliderWidth = this.drawSliderWidth - 5;
    }

    public void draw(int x) {
        if (this.dragging) {
            this.dragSlider(x);
        }
        if (this.dragX < 0.0f) {
            this.dragX = 0.0f;
        }
        if (this.dragX > (float)this.sliderWidth) {
            this.dragX = this.sliderWidth;
        }
        DecimalFormat format = new DecimalFormat(this.shouldRound ? "0" : "0.0");
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.sliderValue.getName() + ": " + format.format(this.sliderValue.getValue()), this.xPos + this.window.dragX, this.yPos + this.window.dragY - 1, 0x55FFFF);
        CEUtils.drawBorderedRect((double)(this.xPos + this.window.dragX) - 0.8, (double)this.yPos + 8.2 + (double)this.window.dragY, (double)(this.xPos + this.drawSliderWidth + this.window.dragX) + 1.8, (double)this.yPos + 16.2 + (double)this.window.dragY, 1.0f, -16777216, -5592406);
        CEUtils.drawBorderedRect((double)(this.xPos + this.window.dragX) - 0.8, (double)this.yPos + 8.2 + (double)this.window.dragY, (float)this.xPos + this.dragX + (float)this.window.dragX, (double)this.yPos + 16.2 + (double)this.window.dragY, 1.0f, -16777216, -13487361);
        CEUtils.drawGradientBorderedRect(this.xPos + this.window.dragX + (int)this.dragX, this.yPos + 9 + this.window.dragY, this.xPos + 6 + this.window.dragX + (int)this.dragX, (float)this.yPos + 15.5f + (float)this.window.dragY, 0.5f, -11184811, -8947849, -11184811);
        float fraction = (float)this.sliderWidth / (this.maxValue - this.minValue);
        this.sliderValue.setValue(this.sliderValue.getName().equals("Step") ? this.dragX / fraction + this.minValue + 0.1f : (this.shouldRound ? (float)((int)(this.dragX / fraction)) + this.minValue : this.dragX / fraction + this.minValue));
    }

    public float getValue() {
        return Float.parseFloat(new DecimalFormat("0.0").format(this.sliderValue.getValue()));
    }

    public void setValue(float value) {
        float fraction = 80.0f / (this.maxValue - this.minValue);
        this.sliderValue.setValue(value -= this.minValue);
        this.dragX = fraction * value;
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0 && (float)x >= (float)(this.xPos + this.window.dragX) + this.dragX && y >= this.yPos + 9 + this.window.dragY && (float)x <= (float)(this.xPos + 6 + this.window.dragX) + this.dragX && (float)y <= (float)this.yPos + 15.5f + (float)this.window.dragY) {
            this.lastDragX = (float)x - this.dragX;
            this.dragging = true;
        }
    }

    public void mouseMovedOrUp(int x, int y, int b) {
        if (b == 0) {
            this.dragging = false;
        }
    }
}

