/*
 * Decompiled with CFR 0.152.
 */
package com.reptiles.common;

import com.reptiles.common.CommonProxyReptiles;
import com.reptiles.common.EntityChameleon;
import com.reptiles.common.EntityCroc;
import com.reptiles.common.EntityDesertTortoise;
import com.reptiles.common.EntityGator;
import com.reptiles.common.EntityGriseus;
import com.reptiles.common.EntityIguana;
import com.reptiles.common.EntityKomodo;
import com.reptiles.common.EntityLace;
import com.reptiles.common.EntityLargeCroc;
import com.reptiles.common.EntityLittleTurtle;
import com.reptiles.common.EntityMegalania;
import com.reptiles.common.EntityPerentie;
import com.reptiles.common.EntitySalvadorii;
import com.reptiles.common.EntitySavanna;
import com.reptiles.common.EntityTortoise;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="reptilemod", name="Reptile Mod", version="1.7.2")
public class Reptiles {
    public static final String modid = "reptilemod";
    public static final String name = "Reptile Mod";
    public static final String version = "1.7.2";
    @Mod.Instance(value="reptilemod")
    public static Reptiles instance;
    private int komodoSpawnProb;
    private int griseusSpawnProb;
    private int laceSpawnProb;
    private int perentieSpawnProb;
    private int savannaSpawnProb;
    private int crocSpawnProb;
    private int largeCrocSpawnProb;
    private int desertTortoiseSpawnProb;
    private int littleTurtleSpawnProb;
    private int iguanaSpawnProb;
    private int tortoiseSpawnProb;
    private int gatorSpawnProb;
    private int chameleonSpawnProb;
    private int crocMonitorSpawnProb;
    private int megalaniaSpawnProb;
    private boolean despawn;
    private boolean randomScale;
    private boolean followOwner;
    @SidedProxy(clientSide="com.reptiles.client.ClientProxyReptiles", serverSide="com.reptiles.common.CommonProxyReptiles")
    public static CommonProxyReptiles proxy;

    public String getVersion() {
        return version;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String comments = "Reptile Mod Config\n Michael Sheppard (crackedEgg)\n For Minecraft Version 1.7.2";
        String randomScaleComment = "Set to false to disable random scaling of monitors, default is true.";
        String despawnComment = "Set to false to not despawn. default is true.";
        String followOwnerComment = "Set to false to have tamed monitors not follow owner, default is true.";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        config.addCustomCategoryComment("Spawning", "Spawn Probabilities\nSet xxxSpawnProb to zero to disable spawning of that entity");
        config.addCustomCategoryComment("Misc", "Miscellaneous Variables");
        this.komodoSpawnProb = config.get("Spawning", "komodoSpawnProb", 10).getInt();
        this.griseusSpawnProb = config.get("Spawning", "griseusSpawnProb", 12).getInt();
        this.laceSpawnProb = config.get("Spawning", "laceSpawnProb", 12).getInt();
        this.perentieSpawnProb = config.get("Spawning", "perentieSpawnProb", 12).getInt();
        this.savannaSpawnProb = config.get("Spawning", "savannaSpawnProb", 12).getInt();
        this.crocSpawnProb = config.get("Spawning", "crocSpawnProb", 5).getInt();
        this.largeCrocSpawnProb = config.get("Spawning", "largeCrocSpawnProb", 4).getInt();
        this.desertTortoiseSpawnProb = config.get("Spawning", "desertTortoiseSpawnProb", 12).getInt();
        this.littleTurtleSpawnProb = config.get("Spawning", "littleTurtleSpawnProb", 10).getInt();
        this.iguanaSpawnProb = config.get("Spawning", "iguanaSpawnProb", 12).getInt();
        this.tortoiseSpawnProb = config.get("Spawning", "tortoiseSpawnProb", 12).getInt();
        this.gatorSpawnProb = config.get("Spawning", "gatorSpawnProb", 5).getInt();
        this.chameleonSpawnProb = config.get("Spawning", "chameleonSpawnProb", 12).getInt();
        this.crocMonitorSpawnProb = config.get("Spawning", "crocMonitorSpawnProb", 12).getInt();
        this.megalaniaSpawnProb = config.get("Spawning", "megalaniaSpawnProb", 12).getInt();
        this.randomScale = config.get("Misc", "randomScale", true, randomScaleComment).getBoolean(true);
        this.despawn = config.get("Misc", "despawn", true, despawnComment).getBoolean(true);
        this.followOwner = config.get("Misc", "followOwner", true, followOwnerComment).getBoolean(true);
        config.addCustomCategoryComment("Information", comments);
        config.save();
        proxy.registerRenderers();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        this.registerEntity(EntityKomodo.class, "Komodo", 25600, 10025880);
        this.registerEntity(EntitySavanna.class, "Savanna", 0x8B8989, 13485503);
        this.registerEntity(EntityGriseus.class, "Griseus", 13468991, 14596231);
        this.registerEntity(EntityPerentie.class, "Perentie", 0x363636, 0x7F7F7F);
        this.registerEntity(EntityLace.class, "Lace", 657930, 0xABABAB);
        this.registerEntity(EntityCroc.class, "Croc", 35584, 10669402);
        this.registerEntity(EntityDesertTortoise.class, "DesertTortoise", 9127187, 9129017);
        this.registerEntity(EntityLittleTurtle.class, "LittleTurtle", 16744228, 16747625);
        this.registerEntity(EntityLargeCroc.class, "LargeCroc", 9127187, 9132587);
        this.registerEntity(EntityIguana.class, "Iguana", 52480, 12648254);
        this.registerEntity(EntityTortoise.class, "Tortoise", 35653, 12648254);
        this.registerEntity(EntityGator.class, "Alligator", 35653, 12648254);
        this.registerEntity(EntityChameleon.class, "Chameleon", 0xB22222, 0x228B22);
        this.registerEntity(EntitySalvadorii.class, "CrocMonitor", 35788, 10669402);
        this.registerEntity(EntityMegalania.class, "Megalania", 328965, 378117);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.print("*** Checking for monitor biomes");
        BiomeGenBase[] monitorBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.PLAINS);
        proxy.print("*** Checking for tortoise biomes");
        BiomeGenBase[] tortoiseBiomes = this.getBiomes(BiomeDictionary.Type.DESERT, BiomeDictionary.Type.WASTELAND);
        proxy.print("*** Checking for turtle biomes");
        BiomeGenBase[] turtleBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SWAMP);
        proxy.print("*** Checking for lizard biomes");
        BiomeGenBase[] lizardBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN);
        proxy.print("*** Checking for crocodilian biomes");
        BiomeGenBase[] crocBiomes = this.getBiomes(BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MUSHROOM);
        this.addSpawn(EntityKomodo.class, this.komodoSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntitySavanna.class, this.savannaSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityGriseus.class, this.griseusSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityPerentie.class, this.perentieSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityLace.class, this.laceSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntitySalvadorii.class, this.crocMonitorSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityMegalania.class, this.megalaniaSpawnProb, 1, 2, monitorBiomes);
        this.addSpawn(EntityCroc.class, this.crocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityLargeCroc.class, this.largeCrocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityGator.class, this.gatorSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityDesertTortoise.class, this.desertTortoiseSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityLittleTurtle.class, this.littleTurtleSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityTortoise.class, this.tortoiseSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityIguana.class, this.iguanaSpawnProb, 1, 4, lizardBiomes);
        this.addSpawn(EntityChameleon.class, this.chameleonSpawnProb, 1, 4, lizardBiomes);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String entityName, int bkEggColor, int fgEggColor) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)id, (int)bkEggColor, (int)fgEggColor);
    }

    public void addSpawn(Class<? extends EntityLiving> entityClass, int spawnProb, int min, int max, BiomeGenBase[] biomes) {
        if (spawnProb > 0) {
            EntityRegistry.addSpawn(entityClass, (int)spawnProb, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])biomes);
        }
    }

    public BiomeGenBase[] getBiomes(BiomeDictionary.Type ... types) {
        LinkedList<BiomeGenBase> list = new LinkedList<BiomeGenBase>();
        for (BiomeDictionary.Type t : types) {
            BiomeGenBase[] biomes;
            for (BiomeGenBase bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t)) {
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || bgb.field_76750_F < 0.32f || BiomeDictionary.isBiomeOfType((BiomeGenBase)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || list.contains(bgb)) continue;
                list.add(bgb);
                proxy.print("  >>> Adding " + bgb.field_76791_y + " for spawning");
            }
        }
        return list.toArray(new BiomeGenBase[0]);
    }

    public boolean useRandomScaling() {
        return this.randomScale;
    }

    public boolean shouldDespawn() {
        return this.despawn;
    }

    public boolean getFollowOwner() {
        return this.followOwner;
    }
}

