/*
 * Decompiled with CFR 0.152.
 */
package reptiles.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.Configuration;
import reptiles.common.CommonProxyReptiles;
import reptiles.common.EntityChameleon;
import reptiles.common.EntityCroc;
import reptiles.common.EntityDesertTortoise;
import reptiles.common.EntityGator;
import reptiles.common.EntityGriseus;
import reptiles.common.EntityIguana;
import reptiles.common.EntityKomodo;
import reptiles.common.EntityLace;
import reptiles.common.EntityLargeCroc;
import reptiles.common.EntityLittleTurtle;
import reptiles.common.EntityMegalania;
import reptiles.common.EntityPerentie;
import reptiles.common.EntitySalvadorii;
import reptiles.common.EntitySavanna;
import reptiles.common.EntityTortoise;

@Mod(modid="ReptileMod", name="Reptile Mod", version="1.6.4")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, versionBounds="[1.6.4]")
public class Reptiles {
    @Mod.Instance
    public static Reptiles instance;
    public static final String modid = "ReptileMod";
    public static final String name = "Reptile Mod";
    public static final String version = "1.6.4";
    private int komodoSpawnProb;
    private int griseusSpawnProb;
    private int laceSpawnProb;
    private int perentieSpawnProb;
    private int savannaSpawnProb;
    private int crocSpawnProb;
    private int largeCrocSpawnProb;
    private int desertTortoiseSpawnProb;
    private int littleTurtleSpawnProb;
    private int iguanaSpawnProb;
    private int tortoiseSpawnProb;
    private int gatorSpawnProb;
    private int chameleonSpawnProb;
    private int crocMonitorSpawnProb;
    private int megalaniaSpawnProb;
    @SidedProxy(clientSide="reptiles.client.ClientProxyReptiles", serverSide="reptiles.common.CommonProxyReptiles")
    public static CommonProxyReptiles proxy;

    public String getVersion() {
        return version;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String comments = "Reptile Mod Config\n Michael Sheppard (crackedEgg)\nSet xxxSpawnProb to zero to disable spawn of that entity\n";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.komodoSpawnProb = config.get("general", "komodoSpawnProb", 10).getInt();
        this.griseusSpawnProb = config.get("general", "griseusSpawnProb", 12).getInt();
        this.laceSpawnProb = config.get("general", "laceSpawnProb", 12).getInt();
        this.perentieSpawnProb = config.get("general", "perentieSpawnProb", 12).getInt();
        this.savannaSpawnProb = config.get("general", "savannaSpawnProb", 12).getInt();
        this.crocSpawnProb = config.get("general", "crocSpawnProb", 5).getInt();
        this.largeCrocSpawnProb = config.get("general", "largeCrocSpawnProb", 4).getInt();
        this.desertTortoiseSpawnProb = config.get("general", "desertTortoiseSpawnProb", 12).getInt();
        this.littleTurtleSpawnProb = config.get("general", "littleTurtleSpawnProb", 10).getInt();
        this.iguanaSpawnProb = config.get("general", "iguanaSpawnProb", 12).getInt();
        this.tortoiseSpawnProb = config.get("general", "tortoiseSpawnProb", 12).getInt();
        this.gatorSpawnProb = config.get("general", "gatorSpawnProb", 5).getInt();
        this.chameleonSpawnProb = config.get("general", "chameleonSpawnProb", 12).getInt();
        this.crocMonitorSpawnProb = config.get("general", "crocMonitorSpawnProb", 12).getInt();
        this.megalaniaSpawnProb = config.get("general", "megalaniaSpawnProb", 12).getInt();
        config.addCustomCategoryComment("general", comments);
        config.save();
        proxy.registerRenderers();
        proxy.registerSounds();
        proxy.registerLogger();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        this.registerEntity(EntityKomodo.class, "Komodo", 25600, 10025880);
        this.registerEntity(EntitySavanna.class, "Savanna", 0x8B8989, 13485503);
        this.registerEntity(EntityGriseus.class, "Griseus", 13468991, 14596231);
        this.registerEntity(EntityPerentie.class, "Perentie", 0x363636, 0x7F7F7F);
        this.registerEntity(EntityLace.class, "Lace", 657930, 0xABABAB);
        this.registerEntity(EntityCroc.class, "Croc", 35584, 10669402);
        this.registerEntity(EntityDesertTortoise.class, "DesertTortoise", 9127187, 9129017);
        this.registerEntity(EntityLittleTurtle.class, "LittleTurtle", 16744228, 16747625);
        this.registerEntity(EntityLargeCroc.class, "LargeCroc", 9127187, 9132587);
        this.registerEntity(EntityIguana.class, "Iguana", 52480, 12648254);
        this.registerEntity(EntityTortoise.class, "Tortoise", 35653, 12648254);
        this.registerEntity(EntityGator.class, "Alligator", 35653, 12648254);
        this.registerEntity(EntityChameleon.class, "Chameleon", 0xB22222, 0x228B22);
        this.registerEntity(EntitySalvadorii.class, "CrocMonitor", 35788, 10669402);
        this.registerEntity(EntityMegalania.class, "Megalania", 328965, 378117);
        LanguageRegistry.instance().addStringLocalization("entity.Komodo.name", "Komodo");
        LanguageRegistry.instance().addStringLocalization("entity.Savanna.name", "Savanna");
        LanguageRegistry.instance().addStringLocalization("entity.Griseus.name", "Griseus");
        LanguageRegistry.instance().addStringLocalization("entity.Perentie.name", "Perentie");
        LanguageRegistry.instance().addStringLocalization("entity.Lace.name", "Lace");
        LanguageRegistry.instance().addStringLocalization("entity.Iguana.name", "Iguana");
        LanguageRegistry.instance().addStringLocalization("entity.Chameleon.name", "Chameleon");
        LanguageRegistry.instance().addStringLocalization("entity.Croc.name", "Crocodile");
        LanguageRegistry.instance().addStringLocalization("entity.DesertTortoise.name", "Desert Tortoise");
        LanguageRegistry.instance().addStringLocalization("entity.LittleTurtle.name", "Little Turtle");
        LanguageRegistry.instance().addStringLocalization("entity.LargeCroc.name", "Large Crocodile");
        LanguageRegistry.instance().addStringLocalization("entity.Alligator.name", "Alligator");
        LanguageRegistry.instance().addStringLocalization("entity.Tortoise.name", "Tortoise");
        LanguageRegistry.instance().addStringLocalization("entity.CrocMonitor.name", "Crocodile Monitor");
        LanguageRegistry.instance().addStringLocalization("entity.Megalania.name", "Megalania");
        proxy.print("*** Scanning for monitor biomes");
        BiomeGenBase[] monitorBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL);
        proxy.print("*** Scanning for tortoise biomes");
        BiomeGenBase[] tortoiseBiomes = this.getBiomes(BiomeDictionary.Type.DESERT, BiomeDictionary.Type.WASTELAND);
        proxy.print("*** Scanning for turtle biomes");
        BiomeGenBase[] turtleBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SWAMP);
        proxy.print("*** Scanning for lizard biomes");
        BiomeGenBase[] lizardBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN);
        proxy.print("*** Scanning for crocodilian biomes");
        BiomeGenBase[] crocBiomes = this.getBiomes(BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.MAGICAL);
        this.addSpawn(EntityKomodo.class, this.komodoSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntitySavanna.class, this.savannaSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityGriseus.class, this.griseusSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityPerentie.class, this.perentieSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityLace.class, this.laceSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntitySalvadorii.class, this.crocMonitorSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityMegalania.class, this.megalaniaSpawnProb, 1, 2, monitorBiomes);
        this.addSpawn(EntityCroc.class, this.crocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityLargeCroc.class, this.largeCrocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityGator.class, this.gatorSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityDesertTortoise.class, this.desertTortoiseSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityLittleTurtle.class, this.littleTurtleSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityTortoise.class, this.tortoiseSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityIguana.class, this.iguanaSpawnProb, 1, 4, lizardBiomes);
        this.addSpawn(EntityChameleon.class, this.chameleonSpawnProb, 1, 4, lizardBiomes);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomes();
    }

    public void registerEntity(Class<? extends Entity> entityClass, String entityName, int bkEggColor, int fgEggColor) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)id);
        EntityList.field_75627_a.put(id, new EntityEggInfo(id, bkEggColor, fgEggColor));
    }

    public void addSpawn(Class<? extends EntityLiving> entityClass, int spawnProb, int min, int max, BiomeGenBase[] biomes) {
        if (spawnProb > 0) {
            EntityRegistry.addSpawn(entityClass, (int)spawnProb, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])biomes);
        }
    }

    public BiomeGenBase[] getBiomes(BiomeDictionary.Type ... types) {
        LinkedList<BiomeGenBase> list = new LinkedList<BiomeGenBase>();
        for (BiomeDictionary.Type t : types) {
            BiomeGenBase[] biomes;
            for (BiomeGenBase bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t)) {
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || list.contains(bgb)) continue;
                list.add(bgb);
                proxy.print(" >>> Adding " + bgb.field_76791_y + " for spawning");
            }
        }
        return list.toArray(new BiomeGenBase[0]);
    }
}

