/*
 * Decompiled with CFR 0.152.
 */
package com.reptiles.common;

import com.reptiles.common.CommonProxyReptiles;
import com.reptiles.common.ConfigHandler;
import com.reptiles.common.EntityChameleon;
import com.reptiles.common.EntityCroc;
import com.reptiles.common.EntityDesertTortoise;
import com.reptiles.common.EntityGator;
import com.reptiles.common.EntityGriseus;
import com.reptiles.common.EntityIguana;
import com.reptiles.common.EntityKomodo;
import com.reptiles.common.EntityLace;
import com.reptiles.common.EntityLargeCroc;
import com.reptiles.common.EntityLittleTurtle;
import com.reptiles.common.EntityPerentie;
import com.reptiles.common.EntitySalvadorii;
import com.reptiles.common.EntitySavanna;
import com.reptiles.common.EntityTortoise;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="reptilemod", name="Reptile Mod", version="3.5.2", guiFactory="com.reptiles.client.ReptilesConfigGUIFactory", acceptedMinecraftVersions="[1.10.2]")
public class Reptiles {
    public static final String modid = "reptilemod";
    public static final String name = "Reptile Mod";
    public static final String version = "3.5.2";
    public static final String mcversion = "1.10.2";
    public static final String guifactory = "com.reptiles.client.ReptilesConfigGUIFactory";
    private static int entityID = 0;
    @Mod.Instance(value="reptilemod")
    public static Reptiles instance;
    @SidedProxy(clientSide="com.reptiles.client.ClientProxyReptiles", serverSide="com.reptiles.common.CommonProxyReptiles")
    public static CommonProxyReptiles proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.startConfig(event);
        this.registerEntity(EntityKomodo.class, "Komodo", 25600, 10025880);
        this.registerEntity(EntitySavanna.class, "Savanna", 0x8B8989, 13485503);
        this.registerEntity(EntityGriseus.class, "Griseus", 13468991, 14596231);
        this.registerEntity(EntityPerentie.class, "Perentie", 0x363636, 0x7F7F7F);
        this.registerEntity(EntityLace.class, "Lace", 657930, 0xABABAB);
        this.registerEntity(EntityCroc.class, "Croc", 35584, 10669402);
        this.registerEntity(EntityDesertTortoise.class, "DesertTortoise", 9127187, 9129017);
        this.registerEntity(EntityLittleTurtle.class, "LittleTurtle", 16744228, 16747625);
        this.registerEntity(EntityLargeCroc.class, "LargeCroc", 9127187, 9132587);
        this.registerEntity(EntityIguana.class, "Iguana", 52480, 12648254);
        this.registerEntity(EntityTortoise.class, "Tortoise", 35653, 12648254);
        this.registerEntity(EntityGator.class, "Alligator", 35653, 12648254);
        this.registerEntity(EntityChameleon.class, "Chameleon", 0xB22222, 0x228B22);
        this.registerEntity(EntitySalvadorii.class, "CrocMonitor", 35788, 10669402);
        proxy.registerSoundEvents();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.info("*** Checking for monitor biomes");
        Biome[] forestBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.PLAINS);
        proxy.info("*** Checking for tortoise biomes");
        Biome[] desertBiomes = this.getBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SANDY);
        proxy.info("*** Checking for turtle biomes");
        Biome[] jungleBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP);
        proxy.info("*** Checking for lizard biomes");
        Biome[] variousBiomes = this.getBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN);
        proxy.info("*** Checking for crocodilian biomes");
        Biome[] swampyBiomes = this.getBiomes(BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MUSHROOM);
        int minSpawn = ConfigHandler.getMinSpawn();
        int maxSpawn = ConfigHandler.getMaxSpawn();
        this.addSpawn(EntityKomodo.class, ConfigHandler.getKomodoSpawnProb(), minSpawn, maxSpawn, forestBiomes);
        this.addSpawn(EntitySavanna.class, ConfigHandler.getSavannaSpawnProb(), minSpawn, maxSpawn, forestBiomes);
        this.addSpawn(EntityGriseus.class, ConfigHandler.getGriseusSpawnProb(), minSpawn, maxSpawn, desertBiomes);
        this.addSpawn(EntityPerentie.class, ConfigHandler.getPerentieSpawnProb(), minSpawn, maxSpawn, forestBiomes);
        this.addSpawn(EntityLace.class, ConfigHandler.getLaceSpawnProb(), minSpawn, maxSpawn, forestBiomes);
        this.addSpawn(EntitySalvadorii.class, ConfigHandler.getCrocMonitorSpawnProb(), minSpawn, maxSpawn, forestBiomes);
        this.addSpawn(EntityCroc.class, ConfigHandler.getCrocSpawnProb(), minSpawn, maxSpawn, swampyBiomes);
        this.addSpawn(EntityLargeCroc.class, ConfigHandler.getLargeCrocSpawnProb(), minSpawn, maxSpawn, swampyBiomes);
        this.addSpawn(EntityGator.class, ConfigHandler.getGatorSpawnProb(), minSpawn, maxSpawn, swampyBiomes);
        this.addSpawn(EntityDesertTortoise.class, ConfigHandler.getDesertTortoiseSpawnProb(), minSpawn, maxSpawn, desertBiomes);
        this.addSpawn(EntityLittleTurtle.class, ConfigHandler.getLittleTurtleSpawnProb(), minSpawn, maxSpawn, jungleBiomes);
        this.addSpawn(EntityTortoise.class, ConfigHandler.getTortoiseSpawnProb(), minSpawn, maxSpawn, jungleBiomes);
        this.addSpawn(EntityIguana.class, ConfigHandler.getIguanaSpawnProb(), minSpawn, maxSpawn, variousBiomes);
        this.addSpawn(EntityChameleon.class, ConfigHandler.getChameleonSpawnProb(), minSpawn, maxSpawn, variousBiomes);
    }

    private void registerEntity(Class<? extends Entity> entityClass, String entityName, int bkEggColor, int fgEggColor) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)entityID++, (Object)instance, (int)80, (int)3, (boolean)true, (int)bkEggColor, (int)fgEggColor);
    }

    private void addSpawn(Class<? extends EntityLiving> entityClass, int spawnProb, int min, int max, Biome[] biomes) {
        if (spawnProb > 0) {
            EntityRegistry.addSpawn(entityClass, (int)spawnProb, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        }
    }

    private Biome[] getBiomes(BiomeDictionary.Type ... types) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        for (BiomeDictionary.Type t : types) {
            Biome[] biomes;
            for (Biome bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t)) {
                if (BiomeDictionary.isBiomeOfType((Biome)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.isBiomeOfType((Biome)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || bgb.func_185359_l().contains("Void") || BiomeDictionary.isBiomeOfType((Biome)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || bgb.func_185353_n() < 0.32f || BiomeDictionary.isBiomeOfType((Biome)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || list.contains(bgb)) continue;
                list.add(bgb);
                proxy.info("  >>> Adding " + bgb.func_185359_l() + " for spawning");
            }
        }
        return list.toArray(new Biome[0]);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(modid)) {
            proxy.info("Configuration changes have been updated for the Reptile Mod");
            ConfigHandler.updateConfigInfo();
        }
    }
}

