/*
 * Decompiled with CFR 0.152.
 */
package com.reptiles.common;

import com.reptiles.common.ConfigHandler;
import com.reptiles.common.ReptileSounds;
import com.reptiles.common.Reptiles;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityVaranus
extends EntityTameable {
    private final int maxHealth = 20;
    private final float scaleFactor;
    private static final DataParameter<Float> health = EntityDataManager.func_187226_a(EntityVaranus.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityVaranus(World world) {
        super(world);
        float scale;
        this.func_70105_a(0.4f, 0.85f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.scaleFactor = ConfigHandler.useRandomScaling() ? ((scale = this.field_70146_Z.nextFloat()) < 0.55f ? 1.0f : scale) : 1.0f;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        double moveSpeed = 1.0;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.38));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151147_al, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151157_am, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, entity -> {
            if (this.field_70146_Z.nextInt(6) == 0) {
                return entity instanceof EntityPig || entity instanceof EntityRabbit;
            }
            return false;
        }));
        if (ConfigHandler.getFollowOwner()) {
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, moveSpeed, 10.0f, 2.0f));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, moveSpeed));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, moveSpeed));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(health, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbase) {
        super.func_70624_b(entitylivingbase);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public EntityAnimal spawnBabyAnimal(EntityAgeable entityageable) {
        Reptiles.proxy.error("[ERROR] Do NOT call this base class method directly!");
        return null;
    }

    protected boolean func_70692_ba() {
        return ConfigHandler.shouldDespawn() && !this.func_70909_n();
    }

    public int func_70641_bl() {
        return 8;
    }

    public int func_70627_aG() {
        return ConfigHandler.getTalkInterval();
    }

    protected float func_70599_aP() {
        return ConfigHandler.getTalkVolume();
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    protected SoundEvent func_184639_G() {
        return ReptileSounds.varanus_hiss;
    }

    protected SoundEvent func_184601_bQ() {
        return ReptileSounds.varanus_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ReptileSounds.varanus_hurt;
    }

    protected void func_180429_a(BlockPos blockPos, Block block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    protected void func_70628_a(boolean flag, int add) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + add);
        this.func_145779_a(Items.field_151116_aA, count);
        count = this.field_70146_Z.nextInt(3) + 1 + this.field_70146_Z.nextInt(1 + add);
        if (this.func_70027_ad()) {
            this.func_145779_a(Items.field_151083_be, count);
        } else {
            this.func_145779_a(Items.field_151082_bd, count);
        }
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_142018_a(EntityLivingBase entityToAttack, EntityLivingBase entityOwner) {
        if (!(entityToAttack instanceof EntityCreeper) && !(entityToAttack instanceof EntityGhast)) {
            EntityVaranus entityvaranus;
            if (entityToAttack instanceof EntityVaranus && (entityvaranus = (EntityVaranus)entityToAttack).func_70909_n() && entityvaranus.func_70902_q() == entityOwner) {
                return false;
            }
            return entityToAttack instanceof EntityPlayer && entityOwner instanceof EntityPlayer && !((EntityPlayer)entityOwner).func_96122_a((EntityPlayer)entityToAttack) ? false : !(entityToAttack instanceof EntityHorse) || !((EntityHorse)entityToAttack).func_110248_bS();
        }
        return false;
    }

    private boolean isFavoriteFood(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == Items.field_151157_am;
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ItemFood && this.isFavoriteFood(itemStack);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(health, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand enumHand) {
        ItemStack itemstack = entityplayer.func_184586_b(enumHand);
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood) {
                ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                if (this.isFavoriteFood(itemstack) && ((Float)this.field_70180_af.func_187225_a(health)).floatValue() < 20.0f) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(itemfood.func_150905_g(itemstack));
                    return true;
                }
            }
            if (this.func_152114_e((EntityLivingBase)entityplayer) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (itemstack.func_77973_b() == Items.field_151147_al) {
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_184754_b(entityplayer.func_110124_au());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(entityplayer, enumHand);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityVaranus)) {
            return false;
        }
        EntityVaranus v = (EntityVaranus)otherAnimal;
        return v.func_70909_n() && !v.func_70906_o() && this.func_70880_s() && v.func_70880_s();
    }

    public EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.spawnBabyAnimal(entityAgeable);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return super.func_184652_a(player);
    }
}

