/*
 * Decompiled with CFR 0.152.
 */
package com.reptiles.common;

import com.reptiles.common.Reptiles;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config;
    private static int komodoSpawnProb;
    private static int griseusSpawnProb;
    private static int laceSpawnProb;
    private static int perentieSpawnProb;
    private static int savannaSpawnProb;
    private static int crocSpawnProb;
    private static int largeCrocSpawnProb;
    private static int desertTortoiseSpawnProb;
    private static int littleTurtleSpawnProb;
    private static int iguanaSpawnProb;
    private static int tortoiseSpawnProb;
    private static int gatorSpawnProb;
    private static int chameleonSpawnProb;
    private static int crocMonitorSpawnProb;
    private static int minSpawn;
    private static int maxSpawn;
    private static int talkInterval;
    private static double talkvolume;
    private static boolean despawn;
    private static boolean randomScale;
    private static boolean followOwner;
    private static final String comments = "Reptile Mod Config\n Michael Sheppard (crackedEgg)\n For Minecraft Version 1.11.2";
    private static final String randomScaleComment = "Set to false to disable random scaling of monitors, default is true.";
    private static final String despawnComment = "Set to false to not despawn. default is true.";
    private static final String followOwnerComment = "Set to false to have tamed monitors not follow owner, default is true.";
    private static final String spawnProbComment = "Spawn Probability\nSet to zero to disable spawning of this entity";
    private static final String minSpawnComment = "Minimum number of reptiles to spawn at one time";
    private static final String maxSpawnComment = "Maximum number of reptiles to spawn at one time";
    private static final String talkIntervalComment = "time interval between ambient sounds";
    private static final String talkVolumeComment = "volume of reptile sounds";

    public static void startConfig(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigHandler.updateConfigInfo();
    }

    public static void updateConfigInfo() {
        try {
            config.addCustomCategoryComment("general", comments);
            komodoSpawnProb = config.get("general", "komodoSpawnProb", 10, spawnProbComment).getInt();
            griseusSpawnProb = config.get("general", "griseusSpawnProb", 12, spawnProbComment).getInt();
            laceSpawnProb = config.get("general", "laceSpawnProb", 12, spawnProbComment).getInt();
            perentieSpawnProb = config.get("general", "perentieSpawnProb", 12, spawnProbComment).getInt();
            savannaSpawnProb = config.get("general", "savannaSpawnProb", 12, spawnProbComment).getInt();
            crocSpawnProb = config.get("general", "crocSpawnProb", 5, spawnProbComment).getInt();
            largeCrocSpawnProb = config.get("general", "largeCrocSpawnProb", 4, spawnProbComment).getInt();
            desertTortoiseSpawnProb = config.get("general", "desertTortoiseSpawnProb", 12, spawnProbComment).getInt();
            littleTurtleSpawnProb = config.get("general", "littleTurtleSpawnProb", 10, spawnProbComment).getInt();
            iguanaSpawnProb = config.get("general", "iguanaSpawnProb", 12, spawnProbComment).getInt();
            tortoiseSpawnProb = config.get("general", "tortoiseSpawnProb", 12, spawnProbComment).getInt();
            gatorSpawnProb = config.get("general", "gatorSpawnProb", 5, spawnProbComment).getInt();
            chameleonSpawnProb = config.get("general", "chameleonSpawnProb", 12, spawnProbComment).getInt();
            crocMonitorSpawnProb = config.get("general", "crocMonitorSpawnProb", 12, spawnProbComment).getInt();
            minSpawn = config.get("general", "minSpawn", 1, minSpawnComment).getInt();
            maxSpawn = config.get("general", "maxSpawn", 4, maxSpawnComment).getInt();
            talkInterval = config.get("general", "talkInterval", 320, talkIntervalComment).getInt();
            talkvolume = config.get("general", "talkVolume", 0.3, talkVolumeComment).getDouble();
            randomScale = config.get("general", "randomScale", true, randomScaleComment).getBoolean(true);
            despawn = config.get("general", "despawn", true, despawnComment).getBoolean(true);
            followOwner = config.get("general", "followOwner", true, followOwnerComment).getBoolean(true);
        }
        catch (Exception e) {
            Reptiles.proxy.info("failed to load or read the config file");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static boolean useRandomScaling() {
        return randomScale;
    }

    public static boolean shouldDespawn() {
        return despawn;
    }

    public static boolean getFollowOwner() {
        return followOwner;
    }

    public static int getKomodoSpawnProb() {
        return komodoSpawnProb;
    }

    public static int getGriseusSpawnProb() {
        return griseusSpawnProb;
    }

    public static int getLaceSpawnProb() {
        return laceSpawnProb;
    }

    public static int getPerentieSpawnProb() {
        return perentieSpawnProb;
    }

    public static int getSavannaSpawnProb() {
        return savannaSpawnProb;
    }

    public static int getCrocSpawnProb() {
        return crocSpawnProb;
    }

    public static int getLargeCrocSpawnProb() {
        return largeCrocSpawnProb;
    }

    public static int getDesertTortoiseSpawnProb() {
        return desertTortoiseSpawnProb;
    }

    public static int getLittleTurtleSpawnProb() {
        return littleTurtleSpawnProb;
    }

    public static int getIguanaSpawnProb() {
        return iguanaSpawnProb;
    }

    public static int getTortoiseSpawnProb() {
        return tortoiseSpawnProb;
    }

    public static int getGatorSpawnProb() {
        return gatorSpawnProb;
    }

    public static int getChameleonSpawnProb() {
        return chameleonSpawnProb;
    }

    public static int getCrocMonitorSpawnProb() {
        return crocMonitorSpawnProb;
    }

    public static int getMinSpawn() {
        return minSpawn;
    }

    public static int getMaxSpawn() {
        return maxSpawn;
    }

    public static int getTalkInterval() {
        return talkInterval;
    }

    public static float getTalkVolume() {
        return (float)talkvolume;
    }
}

