/*
 * Decompiled with CFR 0.152.
 */
package crackedzombie.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import crackedzombie.common.CommonProxyCrackedZombie;
import crackedzombie.common.EntityCrackedZombie;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DungeonHooks;

@Mod(modid="CrackedZombieMod", name="CrackedZombie Mod", version="1.6.4")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, versionBounds="[1.6.4]")
public class CrackedZombie {
    @Mod.Instance
    public static CrackedZombie instance;
    public static final String version = "1.6.4";
    public static final String modid = "CrackedZombieMod";
    public static final String name = "CrackedZombie Mod";
    private int crackedSpawnProb;
    private int crackedSpawns;
    private boolean spawnCreepers;
    private boolean spawnZombies;
    private boolean spawnSkeletons;
    private boolean spawnEnderman;
    private boolean spawnSpiders;
    private boolean spawnSlime;
    private boolean randomSkins;
    private boolean doorBusting;
    private static final Logger logger;
    @SidedProxy(clientSide="crackedzombie.client.ClientProxyCrackedZombie", serverSide="crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    public String getVersion() {
        return version;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.setParent(FMLLog.getLogger());
        String generalComments = "CrackedZombie Mod Config\nMichael Sheppard (crackedEgg)\n";
        String spawnProbComment = "crackedSpawnProb adjust to probability of zombies spawning,\nalthough the custom spawning most likely overrides this. the higher the\nthe number the more likely zombies will spawn.";
        String crackedComment = "walkerSpawns adjusts the number of zombies spawned, play\nwith it to see what you like. The higher the number the more\nzombies will spawn.";
        String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true\nif you want to spawn creepers";
        String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true\nif you want to spawn skeletons";
        String zombieComment = "zombieSpawns, set to false to disable zombie spawning, set to true\nif you want to spawn zombies. Note that spawning zombies and other monsters\nwill cause the number of crackeds spawned to be reduced.";
        String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true\nif you want to spawn enderman";
        String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true\nif you want to spawn spiders";
        String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true\nif you want to spawn slimes";
        String doorBustingComment = "doorBusting, set to true to have crackeds try to break down doors,\notherwise set to false. It's quieter.";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.crackedSpawnProb = config.get("general", "zombiesSpawnProb", 10, spawnProbComment).getInt();
        this.crackedSpawns = config.get("general", "crackedSpawns", 60, crackedComment).getInt();
        this.spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
        this.spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
        this.spawnZombies = config.get("general", "spawnZombies", false, zombieComment).getBoolean(false);
        this.spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
        this.spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(false);
        this.spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
        this.doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        proxy.registerRenderers();
        proxy.registerWorldTickHandler();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityCrackedZombie.class, (String)"CrackedZombie", (int)id);
        EntityList.field_75627_a.put(id, new EntityEggInfo(id, 44975, 7969861));
        LanguageRegistry.instance().addStringLocalization("entity.CrackedZombie.name", "CrackedZombie");
        logger.info("*** Scanning for available biomes");
        BiomeGenBase[] biomes = this.getBiomeList();
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)this.crackedSpawnProb, (int)2, (int)10, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        DungeonHooks.addDungeonMob((String)"CrackedZombie", (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77716_q), 1, 1, 4));
        if (!this.spawnCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            logger.info("*** Removing creeper spawns");
        }
        if (!this.spawnSkeletons) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
            logger.info("*** Removing skeleton spawns and dungeon spawners");
        }
        if (!this.spawnZombies) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
            logger.info("*** Removing zombie spawns and dungeon spawners");
        }
        if (!this.spawnEnderman) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            logger.info("*** Removing enderman spawns");
        }
        if (!this.spawnSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
            logger.info("*** Removing spider spawns and dungeon spawners");
        }
        if (!this.spawnSlime) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            logger.info("*** Removing slime spawns");
        }
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomes();
    }

    public BiomeGenBase[] getBiomeList() {
        BiomeDictionary.Type[] t;
        LinkedList<BiomeGenBase> linkedlist = new LinkedList<BiomeGenBase>();
        for (BiomeDictionary.Type type : t = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MUSHROOM}) {
            BiomeGenBase[] biomes;
            for (BiomeGenBase bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (linkedlist.contains(bgb)) continue;
                String s = " >>> Adding " + bgb.field_76791_y + " for spawning";
                logger.info(s);
                linkedlist.add(bgb);
            }
        }
        return linkedlist.toArray(new BiomeGenBase[0]);
    }

    public int getWalkerSpawns() {
        return this.crackedSpawns;
    }

    public boolean getRandomSkins() {
        return this.randomSkins;
    }

    public boolean getDoorBusting() {
        return this.doorBusting;
    }

    static {
        logger = Logger.getLogger(modid);
    }
}

